/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.util.AEColor;
import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseItemBlock;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.render.WorldRender;
import appeng.client.texture.FlipableIcon;
import appeng.client.texture.MissingIcon;
import appeng.core.features.AEFeature;
import appeng.core.features.AEFeatureHandler;
import appeng.core.features.IAEFeature;
import appeng.core.features.ItemStackSrc;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import appeng.tile.storage.TileSkyChest;
import appeng.util.LookDirection;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AEBaseBlock
extends BlockContainer
implements IAEFeature {
    private String FeatureFullname;
    private String FeatureSubname;
    private AEFeatureHandler feature;
    private Class<? extends TileEntity> tileEntityType = null;
    protected boolean isOpaque = true;
    protected boolean isFullSize = true;
    protected boolean hasSubtypes = false;
    protected boolean isInventory = false;
    @SideOnly(value=Side.CLIENT)
    public IIcon renderIcon;
    @SideOnly(value=Side.CLIENT)
    BlockRenderInfo renderInfo;

    public String toString() {
        return this.FeatureFullname;
    }

    @SideOnly(value=Side.CLIENT)
    protected Class<? extends BaseBlockRender> getRenderer() {
        return BaseBlockRender.class;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return WorldRender.instance.getRenderId();
    }

    @SideOnly(value=Side.CLIENT)
    private FlipableIcon optionaIcon(IIconRegister ir, String Name, IIcon substitute) {
        while (substitute instanceof FlipableIcon) {
            substitute = ((FlipableIcon)substitute).getOriginal();
        }
        if (substitute != null) {
            try {
                ResourceLocation resLoc = new ResourceLocation(Name);
                resLoc = new ResourceLocation(resLoc.func_110624_b(), String.format("%s/%s%s", "textures/blocks", resLoc.func_110623_a(), ".png"));
                IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);
                if (res != null) {
                    return new FlipableIcon(ir.func_94245_a(Name));
                }
            }
            catch (Throwable e) {
                return new FlipableIcon(substitute);
            }
        }
        return new FlipableIcon(ir.func_94245_a(Name));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegistry) {
        BlockRenderInfo info = this.getRendererInstance();
        FlipableIcon topIcon = this.optionaIcon(iconRegistry, this.func_149641_N(), null);
        this.field_149761_L = topIcon;
        FlipableIcon bottomIcon = this.optionaIcon(iconRegistry, this.func_149641_N() + "Bottom", topIcon);
        FlipableIcon sideIcon = this.optionaIcon(iconRegistry, this.func_149641_N() + "Side", topIcon);
        FlipableIcon eastIcon = this.optionaIcon(iconRegistry, this.func_149641_N() + "East", sideIcon);
        FlipableIcon westIcon = this.optionaIcon(iconRegistry, this.func_149641_N() + "West", sideIcon);
        FlipableIcon southIcon = this.optionaIcon(iconRegistry, this.func_149641_N() + "Front", sideIcon);
        FlipableIcon northIcon = this.optionaIcon(iconRegistry, this.func_149641_N() + "Back", sideIcon);
        info.updateIcons(bottomIcon, topIcon, northIcon, southIcon, eastIcon, westIcon);
    }

    public void registerNoIcons() {
        BlockRenderInfo info = this.getRendererInstance();
        FlipableIcon i = new FlipableIcon(new MissingIcon(this));
        info.updateIcons(i, i, i, i, i, i);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        if (this.renderIcon != null) {
            return this.renderIcon;
        }
        return this.getRendererInstance().getTexture(ForgeDirection.getOrientation((int)direction));
    }

    public IIcon unmappedGetIcon(IBlockAccess w, int x, int y, int z, int s) {
        return super.func_149673_e(w, x, y, z, s);
    }

    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        return this.func_149691_a(this.mapRotation(w, x, y, z, s), w.func_72805_g(x, y, z));
    }

    protected void setTileEntiy(Class<? extends TileEntity> c) {
        AEBaseTile.registerTileItem(c, new ItemStackSrc((Block)this, 0));
        this.tileEntityType = c;
        GameRegistry.registerTileEntity(this.tileEntityType, (String)this.FeatureFullname);
        this.isInventory = IInventory.class.isAssignableFrom(c);
        this.setTileProvider(this.hasBlockTileEntity());
    }

    protected void setfeature(EnumSet<AEFeature> f) {
        this.feature = new AEFeatureHandler(f, this, this.FeatureSubname);
    }

    protected AEBaseBlock(Class<?> c, Material mat) {
        this(c, mat, null);
        this.func_149713_g(255);
        this.func_149715_a(0.0f);
        this.func_149711_c(2.2f);
        this.setTileProvider(false);
        this.setHarvestLevel("pickaxe", 0);
    }

    private void setTileProvider(boolean b) {
        ReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)b, (String[])new String[]{"isTileProvider"});
    }

    protected AEBaseBlock(Class<?> c, Material mat, String subname) {
        super(mat);
        if (mat == AEGlassMaterial.instance) {
            this.func_149672_a(Block.field_149778_k);
        } else if (mat == Material.field_151592_s) {
            this.func_149672_a(Block.field_149778_k);
        } else if (mat == Material.field_151576_e) {
            this.func_149672_a(Block.field_149769_e);
        } else {
            this.func_149672_a(Block.field_149777_j);
        }
        this.FeatureFullname = AEFeatureHandler.getName(c, subname);
        this.FeatureSubname = subname;
    }

    @Override
    public final AEFeatureHandler feature() {
        return this.feature;
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public final boolean func_149662_c() {
        return this.isOpaque;
    }

    public boolean func_149686_d() {
        return this.isFullSize && this.isOpaque;
    }

    public final boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return this.isFullSize;
    }

    public boolean hasBlockTileEntity() {
        return this.tileEntityType != null;
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return this.tileEntityType;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderStateByMeta(int itemDamage) {
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderInfo getRendererInstance() {
        if (this.renderInfo != null) {
            return this.renderInfo;
        }
        try {
            this.renderInfo = new BlockRenderInfo(this.getRenderer().newInstance());
            return this.renderInfo;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public final TileEntity func_149915_a(World var1, int var2) {
        if (this.hasBlockTileEntity()) {
            try {
                return this.tileEntityType.newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public <T extends TileEntity> T getTileEntity(IBlockAccess w, int x, int y, int z) {
        if (!this.hasBlockTileEntity()) {
            return null;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        if (this.tileEntityType.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, ForgeDirection axis) {
    }

    public final boolean rotateBlock(World w, int x, int y, int z, ForgeDirection axis) {
        IOrientable rotatable = null;
        if (this.hasBlockTileEntity()) {
            rotatable = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        } else if (this instanceof IOrientableBlock) {
            rotatable = ((IOrientableBlock)((Object)this)).getOrientable((IBlockAccess)w, x, y, z);
        }
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, axis);
                return true;
            }
            ForgeDirection forward = rotatable.getForward();
            ForgeDirection up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(w, x, y, z, forward = Platform.rotateAround(forward, axis), up = Platform.rotateAround(up, axis))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return super.rotateBlock(w, x, y, z, axis);
    }

    public ForgeDirection mapRotation(IOrientable ori, ForgeDirection dir) {
        ForgeDirection forward = ori.getForward();
        ForgeDirection up = ori.getUp();
        ForgeDirection west = ForgeDirection.UNKNOWN;
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir.equals((Object)forward)) {
            return ForgeDirection.SOUTH;
        }
        if (dir.equals((Object)forward.getOpposite())) {
            return ForgeDirection.NORTH;
        }
        if (dir.equals((Object)up)) {
            return ForgeDirection.UP;
        }
        if (dir.equals((Object)up.getOpposite())) {
            return ForgeDirection.DOWN;
        }
        if (dir.equals((Object)west)) {
            return ForgeDirection.WEST;
        }
        if (dir.equals((Object)west.getOpposite())) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    int mapRotation(IBlockAccess w, int x, int y, int z, int s) {
        IOrientable ori = null;
        if (this.hasBlockTileEntity()) {
            ori = (AEBaseTile)this.getTileEntity(w, x, y, z);
        } else if (this instanceof IOrientableBlock) {
            ori = ((IOrientableBlock)((Object)this)).getOrientable(w, x, y, z);
        }
        if (ori != null && ori.canBeRotated()) {
            return this.mapRotation(ori, ForgeDirection.getOrientation((int)s)).ordinal();
        }
        return s;
    }

    public final ForgeDirection[] getValidRotations(World w, int x, int y, int z) {
        AEBaseTile obj;
        if (this.hasBlockTileEntity() && (obj = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z)) != null && obj.canBeRotated()) {
            return ForgeDirection.VALID_DIRECTIONS;
        }
        return new ForgeDirection[0];
    }

    public void func_149749_a(World w, int x, int y, int z, Block a, int b) {
        AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te != null && te.dropItems) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            te.getDrops(w, x, y, z, drops);
            Platform.spawnDrops(w, x, y, z, drops);
        }
        super.func_149749_a(w, x, y, z, a, b);
        if (te != null) {
            w.func_147455_a(x, y, z, null);
        }
    }

    public MovingObjectPosition func_149731_a(World w, int x, int y, int z, Vec3 a, Vec3 b) {
        ICustomCollision collisionHandler = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null) {
            Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxsFromPool(w, x, y, z, null, true);
            MovingObjectPosition br = null;
            double lastDist = 0.0;
            for (AxisAlignedBB bb : bbs) {
                this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
                MovingObjectPosition r = super.func_149731_a(w, x, y, z, a, b);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (r == null) continue;
                double xLen = a.field_72450_a - r.field_72307_f.field_72450_a;
                double yLen = a.field_72448_b - r.field_72307_f.field_72448_b;
                double zLen = a.field_72449_c - r.field_72307_f.field_72449_c;
                double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                if (br != null && !(lastDist > thisDist)) continue;
                lastDist = thisDist;
                br = r;
            }
            if (br != null) {
                return br;
            }
            return null;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_149731_a(w, x, y, z, a, b);
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB func_149633_g(World w, int x, int y, int z) {
        ICustomCollision collisionHandler = null;
        AxisAlignedBB b = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null) {
            if (Platform.isClient()) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                LookDirection ld = Platform.getPlayerRay((EntityPlayer)player, Platform.getEyeOffset((EntityPlayer)player));
                Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxsFromPool(w, x, y, z, (Entity)Minecraft.func_71410_x().field_71439_g, true);
                AxisAlignedBB br = null;
                double lastDist = 0.0;
                for (AxisAlignedBB bb : bbs) {
                    this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
                    MovingObjectPosition r = super.func_149731_a(w, x, y, z, ld.a, ld.b);
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    if (r == null) continue;
                    double xLen = ld.a.field_72450_a - r.field_72307_f.field_72450_a;
                    double yLen = ld.a.field_72448_b - r.field_72307_f.field_72448_b;
                    double zLen = ld.a.field_72449_c - r.field_72307_f.field_72449_c;
                    double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                    if (br != null && !(lastDist > thisDist)) continue;
                    lastDist = thisDist;
                    br = bb;
                }
                if (br != null) {
                    br.func_72324_b(br.field_72340_a + (double)x, br.field_72338_b + (double)y, br.field_72339_c + (double)z, br.field_72336_d + (double)x, br.field_72337_e + (double)y, br.field_72334_f + (double)z);
                    return br;
                }
            }
            for (AxisAlignedBB bx : collisionHandler.getSelectedBoundingBoxsFromPool(w, x, y, z, null, false)) {
                if (b == null) {
                    b = bx;
                    continue;
                }
                double minX = Math.min(b.field_72340_a, bx.field_72340_a);
                double minY = Math.min(b.field_72338_b, bx.field_72338_b);
                double minZ = Math.min(b.field_72339_c, bx.field_72339_c);
                double maxX = Math.max(b.field_72336_d, bx.field_72336_d);
                double maxY = Math.max(b.field_72337_e, bx.field_72337_e);
                double maxZ = Math.max(b.field_72334_f, bx.field_72334_f);
                b.func_72324_b(minX, minY, minZ, maxX, maxY, maxZ);
            }
            b.func_72324_b(b.field_72340_a + (double)x, b.field_72338_b + (double)y, b.field_72339_c + (double)z, b.field_72336_d + (double)x, b.field_72337_e + (double)y, b.field_72334_f + (double)z);
        } else {
            b = super.func_149633_g(w, x, y, z);
        }
        return b;
    }

    public void func_149743_a(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
        ICustomCollision collisionHandler = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null && bb != null) {
            ArrayList tmp = new ArrayList();
            collisionHandler.addCollidingBlockToList(w, x, y, z, bb, tmp, e);
            for (AxisAlignedBB b : tmp) {
                b.field_72340_a += (double)x;
                b.field_72338_b += (double)y;
                b.field_72339_c += (double)z;
                b.field_72336_d += (double)x;
                b.field_72337_e += (double)y;
                b.field_72334_f += (double)z;
                if (!bb.func_72326_a(b)) continue;
                out.add(b);
            }
        } else {
            super.func_149743_a(w, x, y, z, bb, out, e);
        }
    }

    public void func_149664_b(World par1World, int par2, int par3, int par4, int par5) {
        super.func_149664_b(par1World, par2, par3, par4, par5);
    }

    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public final boolean func_149727_a(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack is;
        if (player != null && (is = player.field_71071_by.func_70448_g()) != null) {
            if (Platform.isWrench(player, is, x, y, z) && player.func_70093_af()) {
                Block id = w.func_147439_a(x, y, z);
                if (id != null) {
                    AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                    ItemStack[] drops = Platform.getBlockDrops(w, x, y, z);
                    if (tile == null) {
                        return false;
                    }
                    if (tile instanceof TileCableBus || tile instanceof TileSkyChest) {
                        return false;
                    }
                    ItemStack op = new ItemStack((Block)this);
                    for (ItemStack ol : drops) {
                        NBTTagCompound tag;
                        if (!Platform.isSameItemType(ol, op) || (tag = tile.downloadSettings(SettingsFrom.DISMANTLE_ITEM)) == null) continue;
                        ol.func_77982_d(tag);
                    }
                    if (id.removedByPlayer(w, player, x, y, z, false)) {
                        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
                        for (ItemStack iss : drops) {
                            l.add(iss);
                        }
                        Platform.spawnDrops(w, x, y, z, l);
                        w.func_147468_f(x, y, z);
                    }
                }
                return false;
            }
            if (is.func_77973_b() instanceof IMemoryCard && !(this instanceof BlockCableBus)) {
                IMemoryCard memc = (IMemoryCard)is.func_77973_b();
                if (player.func_70093_af()) {
                    AEBaseTile t = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                    if (t != null) {
                        String name = this.func_149739_a();
                        NBTTagCompound data = t.downloadSettings(SettingsFrom.MEMORY_CARD);
                        if (data != null) {
                            memc.setMemoryCardContents(is, name, data);
                            memc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                            return true;
                        }
                    }
                } else {
                    String name = memc.getSettingsName(is);
                    NBTTagCompound data = memc.getData(is);
                    if (this.func_149739_a().equals(name)) {
                        AEBaseTile t = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                        t.uploadSettings(SettingsFrom.MEMORY_CARD, data);
                        memc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        memc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    }
                    return false;
                }
            }
        }
        return this.onActivated(w, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        return true;
    }

    public String getUnlocalizedName(ItemStack is) {
        return this.func_149739_a();
    }

    public void addInformation(ItemStack is, EntityPlayer player, List<?> lines, boolean advancedItemTooltips) {
    }

    public Class<AEBaseItemBlock> getItemBlockClass() {
        return AEBaseItemBlock.class;
    }

    @Override
    public void postInit() {
    }

    public boolean hasSubtypes() {
        return this.hasSubtypes;
    }

    public boolean func_149740_M() {
        return this.isInventory;
    }

    public int func_149736_g(World w, int x, int y, int z, int s) {
        Object te = this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof IColorableTile) {
            AEColor newColor;
            IColorableTile ct = (IColorableTile)te;
            AEColor c = ct.getColor();
            if (c != (newColor = AEColor.values()[colour])) {
                ct.recolourBlock(side, newColor, null);
                return true;
            }
            return false;
        }
        return super.recolourBlock(world, x, y, z, side, colour);
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase player, ItemStack is) {
        Object te;
        if (is.func_82837_s() && (te = this.getTileEntity((IBlockAccess)w, x, y, z)) instanceof AEBaseTile) {
            ((AEBaseTile)w.func_147438_o(x, y, z)).setName(is.func_82833_r());
        }
    }
}

