/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseItemBlock;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AEBaseItemBlockChargeable
extends AEBaseItemBlock
implements IAEItemPowerStorage {
    public AEBaseItemBlockChargeable(Block id) {
        super(id);
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        NBTTagCompound tag = is.func_77978_p();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getMax(is);
        if (tag != null) {
            internalCurrentPower = tag.func_74769_h("internalCurrentPower");
        }
        double percent = internalCurrentPower / internalMaxPower;
        lines.add(GuiText.StoredEnergy.getLocal() + ":" + MessageFormat.format(" {0,number,#} ", internalCurrentPower) + Platform.gui_localize(PowerUnits.AE.unlocalizedName) + " - " + MessageFormat.format(" {0,number,#.##%} ", percent));
    }

    private double getMax(ItemStack is) {
        Block blk = Block.func_149634_a((Item)this);
        if (blk == AEApi.instance().blocks().blockEnergyCell.block()) {
            return 200000.0;
        }
        return 1600000.0;
    }

    private double getInternal(ItemStack is) {
        NBTTagCompound nbt = Platform.openNbtData(is);
        return nbt.func_74769_h("internalCurrentPower");
    }

    private void setInternal(ItemStack is, double amt) {
        NBTTagCompound nbt = Platform.openNbtData(is);
        nbt.func_74780_a("internalCurrentPower", amt);
    }

    @Override
    public double injectAEPower(ItemStack is, double amt) {
        double internalCurrentPower = this.getInternal(is);
        double internalMaxPower = this.getMax(is);
        if ((internalCurrentPower += amt) > internalMaxPower) {
            amt = internalCurrentPower - internalMaxPower;
            internalCurrentPower = internalMaxPower;
            this.setInternal(is, internalCurrentPower);
            return amt;
        }
        this.setInternal(is, internalCurrentPower);
        return 0.0;
    }

    @Override
    public double extractAEPower(ItemStack is, double amt) {
        double internalCurrentPower = this.getInternal(is);
        if (internalCurrentPower > amt) {
            this.setInternal(is, internalCurrentPower -= amt);
            return amt;
        }
        amt = internalCurrentPower;
        this.setInternal(is, 0.0);
        return amt;
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        double internalMaxPower = this.getMax(is);
        return internalMaxPower;
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        double internalCurrentPower = this.getInternal(is);
        return internalCurrentPower;
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }
}

