/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderBlockCrank;
import appeng.core.features.AEFeature;
import appeng.tile.AEBaseTile;
import appeng.tile.grindstone.TileCrank;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrank
extends AEBaseBlock {
    public BlockCrank() {
        super(BlockCrank.class, Material.field_151575_d);
        this.setfeature(EnumSet.of(AEFeature.GrindStone));
        this.setTileEntiy(TileCrank.class);
        this.func_149713_g(0);
        this.isOpaque = false;
        this.isFullSize = false;
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        if (p instanceof FakePlayer) {
            return true;
        }
        AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile instanceof TileCrank) {
            ((TileCrank)tile).power();
        }
        return true;
    }

    @Override
    public Class<? extends BaseBlockRender> getRenderer() {
        return RenderBlockCrank.class;
    }

    private boolean isCrankable(World w, int x, int y, int z, ForgeDirection offset) {
        TileEntity te = w.func_147438_o(x + offset.offsetX, y + offset.offsetY, z + offset.offsetZ);
        if (te instanceof ICrankable) {
            return ((ICrankable)te).canCrankAttach(offset.getOpposite());
        }
        return false;
    }

    private ForgeDirection findCrankable(World w, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isCrankable(w, x, y, z, dir)) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    public boolean func_149742_c(World w, int x, int y, int z) {
        return this.findCrankable(w, x, y, z) != ForgeDirection.UNKNOWN;
    }

    @Override
    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        TileEntity te = w.func_147438_o(x, y, z);
        return !(te instanceof TileCrank) || this.isCrankable(w, x, y, z, up.getOpposite());
    }

    private void dropCrank(World w, int x, int y, int z) {
        w.func_147480_a(x, y, z, true);
        w.func_147471_g(x, y, z);
    }

    @Override
    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase p, ItemStack is) {
        AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile != null) {
            ForgeDirection mnt = this.findCrankable(w, x, y, z);
            ForgeDirection forward = ForgeDirection.UP;
            if (mnt == ForgeDirection.UP || mnt == ForgeDirection.DOWN) {
                forward = ForgeDirection.SOUTH;
            }
            tile.setOrientation(forward, mnt.getOpposite());
        } else {
            this.dropCrank(w, x, y, z);
        }
    }

    public void func_149695_a(World w, int x, int y, int z, Block id) {
        AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile != null) {
            if (!this.isCrankable(w, x, y, z, tile.getUp().getOpposite())) {
                this.dropCrank(w, x, y, z);
            }
        } else {
            this.dropCrank(w, x, y, z);
        }
    }
}

