/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderBlockSkyCompass;
import appeng.core.features.AEFeature;
import appeng.helpers.ICustomCollision;
import appeng.tile.misc.TileSkyCompass;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSkyCompass
extends AEBaseBlock
implements ICustomCollision {
    public BlockSkyCompass() {
        super(BlockSkyCompass.class, Material.field_151573_f);
        this.setfeature(EnumSet.of(AEFeature.MeteoriteCompass));
        this.setTileEntiy(TileSkyCompass.class);
        this.isFullSize = false;
        this.isOpaque = false;
        this.field_149786_r = 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        return Blocks.field_150339_S.func_149691_a(direction, metadata);
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderBlockSkyCompass.class;
    }

    private void dropTorch(World w, int x, int y, int z) {
        w.func_147480_a(x, y, z, true);
        w.func_147471_g(x, y, z);
    }

    public boolean func_149742_c(World w, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.canPlaceAt(w, x, y, z, dir)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World w, int x, int y, int z, ForgeDirection dir) {
        return w.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite(), false);
    }

    @Override
    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        TileSkyCompass sc = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (sc != null) {
            return false;
        }
        return this.canPlaceAt(w, x, y, z, forward.getOpposite());
    }

    public void func_149695_a(World w, int x, int y, int z, Block id) {
        TileSkyCompass sc = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, x, y, z);
        ForgeDirection up = sc.getForward();
        if (!this.canPlaceAt(w, x, y, z, up.getOpposite())) {
            this.dropTorch(w, x, y, z);
        }
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxsFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        TileSkyCompass tile = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile != null) {
            ForgeDirection forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 1.0;
                    minY = 0.875;
                    break;
                }
                case EAST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 0.125;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 1.0;
                    minZ = 0.875;
                    break;
                }
                case SOUTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 0.125;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 0.125;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 1.0;
                    minX = 0.875;
                    break;
                }
            }
            return Arrays.asList(AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        }
        return Arrays.asList(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
    }

    @Override
    public void func_149651_a(IIconRegister iconRegistry) {
    }
}

