/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseBlock;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.tile.AEBaseTile;
import appeng.tile.misc.TileVibrationChamber;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockVibrationChamber
extends AEBaseBlock {
    public BlockVibrationChamber() {
        super(BlockVibrationChamber.class, Material.field_151573_f);
        this.setfeature(EnumSet.of(AEFeature.PowerGen));
        this.setTileEntiy(TileVibrationChamber.class);
        this.func_149711_c(4.2f);
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileVibrationChamber tc;
        if (player.func_70093_af()) {
            return false;
        }
        if (Platform.isServer() && (tc = (TileVibrationChamber)this.getTileEntity((IBlockAccess)w, x, y, z)) != null && !player.func_70093_af()) {
            Platform.openGUI(player, tc, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_VIBRATIONCHAMBER);
            return true;
        }
        return true;
    }

    @Override
    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        IIcon ico = super.func_149673_e(w, x, y, z, s);
        TileVibrationChamber tvc = (TileVibrationChamber)this.getTileEntity(w, x, y, z);
        if (tvc != null && tvc.isOn && ico == this.getRendererInstance().getTexture(ForgeDirection.SOUTH)) {
            return ExtraBlockTextures.BlockVibrationChamberFrontOn.getIcon();
        }
        return ico;
    }

    public void func_149734_b(World w, int x, int y, int z, Random r) {
        if (!AEConfig.instance.enableEffects) {
            return;
        }
        AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile instanceof TileVibrationChamber) {
            TileVibrationChamber tc = (TileVibrationChamber)tile;
            if (tc.isOn) {
                float f1 = (float)x + 0.5f;
                float f2 = (float)y + 0.5f;
                float f3 = (float)z + 0.5f;
                ForgeDirection forward = tc.getForward();
                ForgeDirection up = tc.getUp();
                int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
                int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
                int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
                f1 = (float)((double)f1 + (double)forward.offsetX * 0.6);
                f2 = (float)((double)f2 + (double)forward.offsetY * 0.6);
                f3 = (float)((double)f3 + (double)forward.offsetZ * 0.6);
                float ox = r.nextFloat();
                float oy = r.nextFloat() * 0.2f;
                f1 = (float)((double)f1 + (double)up.offsetX * (-0.3 + (double)oy));
                f2 = (float)((double)f2 + (double)up.offsetY * (-0.3 + (double)oy));
                f3 = (float)((double)f3 + (double)up.offsetZ * (-0.3 + (double)oy));
                f1 = (float)((double)f1 + (double)west_x * (0.3 * (double)ox - 0.15));
                f2 = (float)((double)f2 + (double)west_y * (0.3 * (double)ox - 0.15));
                f3 = (float)((double)f3 + (double)west_z * (0.3 * (double)ox - 0.15));
                w.func_72869_a("smoke", (double)f1, (double)f2, (double)f3, 0.0, 0.0, 0.0);
                w.func_72869_a("flame", (double)f1, (double)f2, (double)f3, 0.0, 0.0, 0.0);
            }
        }
    }
}

