/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.qnb;

import appeng.block.AEBaseBlock;
import appeng.client.EffectType;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderQNB;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.qnb.TileQuantumBridge;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockQuantumLinkChamber
extends AEBaseBlock
implements ICustomCollision {
    public BlockQuantumLinkChamber() {
        super(BlockQuantumLinkChamber.class, AEGlassMaterial.instance);
        this.setfeature(EnumSet.of(AEFeature.QuantumNetworkBridge));
        this.setTileEntiy(TileQuantumBridge.class);
        float shave = 0.125f;
        this.func_149676_a(shave, shave, shave, 1.0f - shave, 1.0f - shave, 1.0f - shave);
        this.func_149713_g(0);
        this.isOpaque = false;
        this.isFullSize = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int bx, int by, int bz, Random r) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, bx, by, bz);
        if (bridge != null && bridge.hasQES() && CommonHelper.proxy.shouldAddParticles(r)) {
            CommonHelper.proxy.spawnEffect(EffectType.Energy, w, (double)bx + 0.5, (double)by + 0.5, (double)bz + 0.5, null);
        }
    }

    public void func_149695_a(World w, int x, int y, int z, Block pointlessnumber) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (bridge != null) {
            bridge.neighborUpdate();
        }
    }

    @Override
    public void func_149749_a(World w, int x, int y, int z, Block a, int b) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (bridge != null) {
            bridge.breakCluster();
        }
        super.func_149749_a(w, x, y, z, a, b);
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderQNB.class;
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        if (p.func_70093_af()) {
            return false;
        }
        TileQuantumBridge tg = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tg != null) {
            if (Platform.isServer()) {
                Platform.openGUI(p, tg, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_QNB);
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxsFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        double OnePx = 0.125;
        return Arrays.asList(AxisAlignedBB.func_72330_a((double)OnePx, (double)OnePx, (double)OnePx, (double)(1.0 - OnePx), (double)(1.0 - OnePx), (double)(1.0 - OnePx)));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
        double OnePx = 0.125;
        out.add(AxisAlignedBB.func_72330_a((double)OnePx, (double)OnePx, (double)OnePx, (double)(1.0 - OnePx), (double)(1.0 - OnePx), (double)(1.0 - OnePx)));
    }
}

