/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ISortSource;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.util.Platform;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiCraftingCPU
extends AEBaseGui
implements ISortSource {
    int rows = 6;
    IItemList<IAEItemStack> storage = AEApi.instance().storage().createItemList();
    IItemList<IAEItemStack> active = AEApi.instance().storage().createItemList();
    IItemList<IAEItemStack> pending = AEApi.instance().storage().createItemList();
    List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    GuiButton cancel;
    int tooltip = -1;

    public void clearItems() {
        this.storage = AEApi.instance().storage().createItemList();
        this.active = AEApi.instance().storage().createItemList();
        this.pending = AEApi.instance().storage().createItemList();
        this.visual = new ArrayList<IAEItemStack>();
    }

    protected GuiCraftingCPU(ContainerCraftingCPU container) {
        super(container);
        this.field_147000_g = 184;
        this.field_146999_f = 238;
        this.myScrollBar = new GuiScrollbar();
    }

    public GuiCraftingCPU(InventoryPlayer inventoryPlayer, Object te) {
        this(new ContainerCraftingCPU(inventoryPlayer, te));
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (this.cancel == btn) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("TileCrafting.Cancel", "Cancel"));
            }
            catch (IOException e) {
                AELog.error(e);
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setScrollBar();
        this.cancel = new GuiButton(0, this.field_147003_i + 163, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Cancel.getLocal());
        this.field_146292_n.add(this.cancel);
    }

    private long getTotal(IAEItemStack is) {
        IAEItemStack a = this.storage.findPrecise(is);
        IAEItemStack b = this.active.findPrecise(is);
        IAEItemStack c = this.pending.findPrecise(is);
        long total = 0L;
        if (a != null) {
            total += a.getStackSize();
        }
        if (b != null) {
            total += b.getStackSize();
        }
        if (c != null) {
            total += c.getStackSize();
        }
        return total;
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        switch (ref) {
            case 0: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.storage, l);
                }
                break;
            }
            case 1: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.active, l);
                }
                break;
            }
            case 2: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.pending, l);
                }
                break;
            }
        }
        for (IAEItemStack l : list) {
            long amt = this.getTotal(l);
            if (amt <= 0L) {
                this.deleteVisualStack(l);
                continue;
            }
            IAEItemStack is = this.findVisualStack(l);
            is.setStackSize(amt);
        }
        this.setScrollBar();
    }

    private void handleInput(IItemList<IAEItemStack> s, IAEItemStack l) {
        IAEItemStack a = s.findPrecise(l);
        if (l.getStackSize() <= 0L) {
            if (a != null) {
                a.reset();
            }
        } else {
            if (a == null) {
                s.add(l.copy());
                a = s.findPrecise(l);
            }
            if (a != null) {
                a.setStackSize(l.getStackSize());
            }
        }
    }

    private IAEItemStack findVisualStack(IAEItemStack l) {
        for (IAEItemStack o : this.visual) {
            if (!o.equals(l)) continue;
            return o;
        }
        IAEItemStack stack = l.copy();
        this.visual.add(stack);
        return stack;
    }

    private void deleteVisualStack(IAEItemStack l) {
        Iterator<IAEItemStack> i = this.visual.iterator();
        while (i.hasNext()) {
            IAEItemStack o = i.next();
            if (!o.equals(l)) continue;
            i.remove();
            return;
        }
    }

    private void setScrollBar() {
        int size = this.visual.size();
        this.myScrollBar.setTop(19).setLeft(218).setHeight(137);
        this.myScrollBar.setRange(0, (size + 2) / 3 - this.rows, 1);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/craftingcpu.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void func_73863_a(int mouse_x, int mouse_y, float btn) {
        this.cancel.field_146124_l = !this.visual.isEmpty();
        int x = 0;
        int y = 0;
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        int yoff = 23;
        this.tooltip = -1;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * yoff;
            if (minX < mouse_x && minX + 67 > mouse_x && minY < mouse_y && minY + yoff - 2 > mouse_y) {
                this.tooltip = z;
                break;
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        super.func_73863_a(mouse_x, mouse_y, btn);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.CraftingStatus.getLocal()), 8, 7, 0x404040);
        int sectionLength = 67;
        int x = 0;
        int y = 0;
        int xo = 9;
        int yo = 22;
        int viewStart = this.myScrollBar.getCurrentScroll() * 3;
        int viewEnd = viewStart + 18;
        String dspToolTip = "";
        LinkedList<String> lineList = new LinkedList<String>();
        int toolPosX = 0;
        int toolPosY = 0;
        int offY = 23;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            int w;
            String str;
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            IAEItemStack stored = this.storage.findPrecise(refStack);
            IAEItemStack activeStack = this.active.findPrecise(refStack);
            IAEItemStack pendingStack = this.pending.findPrecise(refStack);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
            }
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                ++lines;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                ++lines;
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                str = Long.toString(stored.getStackSize());
                if (stored.getStackSize() >= 10000L) {
                    str = Long.toString(stored.getStackSize() / 1000L) + "k";
                }
                if (stored.getStackSize() >= 10000000L) {
                    str = Long.toString(stored.getStackSize() / 1000000L) + "m";
                }
                str = GuiText.Stored.getLocal() + ": " + str;
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * (1 + sectionLength) + xo + sectionLength - 19) - (double)w * 0.5) * 2.0), (y * offY + yo + 6 - negY + downY) * 2, 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Stored.getLocal() + ": " + Long.toString(stored.getStackSize()));
                }
                downY += 5;
            }
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                str = Long.toString(activeStack.getStackSize());
                if (activeStack.getStackSize() >= 10000L) {
                    str = Long.toString(activeStack.getStackSize() / 1000L) + "k";
                }
                if (activeStack.getStackSize() >= 10000000L) {
                    str = Long.toString(activeStack.getStackSize() / 1000000L) + "m";
                }
                str = GuiText.Crafting.getLocal() + ": " + str;
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * (1 + sectionLength) + xo + sectionLength - 19) - (double)w * 0.5) * 2.0), (y * offY + yo + 6 - negY + downY) * 2, 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Crafting.getLocal() + ": " + Long.toString(activeStack.getStackSize()));
                }
                downY += 5;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                str = Long.toString(pendingStack.getStackSize());
                if (pendingStack.getStackSize() >= 10000L) {
                    str = Long.toString(pendingStack.getStackSize() / 1000L) + "k";
                }
                if (pendingStack.getStackSize() >= 10000000L) {
                    str = Long.toString(pendingStack.getStackSize() / 1000000L) + "m";
                }
                str = GuiText.Scheduled.getLocal() + ": " + str;
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * (1 + sectionLength) + xo + sectionLength - 19) - (double)w * 0.5) * 2.0), (y * offY + yo + 6 - negY + downY) * 2, 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Scheduled.getLocal() + ": " + Long.toString(pendingStack.getStackSize()));
                }
            }
            GL11.glPopMatrix();
            int posX = x * (1 + sectionLength) + xo + sectionLength - 19;
            int posY = y * offY + yo;
            ItemStack is = refStack.copy().getItemStack();
            if (this.tooltip == z - viewStart) {
                dspToolTip = Platform.getItemDisplayName(is);
                if (lineList.size() > 0) {
                    dspToolTip = dspToolTip + "\n" + Joiner.on((String)"\n").join(lineList);
                }
                toolPosX = x * (1 + sectionLength) + xo + sectionLength - 8;
                toolPosY = y * offY + yo;
            }
            this.drawItem(posX, posY, is);
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && dspToolTip.length() > 0) {
            GL11.glPushAttrib((int)1048575);
            this.drawTooltip(toolPosX, toolPosY + 10, 0, dspToolTip);
            GL11.glPopAttrib();
        }
    }

    @Override
    public Enum getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public Enum getSortDir() {
        return SortDir.ASCENDING;
    }

    @Override
    public Enum getSortDisplay() {
        return ViewItems.ALL;
    }
}

