/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.AEApi;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartCollsionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.ISimplifiedBundle;
import appeng.block.AEBaseBlock;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.render.BusRenderer;
import appeng.client.render.RenderBlocksWorkaround;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BusRenderHelper
implements IPartRenderHelper {
    public static final BusRenderHelper instance = new BusRenderHelper();
    double minX = 0.0;
    double minY = 0.0;
    double minZ = 0.0;
    double maxX = 16.0;
    double maxY = 16.0;
    double maxZ = 16.0;
    AEBaseBlock blk;
    BaseBlockRender bbr;
    private ForgeDirection ax;
    private ForgeDirection ay;
    private ForgeDirection az;
    int color;
    BoundBoxCalculator bbc;
    int renderingForPass;
    int currentPass;
    int itemsRendered;
    boolean noAlphaPass;

    public BusRenderHelper() {
        this.blk = (AEBaseBlock)AEApi.instance().blocks().blockMultiPart.block();
        this.bbr = new BaseBlockRender();
        this.ax = ForgeDirection.EAST;
        this.ay = ForgeDirection.UP;
        this.az = ForgeDirection.SOUTH;
        this.color = 0xFFFFFF;
        this.bbc = new BoundBoxCalculator();
        this.renderingForPass = 0;
        this.currentPass = 0;
        this.itemsRendered = 0;
        this.noAlphaPass = !AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass);
    }

    public int getItemsRendered() {
        return this.itemsRendered;
    }

    public void setPass(int pass) {
        this.renderingForPass = 0;
        this.currentPass = pass;
        this.itemsRendered = 0;
    }

    @Override
    public void renderForPass(int pass) {
        this.renderingForPass = pass;
    }

    public boolean renderThis() {
        if (this.renderingForPass == this.currentPass || this.noAlphaPass) {
            ++this.itemsRendered;
            return true;
        }
        return false;
    }

    @Override
    public void normalRendering() {
        RenderBlocksWorkaround rbw = BusRenderer.instance.renderer;
        rbw.calculations = true;
        rbw.useTextures = true;
        rbw.field_147863_w = false;
    }

    @Override
    public ISimplifiedBundle useSimpliedRendering(int x, int y, int z, IBoxProvider p, ISimplifiedBundle sim) {
        RenderBlocksWorkaround rbw = BusRenderer.instance.renderer;
        if (sim != null && rbw.similarLighting((Block)this.blk, rbw.field_147845_a, x, y, z, sim)) {
            rbw.populate(sim);
            rbw.faces = EnumSet.allOf(ForgeDirection.class);
            rbw.calculations = false;
            rbw.useTextures = false;
            return sim;
        }
        boolean allFaces = rbw.field_147837_f;
        rbw.field_147837_f = true;
        rbw.calculations = true;
        rbw.faces.clear();
        this.bbc.started = false;
        if (p == null) {
            this.bbc.minZ = 0.0f;
            this.bbc.minY = 0.0f;
            this.bbc.minX = 0.0f;
            this.bbc.maxZ = 16.0f;
            this.bbc.maxY = 16.0f;
            this.bbc.maxX = 16.0f;
        } else {
            p.getBoxes(this.bbc);
            if (this.bbc.minX < 1.0f) {
                this.bbc.minX = 1.0f;
            }
            if (this.bbc.minY < 1.0f) {
                this.bbc.minY = 1.0f;
            }
            if (this.bbc.minZ < 1.0f) {
                this.bbc.minZ = 1.0f;
            }
            if (this.bbc.maxX > 15.0f) {
                this.bbc.maxX = 15.0f;
            }
            if (this.bbc.maxY > 15.0f) {
                this.bbc.maxY = 15.0f;
            }
            if (this.bbc.maxZ > 15.0f) {
                this.bbc.maxZ = 15.0f;
            }
        }
        this.setBounds(this.bbc.minX, this.bbc.minY, this.bbc.minZ, this.bbc.maxX, this.bbc.maxY, this.bbc.maxZ);
        this.bbr.renderBlockBounds(rbw, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.ax, this.ay, this.az);
        rbw.func_147784_q((Block)this.blk, x, y, z);
        rbw.faces = EnumSet.allOf(ForgeDirection.class);
        rbw.field_147837_f = allFaces;
        rbw.calculations = false;
        rbw.useTextures = false;
        return rbw.getLightingCache();
    }

    @Override
    public void setBounds(float minx, float miny, float minz, float maxx, float maxy, float maxz) {
        this.minX = minx;
        this.minY = miny;
        this.minZ = minz;
        this.maxX = maxx;
        this.maxY = maxy;
        this.maxZ = maxz;
    }

    public double getBound(ForgeDirection side) {
        switch (side) {
            default: {
                return 0.5;
            }
            case DOWN: {
                return this.minY;
            }
            case EAST: {
                return this.maxX;
            }
            case NORTH: {
                return this.minZ;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case UP: {
                return this.maxY;
            }
            case WEST: 
        }
        return this.minX;
    }

    @Override
    public void setInvColor(int newColor) {
        this.color = newColor;
    }

    @Override
    public void setTexture(IIcon ico) {
        this.blk.getRendererInstance().setTemporaryRenderIcon(ico);
    }

    @Override
    public void setTexture(IIcon Down, IIcon Up, IIcon North, IIcon South, IIcon West, IIcon East) {
        IIcon[] list = new IIcon[]{Down, Up, North, South, West, East};
        this.blk.getRendererInstance().setTemporaryRenderIcons(list[this.mapRotation(ForgeDirection.UP).ordinal()], list[this.mapRotation(ForgeDirection.DOWN).ordinal()], list[this.mapRotation(ForgeDirection.SOUTH).ordinal()], list[this.mapRotation(ForgeDirection.NORTH).ordinal()], list[this.mapRotation(ForgeDirection.EAST).ordinal()], list[this.mapRotation(ForgeDirection.WEST).ordinal()]);
    }

    public ForgeDirection mapRotation(ForgeDirection dir) {
        ForgeDirection forward = this.az;
        ForgeDirection up = this.ay;
        ForgeDirection west = ForgeDirection.UNKNOWN;
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir.equals((Object)forward)) {
            return ForgeDirection.SOUTH;
        }
        if (dir.equals((Object)forward.getOpposite())) {
            return ForgeDirection.NORTH;
        }
        if (dir.equals((Object)up)) {
            return ForgeDirection.UP;
        }
        if (dir.equals((Object)up.getOpposite())) {
            return ForgeDirection.DOWN;
        }
        if (dir.equals((Object)west)) {
            return ForgeDirection.WEST;
        }
        if (dir.equals((Object)west.getOpposite())) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void renderInventoryBox(RenderBlocks renderer) {
        renderer.func_147782_a(this.minX / 16.0, this.minY / 16.0, this.minZ / 16.0, this.maxX / 16.0, this.maxY / 16.0, this.maxZ / 16.0);
        this.bbr.renderInvBlock(EnumSet.allOf(ForgeDirection.class), this.blk, null, Tessellator.field_78398_a, this.color, renderer);
    }

    @Override
    public void renderInventoryFace(IIcon IIcon2, ForgeDirection face, RenderBlocks renderer) {
        renderer.func_147782_a(this.minX / 16.0, this.minY / 16.0, this.minZ / 16.0, this.maxX / 16.0, this.maxY / 16.0, this.maxZ / 16.0);
        this.setTexture(IIcon2);
        this.bbr.renderInvBlock(EnumSet.of(face), this.blk, null, Tessellator.field_78398_a, this.color, renderer);
    }

    @Override
    public void renderBlock(int x, int y, int z, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        AEBaseBlock blk = (AEBaseBlock)AEApi.instance().blocks().blockMultiPart.block();
        BlockRenderInfo info = blk.getRendererInstance();
        ForgeDirection forward = BusRenderHelper.instance.az;
        ForgeDirection up = BusRenderHelper.instance.ay;
        renderer.field_147865_v = info.getTexture(ForgeDirection.DOWN).setFlip(BaseBlockRender.getOrientation(ForgeDirection.DOWN, forward, up));
        renderer.field_147867_u = info.getTexture(ForgeDirection.UP).setFlip(BaseBlockRender.getOrientation(ForgeDirection.UP, forward, up));
        renderer.field_147875_q = info.getTexture(ForgeDirection.EAST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.EAST, forward, up));
        renderer.field_147873_r = info.getTexture(ForgeDirection.WEST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.WEST, forward, up));
        renderer.field_147869_t = info.getTexture(ForgeDirection.NORTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.NORTH, forward, up));
        renderer.field_147871_s = info.getTexture(ForgeDirection.SOUTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.SOUTH, forward, up));
        this.bbr.renderBlockBounds(renderer, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.ax, this.ay, this.az);
        renderer.func_147784_q((Block)blk, x, y, z);
    }

    @Override
    public Block getBlock() {
        return AEApi.instance().blocks().blockMultiPart.block();
    }

    public void setRenderColor(int color) {
        BlockCableBus blk = (BlockCableBus)AEApi.instance().blocks().blockMultiPart.block();
        blk.setRenderColor(color);
    }

    public void prepareBounds(RenderBlocks renderer) {
        this.bbr.renderBlockBounds(renderer, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.ax, this.ay, this.az);
    }

    @Override
    public void setFacesToRender(EnumSet<ForgeDirection> faces) {
        BusRenderer.instance.renderer.renderFaces = faces;
    }

    @Override
    public void renderBlockCurrentBounds(int x, int y, int z, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        renderer.func_147784_q((Block)this.blk, x, y, z);
    }

    @Override
    public void renderFaceCutout(int x, int y, int z, IIcon ico, ForgeDirection face, float edgeThickness, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        switch (face) {
            case DOWN: {
                face = this.ay.getOpposite();
                break;
            }
            case EAST: {
                face = this.ax;
                break;
            }
            case NORTH: {
                face = this.az.getOpposite();
                break;
            }
            case SOUTH: {
                face = this.az;
                break;
            }
            case UP: {
                face = this.ay;
                break;
            }
            case WEST: {
                face = this.ax.getOpposite();
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        this.bbr.renderCutoutFace((Block)this.blk, ico, x, y, z, renderer, face, edgeThickness);
    }

    @Override
    public void renderFace(int x, int y, int z, IIcon ico, ForgeDirection face, RenderBlocks renderer) {
        if (!this.renderThis()) {
            return;
        }
        this.prepareBounds(renderer);
        switch (face) {
            case DOWN: {
                face = this.ay.getOpposite();
                break;
            }
            case EAST: {
                face = this.ax;
                break;
            }
            case NORTH: {
                face = this.az.getOpposite();
                break;
            }
            case SOUTH: {
                face = this.az;
                break;
            }
            case UP: {
                face = this.ay;
                break;
            }
            case WEST: {
                face = this.ax.getOpposite();
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
        this.bbr.renderFace(x, y, z, (Block)this.blk, ico, renderer, face);
    }

    @Override
    public ForgeDirection getWorldX() {
        return this.ax;
    }

    @Override
    public ForgeDirection getWorldY() {
        return this.ay;
    }

    @Override
    public ForgeDirection getWorldZ() {
        return this.az;
    }

    public void setOrientation(ForgeDirection dx, ForgeDirection dy, ForgeDirection dz) {
        this.ax = dx == null ? ForgeDirection.EAST : dx;
        this.ay = dy == null ? ForgeDirection.UP : dy;
        this.az = dz == null ? ForgeDirection.SOUTH : dz;
    }

    public double[] getBounds() {
        return new double[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public void setBounds(double[] bounds) {
        if (bounds == null || bounds.length != 6) {
            return;
        }
        this.minX = bounds[0];
        this.minY = bounds[1];
        this.minZ = bounds[2];
        this.maxX = bounds[3];
        this.maxY = bounds[4];
        this.maxZ = bounds[5];
    }

    class BoundBoxCalculator
    implements IPartCollsionHelper {
        public boolean started = false;
        float minX;
        float minY;
        float minZ;
        float maxX;
        float maxY;
        float maxZ;

        BoundBoxCalculator() {
        }

        @Override
        public void addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            if (this.started) {
                this.minX = Math.min(this.minX, (float)minX);
                this.minY = Math.min(this.minY, (float)minY);
                this.minZ = Math.min(this.minZ, (float)minZ);
                this.maxX = Math.max(this.maxX, (float)maxX);
                this.maxY = Math.max(this.maxY, (float)maxY);
                this.maxZ = Math.max(this.maxZ, (float)maxZ);
            } else {
                this.started = true;
                this.minX = (float)minX;
                this.minY = (float)minY;
                this.minZ = (float)minZ;
                this.maxX = (float)maxX;
                this.maxY = (float)maxY;
                this.maxZ = (float)maxZ;
            }
        }

        @Override
        public ForgeDirection getWorldX() {
            return BusRenderHelper.this.ax;
        }

        @Override
        public ForgeDirection getWorldY() {
            return BusRenderHelper.this.ay;
        }

        @Override
        public ForgeDirection getWorldZ() {
            return BusRenderHelper.this.az;
        }

        @Override
        public boolean isBBCollision() {
            return false;
        }
    }
}

