/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.storage.data.IAEItemStack;
import appeng.block.AEBaseBlock;
import appeng.client.ClientHelper;
import appeng.client.render.blocks.RenderBlockCraftingCPU;
import appeng.core.AELog;
import appeng.tile.AEBaseTile;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.util.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderBlockCraftingCPUMonitor
extends RenderBlockCraftingCPU {
    public RenderBlockCraftingCPUMonitor() {
        super(true, 20);
    }

    @Override
    public void renderTile(AEBaseBlock block, AEBaseTile tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        if (Platform.isDrawing(tess)) {
            return;
        }
        if (tile instanceof TileCraftingMonitorTile) {
            TileCraftingMonitorTile cmt = (TileCraftingMonitorTile)tile;
            IAEItemStack ais = cmt.getJobProgress();
            if (cmt.dspList == null) {
                cmt.updateList = true;
                cmt.dspList = GLAllocation.func_74526_a((int)1);
            }
            if (ais != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                if (cmt.updateList) {
                    cmt.updateList = false;
                    GL11.glNewList((int)cmt.dspList, (int)4865);
                    this.tesrRenderScreen(tess, cmt, ais);
                    GL11.glEndList();
                } else {
                    GL11.glCallList((int)cmt.dspList);
                }
                GL11.glPopMatrix();
            }
        }
    }

    private void tesrRenderScreen(Tessellator tess, TileCraftingMonitorTile cmt, IAEItemStack ais) {
        ForgeDirection side = cmt.getForward();
        ForgeDirection walrus = side.offsetY != 0 ? ForgeDirection.SOUTH : ForgeDirection.UP;
        int spin = 0;
        int max = 5;
        while (walrus != cmt.getUp() && max-- > 0) {
            ++spin;
            walrus = Platform.rotateAround(walrus, side);
        }
        GL11.glPushAttrib((int)1048575);
        ForgeDirection d = side;
        GL11.glTranslated((double)((double)d.offsetX * 0.69), (double)((double)d.offsetY * 0.69), (double)((double)d.offsetZ * 0.69));
        float scale = 0.7f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        if (d == ForgeDirection.UP) {
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((float)spin * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (d == ForgeDirection.DOWN) {
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((float)spin * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (d == ForgeDirection.EAST) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (d == ForgeDirection.WEST) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (d == ForgeDirection.NORTH) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        }
        if (d == ForgeDirection.SOUTH) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        try {
            ItemStack sis = ais.getItemStack();
            sis.field_77994_a = 1;
            int br = 0x1000100;
            int var11 = br % 65536;
            int var12 = br / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var11 * 0.8f), (float)((float)var12 * 0.8f));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)32826);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            ClientHelper.proxy.doRenderItem(sis, cmt.func_145831_w());
        }
        catch (Exception e) {
            AELog.error(e);
        }
        GL11.glPopMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
        GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        long qty = ais.getStackSize();
        if (qty > 999999999999L) {
            qty = 999999999999L;
        }
        String msg = Long.toString(qty);
        if (qty > 1000000000L) {
            msg = Long.toString(qty / 1000000000L) + "B";
        } else if (qty > 1000000L) {
            msg = Long.toString(qty / 1000000L) + "M";
        } else if (qty > 9999L) {
            msg = Long.toString(qty / 1000L) + "K";
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(msg);
        GL11.glTranslatef((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(msg, 0, 0, 0);
        GL11.glPopAttrib();
    }
}

