/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LightningFX
extends EntityFX {
    final int steps = this.getSteps();
    static Random rng = new Random();
    double[][] Steps;
    float currentPoint = 0.0f;
    boolean hasData = false;
    double[] I = new double[3];
    double[] K = new double[3];

    protected LightningFX(World w, double x, double y, double z, double r, double g, double b, int maxAge) {
        super(w, x, y, z, r, g, b);
        this.Steps = new double[this.steps][3];
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70547_e = maxAge;
    }

    private int getSteps() {
        return 5;
    }

    public LightningFX(World w, double x, double y, double z, double r, double g, double b) {
        this(w, x, y, z, r, g, b, 6);
        this.regen();
    }

    public int func_70070_b(float par1) {
        int j1 = 13;
        return j1 << 20 | j1 << 4;
    }

    protected void regen() {
        double lastDirectionX = (rng.nextDouble() - 0.5) * 0.9;
        double lastDirectionY = (rng.nextDouble() - 0.5) * 0.9;
        double lastDirectionZ = (rng.nextDouble() - 0.5) * 0.9;
        for (int s = 0; s < this.steps; ++s) {
            this.Steps[s][0] = lastDirectionX = (lastDirectionX + (rng.nextDouble() - 0.5) * 0.9) / 2.0;
            this.Steps[s][1] = lastDirectionY = (lastDirectionY + (rng.nextDouble() - 0.5) * 0.9) / 2.0;
            this.Steps[s][2] = lastDirectionZ = (lastDirectionZ + (rng.nextDouble() - 0.5) * 0.9) / 2.0;
        }
    }

    public void func_70539_a(Tessellator tess, float l, float rX, float rY, float rZ, float rYZ, float rXY) {
        float j = 1.0f;
        tess.func_78369_a(this.field_70552_h * j * 0.9f, this.field_70553_i * j * 0.95f, this.field_70551_j * j, this.field_82339_as);
        if (this.field_70546_d == 3) {
            this.regen();
        }
        double f6 = (double)this.field_94054_b / 16.0;
        double f7 = f6 + (double)0.0324375f;
        double f8 = (double)this.field_94055_c / 16.0;
        double f9 = f8 + (double)0.0324375f;
        f6 = f7;
        f8 = f9;
        double scale = 0.02;
        double[] a = new double[3];
        double[] b = new double[3];
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
        double offX = -rZ;
        double offY = MathHelper.func_76134_b((float)((float)(1.5707963267948966 + (double)(p.field_70125_A * ((float)Math.PI / 180)))));
        double offZ = rX;
        for (int layer = 0; layer < 2; ++layer) {
            if (layer == 0) {
                scale = 0.04;
                offX *= 0.001;
                offY *= 0.001;
                offZ *= 0.001;
                tess.func_78369_a(this.field_70552_h * j * 0.4f, this.field_70553_i * j * 0.25f, this.field_70551_j * j * 0.45f, this.field_82339_as);
            } else {
                offX = 0.0;
                offY = 0.0;
                offZ = 0.0;
                scale = 0.02;
                tess.func_78369_a(this.field_70552_h * j * 0.9f, this.field_70553_i * j * 0.65f, this.field_70551_j * j * 0.85f, this.field_82339_as);
            }
            for (int cycle = 0; cycle < 3; ++cycle) {
                this.clear();
                double x = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)l - field_70556_an - offX;
                double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)l - field_70554_ao - offY;
                double z = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)l - field_70555_ap - offZ;
                for (int s = 0; s < this.steps; ++s) {
                    double xN = x + this.Steps[s][0];
                    double yN = y + this.Steps[s][1];
                    double zN = z + this.Steps[s][2];
                    double xD = xN - x;
                    double yD = yN - y;
                    double zD = zN - z;
                    if (cycle == 0) {
                        ox = yD * 0.0 - 1.0 * zD;
                        oy = zD * 0.0 - 0.0 * xD;
                        oz = xD * 1.0 - 0.0 * yD;
                    }
                    if (cycle == 1) {
                        ox = yD * 1.0 - 0.0 * zD;
                        oy = zD * 0.0 - 1.0 * xD;
                        oz = xD * 0.0 - 0.0 * yD;
                    }
                    if (cycle == 2) {
                        ox = yD * 0.0 - 0.0 * zD;
                        oy = zD * 1.0 - 0.0 * xD;
                        oz = xD * 0.0 - 1.0 * yD;
                    }
                    double ss = Math.sqrt(ox * ox + oy * oy + oz * oz) / (((double)this.steps - (double)s) / (double)this.steps * scale);
                    a[0] = x + (ox /= ss);
                    a[1] = y + (oy /= ss);
                    a[2] = z + (oz /= ss);
                    b[0] = x;
                    b[1] = y;
                    b[2] = z;
                    this.draw(tess, a, b, f6, f8);
                    x = xN;
                    y = yN;
                    z = zN;
                }
            }
        }
    }

    private void draw(Tessellator tess, double[] a, double[] b, double f6, double f8) {
        if (this.hasData) {
            tess.func_78374_a(a[0], a[1], a[2], f6, f8);
            tess.func_78374_a(this.I[0], this.I[1], this.I[2], f6, f8);
            tess.func_78374_a(this.K[0], this.K[1], this.K[2], f6, f8);
            tess.func_78374_a(b[0], b[1], b[2], f6, f8);
        }
        this.hasData = true;
        for (int x = 0; x < 3; ++x) {
            this.I[x] = a[x];
            this.K[x] = b[x];
        }
    }

    private void clear() {
        this.hasData = false;
    }
}

