/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.ICustomNameObject;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.Platform;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerCraftingCPU
extends AEBaseContainer
implements IMEMonitorHandlerReceiver<IAEItemStack>,
ICustomNameObject {
    CraftingCPUCluster monitor = null;
    String cpuName = null;
    protected IGrid network;
    IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    int delay = 40;

    public ContainerCraftingCPU(InventoryPlayer ip, Object te) {
        super(ip, te);
        IGridHost host = (IGridHost)(te instanceof IGridHost ? te : null);
        if (host != null) {
            this.findNode(host, ForgeDirection.UNKNOWN);
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                this.findNode(host, d);
            }
        }
        if (te instanceof TileCraftingTile) {
            this.setCPU((ICraftingCPU)((Object)((TileCraftingTile)te).getCluster()));
        }
        if (this.network == null && Platform.isServer()) {
            this.isContainerValid = false;
        }
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.monitor) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
        for (Object g : this.field_75149_d) {
            if (!(g instanceof EntityPlayer)) continue;
            try {
                NetworkHandler.instance.sendTo(new PacketValueConfig("CraftingStatus", "Clear"), (EntityPlayerMP)g);
            }
            catch (IOException e) {
                AELog.error(e);
            }
        }
        if (c instanceof CraftingCPUCluster) {
            this.cpuName = ((CraftingCPUCluster)c).getName();
            this.monitor = (CraftingCPUCluster)c;
            if (this.monitor != null) {
                this.list.resetStatus();
                this.monitor.getListOfItem(this.list, CraftingItemList.ALL);
                this.monitor.addListener(this, (Object)null);
            }
        } else {
            this.monitor = null;
            this.cpuName = "";
        }
    }

    public void cancelCrafting() {
        if (this.monitor != null) {
            this.monitor.cancel();
        }
    }

    private void findNode(IGridHost host, ForgeDirection d) {
        IGridNode node;
        if (this.network == null && (node = host.getGridNode(d)) != null) {
            this.network = node.getGrid();
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer() && this.monitor != null && !this.list.isEmpty()) {
            try {
                PacketMEInventoryUpdate a = new PacketMEInventoryUpdate(0);
                PacketMEInventoryUpdate b = new PacketMEInventoryUpdate(1);
                PacketMEInventoryUpdate c = new PacketMEInventoryUpdate(2);
                for (IAEItemStack out : this.list) {
                    a.appendItem(this.monitor.getItemStack(out, CraftingItemList.STORAGE));
                    b.appendItem(this.monitor.getItemStack(out, CraftingItemList.ACTIVE));
                    c.appendItem(this.monitor.getItemStack(out, CraftingItemList.PENDING));
                }
                this.list.resetStatus();
                for (IAEItemStack g : this.field_75149_d) {
                    if (!(g instanceof EntityPlayer)) continue;
                    if (!a.isEmpty()) {
                        NetworkHandler.instance.sendTo(a, (EntityPlayerMP)g);
                    }
                    if (!b.isEmpty()) {
                        NetworkHandler.instance.sendTo(b, (EntityPlayerMP)g);
                    }
                    if (c.isEmpty()) continue;
                    NetworkHandler.instance.sendTo(c, (EntityPlayerMP)g);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.func_75142_b();
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        for (IAEItemStack is : change) {
            is = is.copy();
            is.setStackSize(1L);
            this.list.add(is);
        }
    }

    @Override
    public void onListUpdate() {
    }

    @Override
    public String getCustomName() {
        return this.cpuName;
    }

    @Override
    public boolean hasCustomName() {
        return this.cpuName != null && this.cpuName.length() > 0;
    }
}

