/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.storage.ITerminalHost;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.CraftingCPURecord;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.InventoryPlayer;

public class ContainerCraftingStatus
extends ContainerCraftingCPU {
    @GuiSync(value=5)
    public int selectedCpu = -1;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public String myName = "";
    public ArrayList<CraftingCPURecord> cpus = new ArrayList();

    private void sendCPUs() {
        Collections.sort(this.cpus);
        if (this.selectedCpu >= this.cpus.size()) {
            this.selectedCpu = -1;
            this.myName = "";
        } else if (this.selectedCpu != -1) {
            this.myName = this.cpus.get((int)this.selectedCpu).myName;
        }
        if (this.selectedCpu == -1 && this.cpus.size() > 0) {
            this.selectedCpu = 0;
        }
        if (this.selectedCpu != -1) {
            if (this.cpus.get((int)this.selectedCpu).cpu != this.monitor) {
                this.setCPU(this.cpus.get((int)this.selectedCpu).cpu);
            }
        } else {
            this.setCPU(null);
        }
    }

    @Override
    public void func_75142_b() {
        ICraftingGrid cc = (ICraftingGrid)this.network.getCache(ICraftingGrid.class);
        ImmutableSet<ICraftingCPU> cpuSet = cc.getCpus();
        int matches = 0;
        boolean changed = false;
        for (ICraftingCPU c : cpuSet) {
            boolean found = false;
            for (CraftingCPURecord ccr : this.cpus) {
                if (ccr.cpu != c) continue;
                found = true;
            }
            boolean matched = this.cpuMatches(c);
            if (matched) {
                ++matches;
            }
            if (!found == matched) continue;
            changed = true;
        }
        if (changed || this.cpus.size() != matches) {
            this.cpus.clear();
            for (ICraftingCPU c : cpuSet) {
                if (!this.cpuMatches(c)) continue;
                this.cpus.add(new CraftingCPURecord(c.getAvailableStorage(), c.getCoProcessors(), c));
            }
            this.sendCPUs();
        }
        this.noCPU = this.cpus.size() == 0;
        super.func_75142_b();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.isBusy();
    }

    public ContainerCraftingStatus(InventoryPlayer ip, ITerminalHost te) {
        super(ip, te);
    }

    public void cycleCpu(boolean next) {
        this.selectedCpu = next ? ++this.selectedCpu : --this.selectedCpu;
        if (this.selectedCpu < -1) {
            this.selectedCpu = this.cpus.size() - 1;
        } else if (this.selectedCpu >= this.cpus.size()) {
            this.selectedCpu = -1;
        }
        if (this.selectedCpu == -1 && this.cpus.size() > 0) {
            this.selectedCpu = 0;
        }
        if (this.selectedCpu == -1) {
            this.myName = "";
            this.setCPU(null);
        } else {
            this.myName = this.cpus.get((int)this.selectedCpu).myName;
            this.setCPU(this.cpus.get((int)this.selectedCpu).cpu);
        }
    }
}

