/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.storage.TileIOPort;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class ContainerIOPort
extends ContainerUpgradeable {
    TileIOPort ioPort;
    @GuiSync(value=2)
    public FullnessMode fMode = FullnessMode.EMPTY;
    @GuiSync(value=3)
    public OperationMode opMode = OperationMode.EMPTY;

    public ContainerIOPort(InventoryPlayer ip, TileIOPort te) {
        super(ip, te);
        this.ioPort = te;
    }

    @Override
    protected int getHeight() {
        return 166;
    }

    @Override
    public int availableUpgrades() {
        return 3;
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    protected void setupConfig() {
        int x;
        int y;
        int offx = 19;
        int offy = 17;
        IInventory cells = this.myte.getInventoryByName("cells");
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 2; ++x) {
                this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.STORAGE_CELLS, cells, x + y * 2, offx + x * 18, offy + y * 18, this.invPlayer));
            }
        }
        offx = 122;
        offy = 17;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 2; ++x) {
                this.func_75146_a(new SlotOutput(cells, 6 + x + y * 2, offx + x * 18, offy + y * 18, SlotRestrictedInput.PlaceableItemType.STORAGE_CELLS.IIcon));
            }
        }
        IInventory upgrades = this.myte.getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 0, 187, 8, this.invPlayer).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 1, 187, 26, this.invPlayer).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 2, 187, 44, this.invPlayer).setNotDraggable());
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.opMode = (OperationMode)this.myte.getConfigManager().getSetting(Settings.OPERATION_MODE);
            this.fMode = (FullnessMode)this.myte.getConfigManager().getSetting(Settings.FULLNESS_MODE);
            this.rsMode = (RedstoneMode)this.myte.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
        }
        this.standardDetectAndSendChanges();
    }
}

