/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigureableObject;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.io.IOException;
import java.nio.BufferOverflowException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerMEMonitorable
extends AEBaseContainer
implements IConfigManagerHost,
IConfigureableObject,
IMEMonitorHandlerReceiver<IAEItemStack> {
    final IMEMonitor<IAEItemStack> monitor;
    final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    IConfigManager serverCM;
    IConfigManager clientCM;
    @GuiSync(value=99)
    public boolean canAccessViewCells = false;
    @GuiSync(value=98)
    public boolean hasPower = false;
    public SlotRestrictedInput[] cellView = new SlotRestrictedInput[5];
    public IConfigManagerHost gui;
    private IGridNode networkNode;

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    protected ContainerMEMonitorable(InventoryPlayer ip, ITerminalHost montiorable, boolean bindInventory) {
        super(ip, montiorable instanceof TileEntity ? (TileEntity)montiorable : null, montiorable instanceof IPart ? (IPart)((Object)montiorable) : null);
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        if (Platform.isServer()) {
            this.serverCM = montiorable.getConfigManager();
            this.monitor = montiorable.getItemInventory();
            if (this.monitor != null) {
                IGridNode node;
                this.monitor.addListener(this, null);
                this.cellInv = this.monitor;
                if (montiorable instanceof IPortableCell) {
                    this.powerSrc = (IPortableCell)montiorable;
                } else if (montiorable instanceof IMEChest) {
                    this.powerSrc = (IMEChest)((Object)montiorable);
                } else if (montiorable instanceof IGridHost && (node = ((IGridHost)((Object)montiorable)).getGridNode(ForgeDirection.UNKNOWN)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.powerSrc = new ChannelPowerSrc(this.networkNode, (IEnergyGrid)g.getCache(IEnergyGrid.class));
                    }
                }
            } else {
                this.isContainerValid = false;
            }
        } else {
            this.monitor = null;
        }
        this.canAccessViewCells = false;
        if (montiorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.VIEWCELL, ((IViewCellStorage)((Object)montiorable)).getViewCellStorage(), y, 206, y * 18 + 8, this.invPlayer);
                this.cellView[y].allowEdit = this.canAccessViewCells;
                this.func_75146_a(this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    public ContainerMEMonitorable(InventoryPlayer ip, ITerminalHost montiorable) {
        this(ip, montiorable, true);
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            for (Enum set : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (int j = 0; j < this.field_75149_d.size(); ++j) {
                    try {
                        NetworkHandler.instance.sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)this.field_75149_d.get(j));
                        continue;
                    }
                    catch (IOException e) {
                        AELog.error(e);
                    }
                }
            }
            if (!this.items.isEmpty()) {
                try {
                    IItemList<IAEItemStack> monitorCache = this.monitor.getStorageList();
                    PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                    for (IAEItemStack is : this.items) {
                        IAEItemStack send = monitorCache.findPrecise(is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendItem(is);
                            continue;
                        }
                        piu.appendItem(send);
                    }
                    if (!piu.isEmpty()) {
                        this.items.resetStatus();
                        for (IAEItemStack c : this.field_75149_d) {
                            if (!(c instanceof EntityPlayer)) continue;
                            NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                        }
                    }
                }
                catch (IOException e) {
                    AELog.error(e);
                }
            }
            this.updatePowerStatus();
            boolean oldCanAccessViewCells = this.canAccessViewCells;
            this.canAccessViewCells = this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldCanAccessViewCells) {
                for (int y = 0; y < 5; ++y) {
                    if (this.cellView[y] == null) continue;
                    this.cellView[y].allowEdit = this.canAccessViewCells;
                }
            }
            super.func_75142_b();
        }
    }

    protected void updatePowerStatus() {
        try {
            this.hasPower = this.networkNode != null ? this.networkNode.isActive() : (this.powerSrc instanceof IEnergyGrid ? ((IEnergyGrid)this.powerSrc).isNetworkPowered() : this.powerSrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    public void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                IItemList<IAEItemStack> monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEInventoryUpdate();
                        piu.appendItem(send);
                    }
                }
                NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
            }
            catch (IOException e) {
                AELog.error(e);
            }
        }
    }

    @Override
    public void onListUpdate() {
        for (Object c : this.field_75149_d) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("canAccessViewCells")) {
            for (int y = 0; y < 5; ++y) {
                if (this.cellView[y] == null) continue;
                this.cellView[y].allowEdit = this.canAccessViewCells;
            }
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource source) {
        for (IAEItemStack is : change) {
            this.items.add(is);
        }
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.gui != null) {
            this.gui.updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.cellView.length];
        for (int x = 0; x < this.cellView.length; ++x) {
            list[x] = this.cellView[x].func_75211_c();
        }
        return list;
    }
}

