/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.OptionalSlotFakeTypeOnly;
import appeng.container.slot.SlotFakeTypeOnly;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.misc.PartStorageBus;
import appeng.util.Platform;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ContainerStorageBus
extends ContainerUpgradeable {
    PartStorageBus storageBus;
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTACTABLE_ONLY;

    public ContainerStorageBus(InventoryPlayer ip, PartStorageBus te) {
        super(ip, te);
        this.storageBus = te;
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    protected boolean supportCapacity() {
        return true;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.myte.getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx;
    }

    @Override
    protected void setupConfig() {
        int xo = 8;
        int yo = 29;
        IInventory config = this.myte.getInventoryByName("config");
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (y < 2) {
                    this.func_75146_a(new SlotFakeTypeOnly(config, y * 9 + x, xo + x * 18, yo + y * 18));
                    continue;
                }
                this.func_75146_a(new OptionalSlotFakeTypeOnly(config, this, y * 9 + x, xo, yo, x, y, y - 2));
            }
        }
        IInventory upgrades = this.myte.getInventoryByName("upgrades");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 0, 187, 8, this.invPlayer).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 1, 187, 26, this.invPlayer).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 2, 187, 44, this.invPlayer).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 3, 187, 62, this.invPlayer).setNotDraggable());
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 4, 187, 80, this.invPlayer).setNotDraggable());
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.fzMode = (FuzzyMode)this.myte.getConfigManager().getSetting(Settings.FUZZY_MODE);
            this.rwMode = (AccessRestriction)this.myte.getConfigManager().getSetting(Settings.ACCESS);
            this.storageFilter = (StorageFilter)this.myte.getConfigManager().getSetting(Settings.STORAGE_FILTER);
        }
        this.standardDetectAndSendChanges();
    }

    public void clear() {
        IInventory inv = this.myte.getInventoryByName("config");
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            inv.func_70299_a(x, null);
        }
        this.func_75142_b();
    }

    public void partition() {
        IInventory inv = this.myte.getInventoryByName("config");
        MEInventoryHandler cellInv = this.storageBus.getInternalHandler();
        Iterator<Object> i = new NullIterator();
        if (cellInv != null) {
            IItemList<IAEItemStack> list = cellInv.getAvailableItems(AEApi.instance().storage().createItemList());
            i = list.iterator();
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                ItemStack g = ((IAEItemStack)i.next()).getItemStack();
                g.field_77994_a = 1;
                inv.func_70299_a(x, g);
                continue;
            }
            inv.func_70299_a(x, null);
        }
        this.func_75142_b();
    }
}

