/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.parts.IPart;
import appeng.api.util.IConfigManager;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.OptionalSlotFakeTypeOnly;
import appeng.container.slot.SlotFakeTypeOnly;
import appeng.container.slot.SlotRestrictedInput;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.tools.ToolNetworkTool;
import appeng.parts.automation.PartExportBus;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ContainerUpgradeable
extends AEBaseContainer
implements IOptionalSlotHost {
    IUpgradeableHost myte;
    int tbslot;
    NetworkToolViewer tbinv;
    @GuiSync(value=0)
    public RedstoneMode rsMode = RedstoneMode.IGNORE;
    @GuiSync(value=1)
    public FuzzyMode fzMode = FuzzyMode.IGNORE_ALL;
    @GuiSync(value=5)
    public YesNo cMode = YesNo.NO;

    public ContainerUpgradeable(InventoryPlayer ip, IUpgradeableHost te) {
        super(ip, (TileEntity)(te instanceof TileEntity ? te : null), (IPart)((Object)(te instanceof IPart ? te : null)));
        Object myTile;
        this.myte = te;
        World w = null;
        int xCoor = 0;
        int yCoor = 0;
        int zCoor = 0;
        if (te instanceof TileEntity) {
            myTile = (TileEntity)te;
            w = myTile.func_145831_w();
            xCoor = ((TileEntity)myTile).field_145851_c;
            yCoor = ((TileEntity)myTile).field_145848_d;
            zCoor = ((TileEntity)myTile).field_145849_e;
        }
        if (te instanceof IPart) {
            myTile = te;
            TileEntity mk = myTile.getTile();
            w = mk.func_145831_w();
            xCoor = mk.field_145851_c;
            yCoor = mk.field_145848_d;
            zCoor = mk.field_145849_e;
        }
        InventoryPlayer pi = this.getPlayerInv();
        for (int x = 0; x < pi.func_70302_i_(); ++x) {
            ItemStack pii = pi.func_70301_a(x);
            if (pii == null || !(pii.func_77973_b() instanceof ToolNetworkTool)) continue;
            this.lockPlayerInventorySlot(x);
            this.tbslot = x;
            this.tbinv = (NetworkToolViewer)((ToolNetworkTool)pii.func_77973_b()).getGuiObject(pii, w, xCoor, yCoor, zCoor);
            break;
        }
        if (this.hasToolbox()) {
            for (int v = 0; v < 3; ++v) {
                for (int u = 0; u < 3; ++u) {
                    this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, this.tbinv, u + v * 3, 186 + u * 18, this.getHeight() - 82 + v * 18, this.invPlayer).setPlayerSide());
                }
            }
        }
        this.setupConfig();
        this.bindPlayerInventory(ip, 0, this.getHeight() - 82);
    }

    protected void setupUpgrades() {
        IInventory upgrades = this.myte.getInventoryByName("upgrades");
        if (this.availableUpgrades() > 0) {
            this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 0, 187, 8, this.invPlayer).setNotDraggable());
        }
        if (this.availableUpgrades() > 1) {
            this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 1, 187, 26, this.invPlayer).setNotDraggable());
        }
        if (this.availableUpgrades() > 2) {
            this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 2, 187, 44, this.invPlayer).setNotDraggable());
        }
        if (this.availableUpgrades() > 3) {
            this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.UPGRADES, upgrades, 3, 187, 62, this.invPlayer).setNotDraggable());
        }
    }

    protected void setupConfig() {
        int x = 80;
        int y = 40;
        this.setupUpgrades();
        IInventory inv = this.myte.getInventoryByName("config");
        this.func_75146_a(new SlotFakeTypeOnly(inv, 0, x, y));
        if (this.supportCapacity()) {
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 1, x, y, -1, 0, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 2, x, y, 1, 0, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 3, x, y, 0, -1, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 4, x, y, 0, 1, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 5, x, y, -1, -1, 2));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 6, x, y, 1, -1, 2));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 7, x, y, -1, 1, 2));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 8, x, y, 1, 1, 2));
        }
    }

    protected int getHeight() {
        return 184;
    }

    public int availableUpgrades() {
        return 4;
    }

    protected boolean supportCapacity() {
        return true;
    }

    public void checkToolbox() {
        ItemStack currentItem;
        if (this.hasToolbox() && (currentItem = this.getPlayerInv().func_70301_a(this.tbslot)) != this.tbinv.getItemStack()) {
            if (currentItem != null) {
                if (Platform.isSameItem(this.tbinv.getItemStack(), currentItem)) {
                    this.getPlayerInv().func_70299_a(this.tbslot, this.tbinv.getItemStack());
                } else {
                    this.isContainerValid = false;
                }
            } else {
                this.isContainerValid = false;
            }
        }
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            IConfigManager cm = this.myte.getConfigManager();
            this.loadSettingsFromHost(cm);
        }
        this.checkToolbox();
        for (Object o : this.field_75151_b) {
            OptionalSlotFake fs;
            if (!(o instanceof OptionalSlotFake) || (fs = (OptionalSlotFake)((Object)o)).isEnabled() || fs.getDisplayStack() == null) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.fzMode = (FuzzyMode)cm.getSetting(Settings.FUZZY_MODE);
        this.rsMode = (RedstoneMode)cm.getSetting(Settings.REDSTONE_CONTROLLED);
        if (this.myte instanceof PartExportBus) {
            this.cMode = (YesNo)cm.getSetting(Settings.CRAFT_ONLY);
        }
    }

    protected void standardDetectAndSendChanges() {
        super.func_75142_b();
    }

    public boolean hasToolbox() {
        return this.tbinv != null;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.myte.getInstalledUpgrades(Upgrades.CAPACITY);
        if (idx == 1 && upgrades > 0) {
            return true;
        }
        return idx == 2 && upgrades > 1;
    }
}

