/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.features.INetworkEncodable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.container.slot.AppEngSlot;
import appeng.items.misc.ItemEncodedPattern;
import appeng.recipes.handlers.Inscribe;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class SlotRestrictedInput
extends AppEngSlot {
    public PlaceableItemType which;
    public boolean allowEdit = true;
    public int stackLimit = -1;
    private InventoryPlayer p;

    public int func_75219_a() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.func_75219_a();
    }

    public boolean isValid(ItemStack is, World theWorld) {
        if (this.which == PlaceableItemType.VALID_ENCODED_PATTERN_W_OUPUT) {
            ICraftingPatternDetails ap;
            ICraftingPatternDetails iCraftingPatternDetails = ap = is.func_77973_b() instanceof ICraftingPatternItem ? ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, theWorld) : null;
            return ap != null;
        }
        return true;
    }

    @Override
    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        return this.allowEdit;
    }

    public Slot setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    public SlotRestrictedInput(PlaceableItemType valid, IInventory i, int slotnum, int x, int y, InventoryPlayer p) {
        super(i, slotnum, x, y);
        this.which = valid;
        this.IIcon = valid.IIcon;
        this.p = p;
    }

    @Override
    public ItemStack getDisplayStack() {
        ItemEncodedPattern iep;
        ItemStack out;
        ItemStack is;
        if (Platform.isClient() && this.which == PlaceableItemType.ENCODED_PATTERN && (is = super.func_75211_c()) != null && is.func_77973_b() instanceof ItemEncodedPattern && (out = (iep = (ItemEncodedPattern)is.func_77973_b()).getOutput(is)) != null) {
            return out;
        }
        return super.func_75211_c();
    }

    @Override
    public boolean func_75214_a(ItemStack i) {
        if (!this.myContainer.isValidForSlot(this, i)) {
            return false;
        }
        if (i == null) {
            return false;
        }
        if (i.func_77973_b() == null) {
            return false;
        }
        if (!this.field_75224_c.func_94041_b(this.getSlotIndex(), i)) {
            return false;
        }
        IAppEngApi api = AEApi.instance();
        if (!this.allowEdit) {
            return false;
        }
        switch (this.which) {
            case ENCODED_CRAFTING_PATTERN: {
                ICraftingPatternItem b;
                ICraftingPatternDetails de;
                if (i.func_77973_b() instanceof ICraftingPatternItem && (de = (b = (ICraftingPatternItem)i.func_77973_b()).getPatternForItem(i, this.p.field_70458_d.field_70170_p)) != null) {
                    return de.isCraftable();
                }
                return false;
            }
            case VALID_ENCODED_PATTERN_W_OUPUT: 
            case ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN: {
                return i.func_77973_b() instanceof ICraftingPatternItem;
            }
            case BLANK_PATTERN: {
                return AEApi.instance().materials().materialBlankPattern.sameAsStack(i);
            }
            case PATTERN: {
                if (i.func_77973_b() instanceof ICraftingPatternItem) {
                    return true;
                }
                return AEApi.instance().materials().materialBlankPattern.sameAsStack(i);
            }
            case INSCRIBER_PLATE: {
                if (AEApi.instance().materials().materialNamePress.sameAsStack(i)) {
                    return true;
                }
                for (ItemStack is : Inscribe.plates) {
                    if (!Platform.isSameItemPrecise(is, i)) continue;
                    return true;
                }
                return false;
            }
            case INSCRIBER_INPUT: {
                return true;
            }
            case METAL_INGOTS: {
                return SlotRestrictedInput.isMetalIngot(i);
            }
            case VIEWCELL: {
                return AEApi.instance().items().itemViewCell.sameAsStack(i);
            }
            case ORE: {
                return AEApi.instance().registries().grinder().getRecipeForInput(i) != null;
            }
            case FUEL: {
                return TileEntityFurnace.func_145952_a((ItemStack)i) > 0;
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(i);
            }
            case QE_SINGULARTIY: {
                return api.materials().materialQESingularity.sameAsStack(i);
            }
            case RANGE_BOOSTER: {
                return api.materials().materialWirelessBooster.sameAsStack(i);
            }
            case SPATIAL_STORAGE_CELLS: {
                return i.func_77973_b() instanceof ISpatialStorageCell && ((ISpatialStorageCell)i.func_77973_b()).isSpatialStorage(i);
            }
            case STORAGE_CELLS: {
                return AEApi.instance().registries().cell().isCellHandled(i);
            }
            case WORKBENCH_CELL: {
                return i != null && i.func_77973_b() instanceof ICellWorkbenchItem && ((ICellWorkbenchItem)i.func_77973_b()).isEditable(i);
            }
            case STORAGE_COMPONENT: {
                boolean isComp = i.func_77973_b() instanceof IStorageComponent && ((IStorageComponent)i.func_77973_b()).isStorageComponent(i);
                return isComp;
            }
            case TRASH: {
                if (AEApi.instance().registries().cell().isCellHandled(i)) {
                    return false;
                }
                return !(i.func_77973_b() instanceof IStorageComponent) || !((IStorageComponent)i.func_77973_b()).isStorageComponent(i);
            }
            case ENCODEABLE_ITEM: {
                return i.func_77973_b() instanceof INetworkEncodable || AEApi.instance().registries().wireless().isWirelessTerminal(i);
            }
            case BIOMETRIC_CARD: {
                return i.func_77973_b() instanceof IBiometricCard;
            }
            case UPGRADES: {
                return i.func_77973_b() instanceof IUpgradeModule && ((IUpgradeModule)i.func_77973_b()).getType(i) != null;
            }
        }
        return false;
    }

    public static boolean isMetalIngot(ItemStack i) {
        if (Platform.isSameItemPrecise(i, new ItemStack(Items.field_151042_j))) {
            return true;
        }
        for (String name : new String[]{"Copper", "Tin", "Obsidian", "Iron", "Lead", "Bronze", "Brass", "Nickel", "Aluminium"}) {
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                if (!Platform.isSameItemPrecise(i, ingot)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum PlaceableItemType {
        STORAGE_CELLS(15),
        ORE(31),
        STORAGE_COMPONENT(63),
        ENCODEABLE_ITEM(79),
        TRASH(95),
        VALID_ENCODED_PATTERN_W_OUPUT(127),
        ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_CRAFTING_PATTERN(127),
        ENCODED_PATTERN(127),
        PATTERN(143),
        BLANK_PATTERN(143),
        POWERED_TOOL(159),
        RANGE_BOOSTER(111),
        QE_SINGULARTIY(175),
        SPATIAL_STORAGE_CELLS(191),
        FUEL(207),
        UPGRADES(223),
        WORKBENCH_CELL(15),
        BIOMETRIC_CARD(239),
        VIEWCELL(78),
        INSCRIBER_PLATE(46),
        INSCRIBER_INPUT(62),
        METAL_INGOTS(62);

        public final int IIcon;

        private PlaceableItemType(int o) {
            this.IIcon = o;
        }
    }
}

