/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.TunnelType;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.CreativeTabFacade;
import appeng.core.FacadeConfig;
import appeng.core.Registration;
import appeng.core.WorldSettings;
import appeng.core.api.IIMCHandler;
import appeng.core.api.imc.IMCBlackListSpatial;
import appeng.core.api.imc.IMCGrinder;
import appeng.core.api.imc.IMCMatterCannon;
import appeng.core.api.imc.IMCP2PAttunement;
import appeng.core.api.imc.IMCSpatial;
import appeng.core.crash.CrashEnhancement;
import appeng.core.crash.CrashInfo;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.server.AECommand;
import appeng.services.VersionChecker;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.ICommand;

@Mod(modid="appliedenergistics2", acceptedMinecraftVersions="[1.7.10]", name="Applied Energistics 2", version="rv1-stable-1", dependencies="after:appliedenergistics2-core;required-after:Forge@[10.13.0.1187,)", guiFactory="appeng.client.gui.config.AEConfigGuiFactory")
public class AppEng {
    private String configPath;
    public static final String modid = "appliedenergistics2";
    public static final String name = "Applied Energistics 2";
    HashMap<String, IIMCHandler> IMCHandlers = new HashMap();
    public static AppEng instance;
    public static final String dependencies = "after:appliedenergistics2-core;required-after:Forge@[10.13.0.1187,)";

    public String getConfigPath() {
        return this.configPath;
    }

    public AppEng() {
        instance = this;
        this.IMCHandlers.put("blacklist-block-spatial", new IMCBlackListSpatial());
        this.IMCHandlers.put("whitelist-spatial", new IMCSpatial());
        this.IMCHandlers.put("add-grindable", new IMCGrinder());
        this.IMCHandlers.put("add-mattercannon-ammo", new IMCMatterCannon());
        for (TunnelType type : TunnelType.values()) {
            this.IMCHandlers.put("add-p2p-attunement-" + type.name().replace('_', '-').toLowerCase(), new IMCP2PAttunement());
        }
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new CrashEnhancement(CrashInfo.MOD_VERSION));
    }

    public boolean isIntegrationEnabled(IntegrationType Name) {
        return IntegrationRegistry.instance.isEnabled(Name);
    }

    public Object getIntegration(IntegrationType Name) {
        return IntegrationRegistry.instance.getInstance(Name);
    }

    private void startService(String serviceName, Thread thread) {
        thread.setName(serviceName);
        thread.setPriority(1);
        thread.start();
    }

    @Mod.EventHandler
    void PreInit(FMLPreInitializationEvent event) {
        if (!Loader.isModLoaded((String)"appliedenergistics2-core")) {
            CommonHelper.proxy.missingCoreMod();
        }
        Stopwatch star = Stopwatch.createStarted();
        this.configPath = event.getModConfigurationDirectory().getPath() + File.separator + "AppliedEnergistics2" + File.separator;
        AEConfig.instance = new AEConfig(this.configPath);
        FacadeConfig.instance = new FacadeConfig(this.configPath);
        AELog.info("Starting ( PreInit )", new Object[0]);
        CreativeTab.init();
        if (AEConfig.instance.isFeatureEnabled(AEFeature.Facades)) {
            CreativeTabFacade.init();
        }
        if (Platform.isClient()) {
            CommonHelper.proxy.init();
        }
        Registration.instance.PreInit(event);
        if (AEConfig.instance.isFeatureEnabled(AEFeature.VersionChecker)) {
            AELog.info("Starting VersionChecker", new Object[0]);
            VersionChecker.instance = new VersionChecker();
            this.startService("AE2 VersionChecker", new Thread(VersionChecker.instance));
        }
        AELog.info("PreInit ( end " + star.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    void Init(FMLInitializationEvent event) {
        Stopwatch star = Stopwatch.createStarted();
        AELog.info("Init", new Object[0]);
        Registration.instance.Init(event);
        IntegrationRegistry.instance.init();
        AELog.info("Init ( end " + star.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    void PostInit(FMLPostInitializationEvent event) {
        Stopwatch star = Stopwatch.createStarted();
        AELog.info("PostInit", new Object[0]);
        Registration.instance.PostInit(event);
        IntegrationRegistry.instance.postinit();
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new CrashEnhancement(CrashInfo.INTEGRATION));
        CommonHelper.proxy.postinit();
        AEConfig.instance.save();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiBridge.GUI_Handler);
        NetworkHandler.instance = new NetworkHandler("AE2");
        AELog.info("PostInit ( end " + star.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            try {
                IIMCHandler handler = this.IMCHandlers.get(m.key);
                if (handler != null) {
                    handler.post(m);
                    continue;
                }
                throw new RuntimeException("Invalid IMC Called: " + m.key);
            }
            catch (Throwable t) {
                AELog.warning("Problem detected when processing IMC " + m.key + " from " + m.getSender(), new Object[0]);
                AELog.error(t);
            }
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        WorldSettings.getInstance().shutdown();
        TickHandler.instance.shutdown();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerAboutToStartEvent evt) {
        WorldSettings.getInstance().init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new AECommand(evt.getServer()));
    }
}

