/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;

public class FacadeConfig
extends Configuration {
    public static FacadeConfig instance;
    Pattern replacementPattern = Pattern.compile("[^a-zA-Z0-9]");

    public FacadeConfig(String path) {
        super(new File(path + "Facades.cfg"));
    }

    public boolean checkEnabled(Block id, int metadata, boolean automatic) {
        if (id == null) {
            return false;
        }
        GameRegistry.UniqueIdentifier blk = GameRegistry.findUniqueIdentifierFor((Block)id);
        if (blk == null) {
            for (Field f : Block.class.getFields()) {
                try {
                    if (f.get(Block.class) != id) continue;
                    return this.get("minecraft", f.getName() + (metadata == 0 ? "" : "." + metadata), automatic).getBoolean(automatic);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        } else {
            Matcher mod = this.replacementPattern.matcher(blk.modId);
            Matcher name = this.replacementPattern.matcher(blk.name);
            return this.get(mod.replaceAll(""), name.replaceAll("") + (metadata == 0 ? "" : "." + metadata), automatic).getBoolean(automatic);
        }
        return false;
    }
}

