/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.definitions.Blocks;
import appeng.api.definitions.Items;
import appeng.api.definitions.Materials;
import appeng.api.definitions.Parts;
import appeng.api.features.IRecipeHandlerRegistry;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWorldGen;
import appeng.api.movable.IMovableRegistry;
import appeng.api.networking.IGridCacheRegistry;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.parts.IPartHelper;
import appeng.api.util.AEColor;
import appeng.api.util.AEItemDefinition;
import appeng.block.crafting.BlockCraftingMonitor;
import appeng.block.crafting.BlockCraftingStorage;
import appeng.block.crafting.BlockCraftingUnit;
import appeng.block.crafting.BlockMolecularAssembler;
import appeng.block.grindstone.BlockCrank;
import appeng.block.grindstone.BlockGrinder;
import appeng.block.misc.BlockCellWorkbench;
import appeng.block.misc.BlockCharger;
import appeng.block.misc.BlockCondenser;
import appeng.block.misc.BlockInscriber;
import appeng.block.misc.BlockInterface;
import appeng.block.misc.BlockLightDetector;
import appeng.block.misc.BlockPaint;
import appeng.block.misc.BlockQuartzGrowthAccelerator;
import appeng.block.misc.BlockQuartzTorch;
import appeng.block.misc.BlockSecurity;
import appeng.block.misc.BlockSkyCompass;
import appeng.block.misc.BlockTinyTNT;
import appeng.block.misc.BlockVibrationChamber;
import appeng.block.networking.BlockCableBus;
import appeng.block.networking.BlockController;
import appeng.block.networking.BlockCreativeEnergyCell;
import appeng.block.networking.BlockDenseEnergyCell;
import appeng.block.networking.BlockEnergyAcceptor;
import appeng.block.networking.BlockEnergyCell;
import appeng.block.networking.BlockWireless;
import appeng.block.qnb.BlockQuantumLinkChamber;
import appeng.block.qnb.BlockQuantumRing;
import appeng.block.solids.BlockFluix;
import appeng.block.solids.BlockQuartz;
import appeng.block.solids.BlockQuartzChiseled;
import appeng.block.solids.BlockQuartzGlass;
import appeng.block.solids.BlockQuartzLamp;
import appeng.block.solids.BlockQuartzPillar;
import appeng.block.solids.BlockSkyStone;
import appeng.block.solids.OreQuartz;
import appeng.block.solids.OreQuartzCharged;
import appeng.block.spatial.BlockMatrixFrame;
import appeng.block.spatial.BlockSpatialIOPort;
import appeng.block.spatial.BlockSpatialPylon;
import appeng.block.storage.BlockChest;
import appeng.block.storage.BlockDrive;
import appeng.block.storage.BlockIOPort;
import appeng.block.storage.BlockSkyChest;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.features.AEFeatureHandler;
import appeng.core.features.ColoredItemDefinition;
import appeng.core.features.DamagedItemDefinition;
import appeng.core.features.IAEFeature;
import appeng.core.features.IStackSrc;
import appeng.core.features.ItemStackSrc;
import appeng.core.features.NullItemDefinition;
import appeng.core.features.WrappedDamageItemDefinition;
import appeng.core.features.registries.P2PTunnelRegistry;
import appeng.core.features.registries.entries.BasicCellHandler;
import appeng.core.features.registries.entries.CreativeCellHandler;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.debug.BlockChunkloader;
import appeng.debug.BlockCubeGenerator;
import appeng.debug.BlockItemGen;
import appeng.debug.BlockPhantomNode;
import appeng.debug.ToolDebugCard;
import appeng.debug.ToolEraser;
import appeng.debug.ToolMeteoritePlacer;
import appeng.debug.ToolReplicatorCard;
import appeng.hooks.AETrading;
import appeng.hooks.MeteoriteWorldGen;
import appeng.hooks.QuartzWorldGen;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationType;
import appeng.items.materials.ItemMultiMaterial;
import appeng.items.materials.MaterialType;
import appeng.items.misc.ItemCrystalSeed;
import appeng.items.misc.ItemEncodedPattern;
import appeng.items.misc.ItemPaintBall;
import appeng.items.parts.ItemFacade;
import appeng.items.parts.ItemMultiPart;
import appeng.items.parts.PartType;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.items.storage.ItemCreativeStorageCell;
import appeng.items.storage.ItemSpatialStorageCell;
import appeng.items.storage.ItemViewCell;
import appeng.items.tools.ToolBiometricCard;
import appeng.items.tools.ToolMemoryCard;
import appeng.items.tools.ToolNetworkTool;
import appeng.items.tools.powered.ToolChargedStaff;
import appeng.items.tools.powered.ToolColorApplicator;
import appeng.items.tools.powered.ToolEntropyManipulator;
import appeng.items.tools.powered.ToolMassCannon;
import appeng.items.tools.powered.ToolPortableCell;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.items.tools.quartz.ToolQuartzAxe;
import appeng.items.tools.quartz.ToolQuartzCuttingKnife;
import appeng.items.tools.quartz.ToolQuartzHoe;
import appeng.items.tools.quartz.ToolQuartzPickaxe;
import appeng.items.tools.quartz.ToolQuartzSpade;
import appeng.items.tools.quartz.ToolQuartzSword;
import appeng.items.tools.quartz.ToolQuartzWrench;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cache.EnergyGridCache;
import appeng.me.cache.GridStorageCache;
import appeng.me.cache.P2PCache;
import appeng.me.cache.PathGridCache;
import appeng.me.cache.SecurityCache;
import appeng.me.cache.SpatialPylonCache;
import appeng.me.cache.TickManagerCache;
import appeng.me.storage.AEExternalHandler;
import appeng.parts.PartPlacement;
import appeng.recipes.AEItemResolver;
import appeng.recipes.RecipeHandler;
import appeng.recipes.game.DisassembleRecipe;
import appeng.recipes.game.FacadeRecipe;
import appeng.recipes.game.ShapedRecipe;
import appeng.recipes.game.ShapelessRecipe;
import appeng.recipes.handlers.Crusher;
import appeng.recipes.handlers.Grind;
import appeng.recipes.handlers.GrindFZ;
import appeng.recipes.handlers.HCCrusher;
import appeng.recipes.handlers.Inscribe;
import appeng.recipes.handlers.Macerator;
import appeng.recipes.handlers.MekCrusher;
import appeng.recipes.handlers.MekEnrichment;
import appeng.recipes.handlers.Press;
import appeng.recipes.handlers.Pulverizer;
import appeng.recipes.handlers.Shaped;
import appeng.recipes.handlers.Shapeless;
import appeng.recipes.handlers.Smelt;
import appeng.recipes.loader.ConfigLoader;
import appeng.recipes.loader.JarLoader;
import appeng.recipes.ores.OreDictionaryHandler;
import appeng.spatial.BiomeGenStorage;
import appeng.spatial.StorageWorldProvider;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

public class Registration {
    public static final Registration instance = new Registration();
    public RecipeHandler recipeHandler;
    public BiomeGenBase storageBiome;
    private final Multimap<AEFeature, Class> featuresToEntities = ArrayListMultimap.create();

    private Registration() {
        this.recipeHandler = new RecipeHandler();
    }

    public void PreInit(FMLPreInitializationEvent event) {
        this.registerSpatial(false);
        IRecipeHandlerRegistry recipeRegistery = AEApi.instance().registries().recipes();
        recipeRegistery.addNewSubItemResolver(new AEItemResolver());
        recipeRegistery.addNewCraftHandler("hccrusher", HCCrusher.class);
        recipeRegistery.addNewCraftHandler("mekcrusher", MekCrusher.class);
        recipeRegistery.addNewCraftHandler("mekechamber", MekEnrichment.class);
        recipeRegistery.addNewCraftHandler("grind", Grind.class);
        recipeRegistery.addNewCraftHandler("crusher", Crusher.class);
        recipeRegistery.addNewCraftHandler("grindfz", GrindFZ.class);
        recipeRegistery.addNewCraftHandler("pulverizer", Pulverizer.class);
        recipeRegistery.addNewCraftHandler("macerator", Macerator.class);
        recipeRegistery.addNewCraftHandler("smelt", Smelt.class);
        recipeRegistery.addNewCraftHandler("inscribe", Inscribe.class);
        recipeRegistery.addNewCraftHandler("press", Press.class);
        recipeRegistery.addNewCraftHandler("shaped", Shaped.class);
        recipeRegistery.addNewCraftHandler("shapeless", Shapeless.class);
        RecipeSorter.register((String)"AE2-Facade", FacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"AE2-Shaped", ShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"AE2-Shapeless", ShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        MinecraftForge.EVENT_BUS.register((Object)OreDictionaryHandler.instance);
        Items items = Api.instance.items();
        Materials materials = Api.instance.materials();
        Parts parts = Api.instance.parts();
        Blocks blocks = Api.instance.blocks();
        AEFeatureHandler materialItem = (AEFeatureHandler)this.addFeature(ItemMultiMaterial.class, new Object[0]);
        Class<?> materialClass = materials.getClass();
        for (MaterialType mat : MaterialType.values()) {
            try {
                if (mat == MaterialType.InvalidType) {
                    ((ItemMultiMaterial)materialItem.item()).createMaterial(mat);
                    continue;
                }
                Field f = materialClass.getField("material" + mat.name());
                IStackSrc is = ((ItemMultiMaterial)materialItem.item()).createMaterial(mat);
                if (is != null) {
                    f.set(materials, new DamagedItemDefinition(is));
                    continue;
                }
                f.set(materials, new NullItemDefinition());
            }
            catch (Throwable err) {
                AELog.severe("Error creating material: " + mat.name(), new Object[0]);
                throw new RuntimeException(err);
            }
        }
        AEFeatureHandler partItem = (AEFeatureHandler)this.addFeature(ItemMultiPart.class, new Object[0]);
        Class<?> partClass = parts.getClass();
        for (PartType type : PartType.values()) {
            try {
                if (type == PartType.InvalidType) {
                    ((ItemMultiPart)partItem.item()).createPart(type, null);
                    continue;
                }
                Field f = partClass.getField("part" + type.name());
                Enum[] varients = type.getVarients();
                if (varients == null) {
                    ItemStackSrc is = ((ItemMultiPart)partItem.item()).createPart(type, null);
                    if (is != null) {
                        f.set(parts, new DamagedItemDefinition(is));
                        continue;
                    }
                    f.set(parts, new NullItemDefinition());
                    continue;
                }
                if (!(varients[0] instanceof AEColor)) continue;
                ColoredItemDefinition def = new ColoredItemDefinition();
                for (Enum v : varients) {
                    ItemStackSrc is = ((ItemMultiPart)partItem.item()).createPart(type, v);
                    if (is == null) continue;
                    def.add((AEColor)v, is);
                }
                f.set(parts, def);
            }
            catch (Throwable err) {
                AELog.severe("Error creating part: " + type.name(), new Object[0]);
                throw new RuntimeException(err);
            }
        }
        blocks.blockMultiPart = this.addFeature(BlockCableBus.class, new Object[0]);
        blocks.blockCraftingUnit = this.addFeature(BlockCraftingUnit.class, new Object[0]);
        blocks.blockCraftingAccelerator = new WrappedDamageItemDefinition(blocks.blockCraftingUnit, 1);
        blocks.blockCraftingMonitor = this.addFeature(BlockCraftingMonitor.class, new Object[0]);
        blocks.blockCraftingStorage1k = this.addFeature(BlockCraftingStorage.class, new Object[0]);
        blocks.blockCraftingStorage4k = new WrappedDamageItemDefinition(blocks.blockCraftingStorage1k, 1);
        blocks.blockCraftingStorage16k = new WrappedDamageItemDefinition(blocks.blockCraftingStorage1k, 2);
        blocks.blockCraftingStorage64k = new WrappedDamageItemDefinition(blocks.blockCraftingStorage1k, 3);
        blocks.blockMolecularAssembler = this.addFeature(BlockMolecularAssembler.class, new Object[0]);
        blocks.blockQuartzOre = this.addFeature(OreQuartz.class, new Object[0]);
        blocks.blockQuartzOreCharged = this.addFeature(OreQuartzCharged.class, new Object[0]);
        blocks.blockMatrixFrame = this.addFeature(BlockMatrixFrame.class, new Object[0]);
        blocks.blockQuartz = this.addFeature(BlockQuartz.class, new Object[0]);
        blocks.blockFluix = this.addFeature(BlockFluix.class, new Object[0]);
        blocks.blockSkyStone = this.addFeature(BlockSkyStone.class, new Object[0]);
        blocks.blockSkyChest = this.addFeature(BlockSkyChest.class, new Object[0]);
        blocks.blockSkyCompass = this.addFeature(BlockSkyCompass.class, new Object[0]);
        blocks.blockQuartzGlass = this.addFeature(BlockQuartzGlass.class, new Object[0]);
        blocks.blockQuartzVibrantGlass = this.addFeature(BlockQuartzLamp.class, new Object[0]);
        blocks.blockQuartzPiller = this.addFeature(BlockQuartzPillar.class, new Object[0]);
        blocks.blockQuartzChiseled = this.addFeature(BlockQuartzChiseled.class, new Object[0]);
        blocks.blockQuartzTorch = this.addFeature(BlockQuartzTorch.class, new Object[0]);
        blocks.blockLightDetector = this.addFeature(BlockLightDetector.class, new Object[0]);
        blocks.blockCharger = this.addFeature(BlockCharger.class, new Object[0]);
        blocks.blockQuartzGrowthAccelerator = this.addFeature(BlockQuartzGrowthAccelerator.class, new Object[0]);
        blocks.blockGrindStone = this.addFeature(BlockGrinder.class, new Object[0]);
        blocks.blockCrankHandle = this.addFeature(BlockCrank.class, new Object[0]);
        blocks.blockInscriber = this.addFeature(BlockInscriber.class, new Object[0]);
        blocks.blockWireless = this.addFeature(BlockWireless.class, new Object[0]);
        blocks.blockTinyTNT = this.addFeature(BlockTinyTNT.class, new Object[0]);
        blocks.blockQuantumRing = this.addFeature(BlockQuantumRing.class, new Object[0]);
        blocks.blockQuantumLink = this.addFeature(BlockQuantumLinkChamber.class, new Object[0]);
        blocks.blockSpatialPylon = this.addFeature(BlockSpatialPylon.class, new Object[0]);
        blocks.blockSpatialIOPort = this.addFeature(BlockSpatialIOPort.class, new Object[0]);
        blocks.blockController = this.addFeature(BlockController.class, new Object[0]);
        blocks.blockDrive = this.addFeature(BlockDrive.class, new Object[0]);
        blocks.blockChest = this.addFeature(BlockChest.class, new Object[0]);
        blocks.blockInterface = this.addFeature(BlockInterface.class, new Object[0]);
        blocks.blockCellWorkbench = this.addFeature(BlockCellWorkbench.class, new Object[0]);
        blocks.blockIOPort = this.addFeature(BlockIOPort.class, new Object[0]);
        blocks.blockCondenser = this.addFeature(BlockCondenser.class, new Object[0]);
        blocks.blockEnergyAcceptor = this.addFeature(BlockEnergyAcceptor.class, new Object[0]);
        blocks.blockVibrationChamber = this.addFeature(BlockVibrationChamber.class, new Object[0]);
        blocks.blockEnergyCell = this.addFeature(BlockEnergyCell.class, new Object[0]);
        blocks.blockEnergyCellDense = this.addFeature(BlockDenseEnergyCell.class, new Object[0]);
        blocks.blockEnergyCellCreative = this.addFeature(BlockCreativeEnergyCell.class, new Object[0]);
        blocks.blockSecurity = this.addFeature(BlockSecurity.class, new Object[0]);
        blocks.blockPaint = this.addFeature(BlockPaint.class, new Object[0]);
        items.itemCellCreative = this.addFeature(ItemCreativeStorageCell.class, new Object[0]);
        items.itemViewCell = this.addFeature(ItemViewCell.class, new Object[0]);
        items.itemEncodedPattern = this.addFeature(ItemEncodedPattern.class, new Object[0]);
        items.itemCell1k = this.addFeature(ItemBasicStorageCell.class, new Object[]{MaterialType.Cell1kPart, 1});
        items.itemCell4k = this.addFeature(ItemBasicStorageCell.class, new Object[]{MaterialType.Cell4kPart, 4});
        items.itemCell16k = this.addFeature(ItemBasicStorageCell.class, new Object[]{MaterialType.Cell16kPart, 16});
        items.itemCell64k = this.addFeature(ItemBasicStorageCell.class, new Object[]{MaterialType.Cell64kPart, 64});
        items.itemSpatialCell2 = this.addFeature(ItemSpatialStorageCell.class, new Object[]{MaterialType.Cell2SpatialPart, 2});
        items.itemSpatialCell16 = this.addFeature(ItemSpatialStorageCell.class, new Object[]{MaterialType.Cell16SpatialPart, 16});
        items.itemSpatialCell128 = this.addFeature(ItemSpatialStorageCell.class, new Object[]{MaterialType.Cell128SpatialPart, 128});
        items.itemCertusQuartzKnife = this.addFeature(ToolQuartzCuttingKnife.class, new Object[]{AEFeature.CertusQuartzTools});
        items.itemCertusQuartzWrench = this.addFeature(ToolQuartzWrench.class, new Object[]{AEFeature.CertusQuartzTools});
        items.itemCertusQuartzAxe = this.addFeature(ToolQuartzAxe.class, new Object[]{AEFeature.CertusQuartzTools});
        items.itemCertusQuartzHoe = this.addFeature(ToolQuartzHoe.class, new Object[]{AEFeature.CertusQuartzTools});
        items.itemCertusQuartzPick = this.addFeature(ToolQuartzPickaxe.class, new Object[]{AEFeature.CertusQuartzTools});
        items.itemCertusQuartzShovel = this.addFeature(ToolQuartzSpade.class, new Object[]{AEFeature.CertusQuartzTools});
        items.itemCertusQuartzSword = this.addFeature(ToolQuartzSword.class, new Object[]{AEFeature.CertusQuartzTools});
        items.itemNetherQuartzKnife = this.addFeature(ToolQuartzCuttingKnife.class, new Object[]{AEFeature.NetherQuartzTools});
        items.itemNetherQuartzWrench = this.addFeature(ToolQuartzWrench.class, new Object[]{AEFeature.NetherQuartzTools});
        items.itemNetherQuartzAxe = this.addFeature(ToolQuartzAxe.class, new Object[]{AEFeature.NetherQuartzTools});
        items.itemNetherQuartzHoe = this.addFeature(ToolQuartzHoe.class, new Object[]{AEFeature.NetherQuartzTools});
        items.itemNetherQuartzPick = this.addFeature(ToolQuartzPickaxe.class, new Object[]{AEFeature.NetherQuartzTools});
        items.itemNetherQuartzShovel = this.addFeature(ToolQuartzSpade.class, new Object[]{AEFeature.NetherQuartzTools});
        items.itemNetherQuartzSword = this.addFeature(ToolQuartzSword.class, new Object[]{AEFeature.NetherQuartzTools});
        items.itemMassCannon = this.addFeature(ToolMassCannon.class, new Object[0]);
        items.itemMemoryCard = this.addFeature(ToolMemoryCard.class, new Object[0]);
        items.itemChargedStaff = this.addFeature(ToolChargedStaff.class, new Object[0]);
        items.itemEntropyManipulator = this.addFeature(ToolEntropyManipulator.class, new Object[0]);
        items.itemColorApplicator = this.addFeature(ToolColorApplicator.class, new Object[0]);
        items.itemWirelessTerminal = this.addFeature(ToolWirelessTerminal.class, new Object[0]);
        items.itemNetworkTool = this.addFeature(ToolNetworkTool.class, new Object[0]);
        items.itemPortableCell = this.addFeature(ToolPortableCell.class, new Object[0]);
        items.itemBiometricCard = this.addFeature(ToolBiometricCard.class, new Object[0]);
        items.itemFacade = this.addFeature(ItemFacade.class, new Object[0]);
        items.itemCrystalSeed = this.addFeature(ItemCrystalSeed.class, new Object[0]);
        ColoredItemDefinition pbreg = new ColoredItemDefinition();
        items.itemPaintBall = pbreg;
        ColoredItemDefinition pbregl = new ColoredItemDefinition();
        items.itemLumenPaintBall = pbregl;
        AEItemDefinition pb = this.addFeature(ItemPaintBall.class, new Object[0]);
        for (AEColor c : AEColor.values()) {
            if (c == AEColor.Transparent) continue;
            pbreg.add(c, new ItemStackSrc(pb.item(), c.ordinal()));
            pbregl.add(c, new ItemStackSrc(pb.item(), 20 + c.ordinal()));
        }
        this.addFeature(ToolEraser.class, new Object[0]);
        this.addFeature(ToolMeteoritePlacer.class, new Object[0]);
        this.addFeature(ToolDebugCard.class, new Object[0]);
        this.addFeature(ToolReplicatorCard.class, new Object[0]);
        this.addFeature(BlockItemGen.class, new Object[0]);
        this.addFeature(BlockChunkloader.class, new Object[0]);
        this.addFeature(BlockPhantomNode.class, new Object[0]);
        this.addFeature(BlockCubeGenerator.class, new Object[0]);
    }

    private AEItemDefinition addFeature(Class c, Object ... Args) {
        try {
            Constructor<?>[] con = c.getConstructors();
            Object obj = null;
            for (Constructor<?> conItem : con) {
                Class<?>[] paramTypes = conItem.getParameterTypes();
                if (paramTypes.length != Args.length) continue;
                boolean valid = true;
                for (int idx = 0; idx < paramTypes.length; ++idx) {
                    Class<?> cz = Args[idx].getClass();
                    if (this.isClassMatch(paramTypes[idx], cz, Args[idx])) continue;
                    valid = false;
                }
                if (!valid) continue;
                obj = conItem.newInstance(Args);
                break;
            }
            if (obj instanceof IAEFeature) {
                IAEFeature feature = obj;
                for (AEFeature f : feature.feature().getFeatures()) {
                    this.featuresToEntities.put((Object)f, (Object)c);
                }
                feature.feature().register();
                feature.postInit();
                return feature.feature();
            }
            if (obj == null) {
                throw new RuntimeException("No valid constructor found.");
            }
            throw new RuntimeException("Non AE Feature Registered");
        }
        catch (Throwable e) {
            throw new RuntimeException("Error with Feature: " + c.getName(), e);
        }
    }

    private boolean isClassMatch(Class expected, Class got, Object value) {
        if (value == null && !expected.isPrimitive()) {
            return true;
        }
        return (expected = this.condense(expected, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class)) == (got = this.condense(got, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class)) || expected.isAssignableFrom(got);
    }

    private Class condense(Class expected, Class ... wrappers) {
        if (expected.isPrimitive()) {
            for (Class clz : wrappers) {
                try {
                    if (expected == clz.getField("TYPE").get(null)) {
                        return clz;
                    }
                }
                catch (Throwable t) {
                    AELog.error(t);
                }
            }
        }
        return expected;
    }

    public void Init(FMLInitializationEvent event) {
        ItemMultiMaterial.instance.unduplicate();
        if (AEConfig.instance.isFeatureEnabled(AEFeature.CustomRecipes)) {
            this.recipeHandler.parseRecipes(new ConfigLoader(AppEng.instance.getConfigPath()), "index.recipe");
        } else {
            this.recipeHandler.parseRecipes(new JarLoader("/assets/appliedenergistics2/recipes/"), "index.recipe");
        }
        IPartHelper ph = AEApi.instance().partHelper();
        ph.registerNewLayer("appeng.parts.layers.LayerISidedInventory", "net.minecraft.inventory.ISidedInventory");
        ph.registerNewLayer("appeng.parts.layers.LayerIFluidHandler", "net.minecraftforge.fluids.IFluidHandler");
        ph.registerNewLayer("appeng.parts.layers.LayerITileStorageMonitorable", "appeng.api.implementations.tiles.ITileStorageMonitorable");
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.IC2)) {
            ph.registerNewLayer("appeng.parts.layers.LayerIEnergySink", "ic2.api.energy.tile.IEnergySink");
            ph.registerNewLayer("appeng.parts.layers.LayerIEnergySource", "ic2.api.energy.tile.IEnergySource");
        }
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.MJ5)) {
            ph.registerNewLayer("appeng.parts.layers.LayerIPowerEmitter", "buildcraft.api.power.IPowerEmitter");
            ph.registerNewLayer("appeng.parts.layers.LayerIPowerReceptor", "buildcraft.api.power.IPowerReceptor");
        }
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.MJ6)) {
            ph.registerNewLayer("appeng.parts.layers.LayerIBatteryProvider", "buildcraft.api.mj.IBatteryProvider");
        }
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.RF)) {
            ph.registerNewLayer("appeng.parts.layers.LayerIEnergyHandler", "cofh.api.energy.IEnergyHandler");
        }
        FMLCommonHandler.instance().bus().register((Object)TickHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)TickHandler.instance);
        PartPlacement pp = new PartPlacement();
        MinecraftForge.EVENT_BUS.register((Object)pp);
        FMLCommonHandler.instance().bus().register((Object)pp);
        IGridCacheRegistry gcr = AEApi.instance().registries().gridCache();
        gcr.registerGridCache(ITickManager.class, TickManagerCache.class);
        gcr.registerGridCache(IEnergyGrid.class, EnergyGridCache.class);
        gcr.registerGridCache(IPathingGrid.class, PathGridCache.class);
        gcr.registerGridCache(IStorageGrid.class, GridStorageCache.class);
        gcr.registerGridCache(P2PCache.class, P2PCache.class);
        gcr.registerGridCache(ISpatialCache.class, SpatialPylonCache.class);
        gcr.registerGridCache(ISecurityGrid.class, SecurityCache.class);
        gcr.registerGridCache(ICraftingGrid.class, CraftingGridCache.class);
        AEApi.instance().registries().externalStorage().addExternalStorageInterface(new AEExternalHandler());
        AEApi.instance().registries().cell().addCellHandler(new BasicCellHandler());
        AEApi.instance().registries().cell().addCellHandler(new CreativeCellHandler());
        AEApi.instance().registries().matterCannon().registerAmmo(AEApi.instance().materials().materialMatterBall.stack(1), 32.0);
        this.recipeHandler.injectRecipes();
        if (AEConfig.instance.isFeatureEnabled(AEFeature.enableDisassemblyCrafting)) {
            CraftingManager.func_77594_a().func_77592_b().add(new DisassembleRecipe());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.enableFacadeCrafting)) {
            CraftingManager.func_77594_a().func_77592_b().add(new FacadeRecipe());
        }
    }

    public void PostInit(FMLPostInitializationEvent event) {
        this.registerSpatial(true);
        ((P2PTunnelRegistry)AEApi.instance().registries().p2pTunnel()).configure();
        PlayerMessages.values();
        GuiText.values();
        Api.instance.partHelper.initFMPSupport();
        ((BlockCableBus)AEApi.instance().blocks().blockMultiPart.block()).setupTile();
        Upgrades.CRAFTING.registerItem(AEApi.instance().parts().partInterface.stack(1), 1);
        Upgrades.CRAFTING.registerItem(AEApi.instance().blocks().blockInterface.stack(1), 1);
        Upgrades.SPEED.registerItem(AEApi.instance().blocks().blockIOPort.stack(1), 3);
        Upgrades.REDSTONE.registerItem(AEApi.instance().blocks().blockIOPort.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().parts().partLevelEmitter.stack(1), 1);
        Upgrades.CRAFTING.registerItem(AEApi.instance().parts().partLevelEmitter.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().parts().partImportBus.stack(1), 1);
        Upgrades.REDSTONE.registerItem(AEApi.instance().parts().partImportBus.stack(1), 1);
        Upgrades.CAPACITY.registerItem(AEApi.instance().parts().partImportBus.stack(1), 2);
        Upgrades.SPEED.registerItem(AEApi.instance().parts().partImportBus.stack(1), 4);
        Upgrades.FUZZY.registerItem(AEApi.instance().parts().partExportBus.stack(1), 1);
        Upgrades.REDSTONE.registerItem(AEApi.instance().parts().partExportBus.stack(1), 1);
        Upgrades.CAPACITY.registerItem(AEApi.instance().parts().partExportBus.stack(1), 2);
        Upgrades.SPEED.registerItem(AEApi.instance().parts().partExportBus.stack(1), 4);
        Upgrades.CRAFTING.registerItem(AEApi.instance().parts().partExportBus.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().items().itemCell1k.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().items().itemCell1k.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().items().itemCell4k.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().items().itemCell4k.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().items().itemCell16k.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().items().itemCell16k.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().items().itemCell64k.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().items().itemCell64k.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().items().itemPortableCell.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().items().itemPortableCell.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().items().itemViewCell.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().items().itemViewCell.stack(1), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().parts().partStorageBus.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().parts().partStorageBus.stack(1), 1);
        Upgrades.CAPACITY.registerItem(AEApi.instance().parts().partStorageBus.stack(1), 5);
        Upgrades.FUZZY.registerItem(AEApi.instance().parts().partFormationPlane.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().parts().partFormationPlane.stack(1), 1);
        Upgrades.CAPACITY.registerItem(AEApi.instance().parts().partFormationPlane.stack(1), 5);
        Upgrades.FUZZY.registerItem(AEApi.instance().items().itemMassCannon.stack(1), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().items().itemMassCannon.stack(1), 1);
        Upgrades.SPEED.registerItem(AEApi.instance().items().itemMassCannon.stack(1), 4);
        Upgrades.SPEED.registerItem(AEApi.instance().blocks().blockMolecularAssembler.stack(1), 5);
        AEApi.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)AEApi.instance().items().itemWirelessTerminal.item());
        if (AEConfig.instance.isFeatureEnabled(AEFeature.ChestLoot)) {
            ChestGenHooks d = ChestGenHooks.getInfo((String)"mineshaftCorridor");
            d.addItem(new WeightedRandomChestContent(AEApi.instance().materials().materialCertusQuartzCrystal.stack(1), 1, 4, 2));
            d.addItem(new WeightedRandomChestContent(AEApi.instance().materials().materialCertusQuartzDust.stack(1), 1, 4, 2));
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.VillagerTrading)) {
            VillagerRegistry.instance().registerVillageTradeHandler(3, (VillagerRegistry.IVillageTradeHandler)new AETrading());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.CertusQuartzWorldGen)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new QuartzWorldGen(), (int)0);
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.MeteoriteWorldGen)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new MeteoriteWorldGen(), (int)0);
        }
        IMovableRegistry mr = AEApi.instance().registries().moveable();
        mr.blacklistBlock(net.minecraft.init.Blocks.field_150357_h);
        mr.whiteListTileEntity(TileEntityBeacon.class);
        mr.whiteListTileEntity(TileEntityBrewingStand.class);
        mr.whiteListTileEntity(TileEntityChest.class);
        mr.whiteListTileEntity(TileEntityCommandBlock.class);
        mr.whiteListTileEntity(TileEntityComparator.class);
        mr.whiteListTileEntity(TileEntityDaylightDetector.class);
        mr.whiteListTileEntity(TileEntityDispenser.class);
        mr.whiteListTileEntity(TileEntityDropper.class);
        mr.whiteListTileEntity(TileEntityEnchantmentTable.class);
        mr.whiteListTileEntity(TileEntityEnderChest.class);
        mr.whiteListTileEntity(TileEntityEndPortal.class);
        mr.whiteListTileEntity(TileEntitySkull.class);
        mr.whiteListTileEntity(TileEntityFurnace.class);
        mr.whiteListTileEntity(TileEntityMobSpawner.class);
        mr.whiteListTileEntity(TileEntitySign.class);
        mr.whiteListTileEntity(TileEntityPiston.class);
        mr.whiteListTileEntity(TileEntityFlowerPot.class);
        mr.whiteListTileEntity(TileEntityNote.class);
        mr.whiteListTileEntity(TileEntityHopper.class);
        OreDictionary.registerOre((String)"itemWheat", (Item)net.minecraft.init.Items.field_151015_O);
        mr.whiteListTileEntity(AEBaseTile.class);
        for (IWorldGen.WorldGenType type : IWorldGen.WorldGenType.values()) {
            AEApi.instance().registries().worldgen().disableWorldGenForProviderID(type, StorageWorldProvider.class);
            AEApi.instance().registries().worldgen().disableWorldGenForDimension(type, 1);
            AEApi.instance().registries().worldgen().disableWorldGenForDimension(type, -1);
        }
        OreDictionaryHandler.instance.bakeRecipes();
    }

    private void registerSpatial(boolean force) {
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.SpatialIO)) {
            return;
        }
        AEConfig config = AEConfig.instance;
        if (this.storageBiome == null) {
            if (force && config.storageBiomeID == -1) {
                config.storageBiomeID = Platform.findEmpty(BiomeGenBase.func_150565_n());
                if (config.storageBiomeID == -1) {
                    throw new RuntimeException("Biome Array is full, please free up some Biome ID's or disable spatial.");
                }
                this.storageBiome = new BiomeGenStorage(config.storageBiomeID);
                config.save();
            }
            if (!force && config.storageBiomeID != -1) {
                this.storageBiome = new BiomeGenStorage(config.storageBiomeID);
            }
        }
        if (config.storageProviderID != -1) {
            DimensionManager.registerProviderType((int)config.storageProviderID, StorageWorldProvider.class, (boolean)false);
        }
        if (config.storageProviderID == -1 && force) {
            config.storageProviderID = -11;
            while (!DimensionManager.registerProviderType((int)config.storageProviderID, StorageWorldProvider.class, (boolean)false)) {
                --config.storageProviderID;
            }
            config.save();
        }
    }
}

