/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.util.WorldCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNewStorageDimension;
import appeng.hooks.TickHandler;
import appeng.me.GridStorage;
import appeng.me.GridStorageSearch;
import appeng.services.CompassService;
import com.mojang.authlib.GameProfile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class WorldSettings
extends Configuration {
    private static WorldSettings instance;
    long lastGridStorage = 0L;
    int lastPlayer = 0;
    private CompassService compass;
    File AEFolder;
    List<Integer> storageCellDims = new ArrayList<Integer>();
    private WeakHashMap<GridStorageSearch, WeakReference<GridStorageSearch>> loadedStorage = new WeakHashMap();

    public WorldSettings(File aeFolder) {
        super(new File(aeFolder.getPath() + File.separatorChar + "settings.cfg"));
        this.AEFolder = aeFolder;
        this.compass = new CompassService(this.AEFolder);
        for (int dimID : this.get("DimensionManager", "StorageCells", new int[0]).getIntList()) {
            this.storageCellDims.add(dimID);
            DimensionManager.registerDimension((int)dimID, (int)AEConfig.instance.storageProviderID);
        }
        try {
            this.lastGridStorage = Long.parseLong(this.get("Counters", "lastGridStorage", 0).getString());
            this.lastPlayer = this.get("Counters", "lastPlayer", 0).getInt();
        }
        catch (NumberFormatException err) {
            this.lastGridStorage = 0L;
            this.lastPlayer = 0;
        }
    }

    NBTTagCompound loadSpawnData(int dim, int chunkX, int chunkZ) {
        if (!Thread.holdsLock(WorldSettings.class)) {
            throw new RuntimeException("Invalid Request");
        }
        File f = new File(this.AEFolder, "spawndata" + File.separatorChar + dim + "_" + (chunkX >> 4) + "_" + (chunkZ >> 4) + ".dat");
        if (f.isFile() && f.exists()) {
            try {
                FileInputStream fis = new FileInputStream(f);
                NBTTagCompound data = null;
                try {
                    data = CompressedStreamTools.func_74796_a((InputStream)fis);
                }
                catch (Throwable e) {
                    data = new NBTTagCompound();
                    AELog.error(e);
                }
                fis.close();
                return data;
            }
            catch (Throwable e) {
                AELog.error(e);
            }
        }
        return new NBTTagCompound();
    }

    void writeSpawnData(int dim, int chunkX, int chunkZ, NBTTagCompound data) {
        if (!Thread.holdsLock(WorldSettings.class)) {
            throw new RuntimeException("Invalid Request");
        }
        File f = new File(this.AEFolder, "spawndata" + File.separatorChar + dim + "_" + (chunkX >> 4) + "_" + (chunkZ >> 4) + ".dat");
        try {
            FileOutputStream fos = new FileOutputStream(f);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fos);
            }
            catch (Throwable e) {
                AELog.error(e);
            }
            fos.close();
        }
        catch (Throwable e) {
            AELog.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NBTTagCompound> getNearByMetetorites(int dim, int chunkX, int chunkZ) {
        LinkedList<NBTTagCompound> ll = new LinkedList<NBTTagCompound>();
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int cx = x + (chunkX >> 4);
                    int cz = z + (chunkZ >> 4);
                    NBTTagCompound data = this.loadSpawnData(dim, cx << 4, cz << 4);
                    if (data == null) continue;
                    int size = data.func_74762_e("num");
                    for (int s = 0; s < size; ++s) {
                        ll.add(data.func_74775_l("" + s));
                    }
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGenerated(int dim, int chunkX, int chunkZ) {
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return data.func_74767_n(chunkX + "," + chunkZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenerated(int dim, int chunkX, int chunkZ) {
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            data.func_74757_a(chunkX + "," + chunkZ, true);
            this.writeSpawnData(dim, chunkX, chunkZ, data);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNearByMetetorites(int dim, int chunkX, int chunkZ, NBTTagCompound newData) {
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            int size = data.func_74762_e("num");
            data.func_74782_a("" + size, (NBTBase)newData);
            data.func_74768_a("num", size + 1);
            this.writeSpawnData(dim, chunkX, chunkZ, data);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    public void shutdown() {
        this.save();
        for (Integer dimID : this.storageCellDims) {
            DimensionManager.unregisterDimension((int)dimID);
        }
        this.storageCellDims.clear();
        this.compass.kill();
        instance = null;
    }

    public void addStorageCellDim(int newDim) {
        this.storageCellDims.add(newDim);
        DimensionManager.registerDimension((int)newDim, (int)AEConfig.instance.storageProviderID);
        try {
            NetworkHandler.instance.sendToAll(new PacketNewStorageDimension(newDim));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] values = new String[this.storageCellDims.size()];
        for (int x = 0; x < values.length; ++x) {
            values[x] = "" + this.storageCellDims.get(x);
        }
        this.get("DimensionManager", "StorageCells", new int[0]).set(values);
        this.save();
    }

    public CompassService getCompass() {
        return this.compass;
    }

    public static WorldSettings getInstance() {
        if (instance == null) {
            File world = DimensionManager.getCurrentSaveRootDirectory();
            File aeBaseFolder = new File(world.getPath() + File.separatorChar + "AE2");
            if (!(aeBaseFolder.exists() && aeBaseFolder.isDirectory() || aeBaseFolder.mkdir() && aeBaseFolder.exists())) {
                throw new RuntimeException("Failed to create " + aeBaseFolder.getAbsolutePath());
            }
            File compass = new File(aeBaseFolder, "compass");
            if (!(compass.exists() && compass.isDirectory() || compass.mkdir() && compass.exists())) {
                throw new RuntimeException("Failed to create " + compass.getAbsolutePath());
            }
            File spawnData = new File(aeBaseFolder, "spawndata");
            if (!(spawnData.exists() && spawnData.isDirectory() || spawnData.mkdir() && spawnData.exists())) {
                throw new RuntimeException("Failed to create " + spawnData.getAbsolutePath());
            }
            instance = new WorldSettings(aeBaseFolder);
        }
        return instance;
    }

    public void sendToPlayer(NetworkManager manager, EntityPlayerMP player) {
        if (manager != null) {
            for (int newDim : this.get("DimensionManager", "StorageCells", new int[0]).getIntList()) {
                try {
                    manager.func_150725_a((Packet)new PacketNewStorageDimension(newDim).getProxy(), new GenericFutureListener[0]);
                }
                catch (IOException e) {
                    AELog.error(e);
                }
            }
        } else {
            for (TickHandler.PlayerColor pc : TickHandler.instance.getPlayerColors().values()) {
                NetworkHandler.instance.sendToAll(pc.getPacket());
            }
        }
    }

    public void init() {
        this.save();
    }

    public WorldCoord getStoredSize(int dim) {
        int x = this.get("StorageCell" + dim, "scaleX", 0).getInt();
        int y = this.get("StorageCell" + dim, "scaleY", 0).getInt();
        int z = this.get("StorageCell" + dim, "scaleZ", 0).getInt();
        return new WorldCoord(x, y, z);
    }

    public void setStoredSize(int dim, int targetX, int targetY, int targetZ) {
        this.get("StorageCell" + dim, "scaleX", 0).set(targetX);
        this.get("StorageCell" + dim, "scaleY", 0).set(targetY);
        this.get("StorageCell" + dim, "scaleZ", 0).set(targetZ);
        this.save();
    }

    public GridStorage getGridStorage(long storageID) {
        GridStorageSearch gss = new GridStorageSearch(storageID);
        WeakReference<GridStorageSearch> result = this.loadedStorage.get(gss);
        if (result == null || result.get() == null) {
            String Data = this.get("gridstorage", "" + storageID, "").getString();
            GridStorage thisStorage = new GridStorage(Data, storageID, gss);
            gss.gridStorage = new WeakReference<GridStorage>(thisStorage);
            this.loadedStorage.put(gss, new WeakReference<GridStorageSearch>(gss));
            return thisStorage;
        }
        return (GridStorage)((GridStorageSearch)result.get()).gridStorage.get();
    }

    public GridStorage getNewGridStorage() {
        long storageID = this.nextGridStorage();
        GridStorageSearch gss = new GridStorageSearch(storageID);
        GridStorage newStorage = new GridStorage(storageID, gss);
        gss.gridStorage = new WeakReference<GridStorage>(newStorage);
        this.loadedStorage.put(gss, new WeakReference<GridStorageSearch>(gss));
        return newStorage;
    }

    public void destroyGridStorage(long id) {
        this.getCategory("gridstorage").remove((Object)("" + id));
    }

    public void save() {
        for (GridStorageSearch gs : this.loadedStorage.keySet()) {
            GridStorage thisStorage = (GridStorage)gs.gridStorage.get();
            if (thisStorage == null || thisStorage.getGrid() == null || thisStorage.getGrid().isEmpty()) continue;
            String value = thisStorage.getValue();
            this.get("gridstorage", "" + thisStorage.getID(), value).set(value);
        }
        if (this.hasChanged()) {
            super.save();
        }
    }

    private long nextGridStorage() {
        long r = this.lastGridStorage++;
        this.get("Counters", "lastGridStorage", this.lastGridStorage).set(Long.toString(this.lastGridStorage));
        return r;
    }

    private long nextPlayer() {
        long r = this.lastPlayer++;
        this.get("Counters", "lastPlayer", this.lastPlayer).set(this.lastPlayer);
        return r;
    }

    public int getNextOrderedValue(String name) {
        Property p = this.get("orderedValues", name, 0);
        int myValue = p.getInt();
        p.set(myValue + 1);
        return myValue;
    }

    public int getPlayerID(GameProfile profile) {
        ConfigCategory playerList = this.getCategory("players");
        if (playerList == null || profile == null || !profile.isComplete()) {
            return -1;
        }
        String uuid = profile.getId().toString();
        Property prop = playerList.get(uuid);
        if (prop != null && prop.isIntValue()) {
            return prop.getInt();
        }
        prop = new Property(uuid, "" + this.nextPlayer(), Property.Type.INTEGER);
        playerList.put(uuid, prop);
        this.save();
        return prop.getInt();
    }
}

