/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.util.AEItemDefinition;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseItemBlock;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.CreativeTabFacade;
import appeng.core.features.AEFeature;
import appeng.core.features.IAEFeature;
import appeng.items.parts.ItemFacade;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class AEFeatureHandler
implements AEItemDefinition {
    private final EnumSet<AEFeature> myFeatures;
    private final String subname;
    private IAEFeature obj;
    private Item ItemData;
    private Block BlockData;

    public AEFeatureHandler(EnumSet<AEFeature> featureSet, IAEFeature _obj, String _subname) {
        this.myFeatures = featureSet;
        this.obj = _obj;
        this.subname = _subname;
    }

    public void register() {
        if (this.isFeatureAvailable()) {
            if (this.obj instanceof Item) {
                this.initItem((Item)this.obj);
            }
            if (this.obj instanceof Block) {
                this.initBlock((Block)this.obj);
            }
        }
    }

    public static String getName(Class o, String subname) {
        String name = o.getSimpleName();
        if (name.startsWith("ItemMultiPart")) {
            name = name.replace("ItemMultiPart", "ItemPart");
        } else if (name.startsWith("ItemMultiMaterial")) {
            name = name.replace("ItemMultiMaterial", "ItemMaterial");
        }
        if (subname != null) {
            if (subname.startsWith("P2PTunnel")) {
                return "ItemPart.P2PTunnel";
            }
            if (subname.equals("CertusQuartzTools")) {
                return name.replace("Quartz", "CertusQuartz");
            }
            if (subname.equals("NetherQuartzTools")) {
                return name.replace("Quartz", "NetherQuartz");
            }
            name = name + "." + subname;
        }
        return name;
    }

    private void initItem(Item i) {
        this.ItemData = i;
        String name = AEFeatureHandler.getName(i.getClass(), this.subname);
        i.func_111206_d("appliedenergistics2:" + name);
        i.func_77655_b("appliedenergistics2." + name);
        if (i instanceof ItemFacade) {
            i.func_77637_a((CreativeTabs)CreativeTabFacade.instance);
        } else {
            i.func_77637_a((CreativeTabs)CreativeTab.instance);
        }
        if (name.equals("ItemMaterial")) {
            name = "ItemMultiMaterial";
        } else if (name.equals("ItemPart")) {
            name = "ItemMultiPart";
        }
        GameRegistry.registerItem((Item)i, (String)("item." + name));
    }

    private void initBlock(Block b) {
        this.BlockData = b;
        String name = AEFeatureHandler.getName(b.getClass(), this.subname);
        b.func_149647_a((CreativeTabs)CreativeTab.instance);
        b.func_149663_c("appliedenergistics2." + name);
        b.func_149658_d("appliedenergistics2:" + name);
        if (Platform.isClient() && this.BlockData instanceof AEBaseBlock) {
            AEBaseBlock bb = (AEBaseBlock)b;
            CommonHelper.proxy.bindTileEntitySpecialRenderer(bb.getTileEntityClass(), bb);
        }
        Class<AEBaseItemBlock> itemBlock = AEBaseItemBlock.class;
        if (b instanceof AEBaseBlock) {
            itemBlock = ((AEBaseBlock)b).getItemBlockClass();
        }
        GameRegistry.registerBlock((Block)b, itemBlock, (String)("tile." + name));
    }

    public EnumSet<AEFeature> getFeatures() {
        return this.myFeatures.clone();
    }

    public boolean isFeatureAvailable() {
        boolean enabled = true;
        for (AEFeature f : this.myFeatures) {
            enabled = enabled && AEConfig.instance.isFeatureEnabled(f);
        }
        return enabled;
    }

    @Override
    public Block block() {
        return this.BlockData;
    }

    @Override
    public Class<? extends TileEntity> entity() {
        if (this.BlockData instanceof AEBaseBlock) {
            AEBaseBlock bb = (AEBaseBlock)this.BlockData;
            return bb.getTileEntityClass();
        }
        return null;
    }

    @Override
    public Item item() {
        if (this.ItemData == null && this.BlockData != null) {
            return Item.func_150898_a((Block)this.BlockData);
        }
        return this.ItemData;
    }

    @Override
    public ItemStack stack(int stackSize) {
        if (this.isFeatureAvailable()) {
            ItemStack rv = null;
            rv = this.ItemData != null ? new ItemStack(this.ItemData) : new ItemStack(this.BlockData);
            rv.field_77994_a = stackSize;
            return rv;
        }
        return null;
    }

    @Override
    public boolean sameAsStack(ItemStack is) {
        if (this.isFeatureAvailable()) {
            return Platform.isSameItemType(is, this.stack(1));
        }
        return false;
    }

    @Override
    public boolean sameAsBlock(IBlockAccess world, int x, int y, int z) {
        if (this.isFeatureAvailable() && this.BlockData != null) {
            return world.func_147439_a(x, y, z) == this.block();
        }
        return false;
    }
}

