/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IWorldGen;
import java.util.HashSet;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public class WorldGenRegistry
implements IWorldGen {
    TypeSet[] types = new TypeSet[IWorldGen.WorldGenType.values().length];
    public static final WorldGenRegistry instance = new WorldGenRegistry();

    private WorldGenRegistry() {
        for (IWorldGen.WorldGenType type : IWorldGen.WorldGenType.values()) {
            this.types[type.ordinal()] = new TypeSet();
        }
    }

    @Override
    public boolean isWorldGenEnabled(IWorldGen.WorldGenType type, World w) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        if (w == null) {
            throw new IllegalArgumentException("Bad Provider Passed");
        }
        return !this.types[type.ordinal()].badProviders.contains(w.field_73011_w.getClass()) && !this.types[type.ordinal()].badDimentions.contains(w.field_73011_w.field_76574_g);
    }

    @Override
    public void disableWorldGenForProviderID(IWorldGen.WorldGenType type, Class<? extends WorldProvider> provider) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Bad Provider Passed");
        }
        this.types[type.ordinal()].badProviders.add(provider);
    }

    @Override
    public void disableWorldGenForDimension(IWorldGen.WorldGenType type, int dimid) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        this.types[type.ordinal()].badDimentions.add(dimid);
    }

    private class TypeSet {
        HashSet<Class<? extends WorldProvider>> badProviders = new HashSet();
        HashSet<Integer> badDimentions = new HashSet();

        private TypeSet() {
        }
    }
}

