/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.AEApi;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.ToolNetworkTool;
import appeng.items.tools.powered.ToolColorApplicator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketClick
extends AppEngPacket {
    int x;
    int y;
    int z;
    int side;
    float hitX;
    float hitY;
    float hitZ;

    public PacketClick(ByteBuf stream) throws IOException {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        this.side = stream.readInt();
        this.hitX = stream.readFloat();
        this.hitY = stream.readFloat();
        this.hitZ = stream.readFloat();
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && is.func_77973_b() instanceof ToolNetworkTool) {
            ToolNetworkTool tnt = (ToolNetworkTool)is.func_77973_b();
            tnt.serverSideToolLogic(is, player, player.field_70170_p, this.x, this.y, this.z, this.side, this.hitX, this.hitY, this.hitZ);
        } else if (is != null && AEApi.instance().items().itemMemoryCard.sameAsStack(is)) {
            IMemoryCard mem = (IMemoryCard)is.func_77973_b();
            mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
            is.func_77982_d(null);
        } else if (is != null && AEApi.instance().items().itemColorApplicator.sameAsStack(is)) {
            ToolColorApplicator mem = (ToolColorApplicator)is.func_77973_b();
            mem.cycleColors(is, mem.getColor(is), 1);
        }
    }

    public PacketClick(int x, int y, int z, int side, float hitX, float hitY, float hitZ) throws IOException {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.x = x;
        data.writeInt(this.x);
        this.y = y;
        data.writeInt(this.y);
        this.z = z;
        data.writeInt(this.z);
        this.side = side;
        data.writeInt(this.side);
        this.hitX = hitX;
        data.writeFloat(this.hitX);
        this.hitY = hitY;
        data.writeFloat(this.hitY);
        this.hitZ = hitZ;
        data.writeFloat(this.hitZ);
        this.configureWrite(data);
    }
}

