/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.DimensionalCoord;
import appeng.core.WorldSettings;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompassResponse;
import appeng.services.helpers.ICompassCallback;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketCompassRequest
extends AppEngPacket
implements ICompassCallback {
    public final long attunement;
    public final int cx;
    public final int cz;
    public final int cdy;
    EntityPlayer talkBackTo;

    public PacketCompassRequest(ByteBuf stream) throws IOException {
        this.attunement = stream.readLong();
        this.cx = stream.readInt();
        this.cz = stream.readInt();
        this.cdy = stream.readInt();
    }

    @Override
    public void calculatedDirection(boolean hasResult, boolean spin, double radians, double dist) {
        NetworkHandler.instance.sendTo(new PacketCompassResponse(this, hasResult, spin, radians), (EntityPlayerMP)this.talkBackTo);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        this.talkBackTo = player;
        DimensionalCoord loc = new DimensionalCoord(player.field_70170_p, this.cx << 4, this.cdy << 5, this.cz << 4);
        WorldSettings.getInstance().getCompass().getCompassDirection(loc, 174, this);
    }

    public PacketCompassRequest(long attunement, int cx, int cz, int cdy) throws IOException {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.attunement = attunement;
        data.writeLong(this.attunement);
        this.cx = cx;
        data.writeInt(this.cx);
        this.cz = cz;
        data.writeInt(this.cz);
        this.cdy = cdy;
        data.writeInt(this.cdy);
        this.configureWrite(data);
    }
}

