/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigureableObject;
import appeng.container.AEBaseContainer;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketConfigButton
extends AppEngPacket {
    public final Settings option;
    public final boolean rotationDirection;

    public PacketConfigButton(ByteBuf stream) throws IOException {
        this.option = Settings.values()[stream.readInt()];
        this.rotationDirection = stream.readBoolean();
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        AEBaseContainer aebc = (AEBaseContainer)sender.field_71070_bA;
        if (aebc.getTarget() instanceof IConfigureableObject) {
            IConfigManager cm = ((IConfigureableObject)aebc.getTarget()).getConfigManager();
            Enum newState = Platform.rotateEnum(cm.getSetting(this.option), this.rotationDirection, this.option.getPossibleValues());
            cm.putSetting(this.option, newState);
        }
    }

    public PacketConfigButton(Settings option, boolean rotationDirection) throws IOException {
        this.option = option;
        this.rotationDirection = rotationDirection;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(option.ordinal());
        data.writeBoolean(rotationDirection);
        this.configureWrite(data);
    }
}

