/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.core.features.AEFeature;
import appeng.hooks.TickHandler;
import appeng.items.AEBaseItem;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.me.cache.TickManagerCache;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.networking.TileController;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolDebugCard
extends AEBaseItem {
    public ToolDebugCard() {
        super(ToolDebugCard.class);
        this.setfeature(EnumSet.of(AEFeature.UnsupportedDeveloperTools, AEFeature.Creative));
    }

    public String timeMeasurement(long nanos) {
        long ms = nanos / 100000L;
        if (nanos <= 100000L) {
            return nanos + "ns";
        }
        return (float)ms / 10.0f + "ms";
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (Platform.isClient()) {
            return false;
        }
        if (player.func_70093_af()) {
            int grids = 0;
            int totalNodes = 0;
            for (Grid g : TickHandler.instance.getGridList()) {
                ++grids;
                totalNodes += g.getNodes().size();
            }
            this.outputMsg(player, "Grids: " + grids);
            this.outputMsg(player, "Total Nodes: " + totalNodes);
        } else {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IGridHost) {
                GridNode node = (GridNode)((IGridHost)te).getGridNode(ForgeDirection.getOrientation((int)side));
                if (node != null) {
                    Grid g = node.getInternalGrid();
                    IGridNode center = g.getPivot();
                    this.outputMsg(player, "This Node: " + node.toString());
                    this.outputMsg(player, "Center Node: " + center.toString());
                    IPathingGrid pg = (IPathingGrid)g.getCache(IPathingGrid.class);
                    if (pg.getControllerState() == ControllerState.CONTROLLER_ONLINE) {
                        int length = 0;
                        HashSet<IGridNode> next = new HashSet<IGridNode>();
                        next.add(node);
                        int maxLength = 10000;
                        block1: while (!next.isEmpty()) {
                            HashSet<IGridNode> current = next;
                            next = new HashSet();
                            for (IGridNode n : current) {
                                if (n.getMachine() instanceof TileController) break block1;
                                for (IGridConnection c : n.getConnections()) {
                                    next.add(c.getOtherSide(n));
                                }
                            }
                            if (++length <= maxLength) continue;
                            break;
                        }
                        this.outputMsg(player, "Cable Distance: " + length);
                    }
                    if (center.getMachine() instanceof PartP2PTunnel) {
                        this.outputMsg(player, "Freq: " + ((PartP2PTunnel)center.getMachine()).freq);
                    }
                    TickManagerCache tmc = (TickManagerCache)g.getCache(ITickManager.class);
                    for (Class<? extends IGridHost> c : g.getMachineClasses()) {
                        int o = 0;
                        long nanos = 0L;
                        for (IGridNode oj : g.getMachines(c)) {
                            ++o;
                            nanos += tmc.getAvgNanoTime(oj);
                        }
                        if (nanos < 0L) {
                            this.outputMsg(player, c.getSimpleName() + " - " + o);
                            continue;
                        }
                        this.outputMsg(player, c.getSimpleName() + " - " + o + "; " + this.timeMeasurement(nanos));
                    }
                } else {
                    this.outputMsg(player, "No Node Available.");
                }
            } else {
                this.outputMsg(player, "Not Networked Block");
            }
            if (te instanceof IPartHost) {
                IPart center = ((IPartHost)te).getPart(ForgeDirection.UNKNOWN);
                ((IPartHost)te).markForUpdate();
                if (center != null) {
                    GridNode n = (GridNode)center.getGridNode();
                    this.outputMsg(player, "Node Channels: " + n.usedChannels());
                    for (IGridConnection gc : n.getConnections()) {
                        ForgeDirection fd = gc.getDirection(n);
                        if (fd == ForgeDirection.UNKNOWN) continue;
                        this.outputMsg(player, fd.toString() + ": " + gc.getUsedChannels());
                    }
                }
            }
            if (te instanceof IAEPowerStorage) {
                IGridNode node;
                IAEPowerStorage ps = (IAEPowerStorage)te;
                this.outputMsg(player, "Energy: " + ps.getAECurrentPower() + " / " + ps.getAEMaxPower());
                if (te instanceof IGridHost && (node = ((IGridHost)te).getGridNode(ForgeDirection.getOrientation((int)side))) != null && node.getGrid() != null) {
                    IEnergyGrid eg = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
                    this.outputMsg(player, "GridEnerg: " + eg.getStoredPower() + " : " + eg.getEnergyDemand(Double.MAX_VALUE));
                }
            }
        }
        return true;
    }

    private void outputMsg(EntityPlayer player, String string) {
        player.func_145747_a((IChatComponent)new ChatComponentText(string));
    }
}

