/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.AEApi;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.core.AppEng;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBC;
import appeng.items.parts.ItemFacade;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class FacadeContainer
implements IFacadeContainer {
    private final IFacadePart[] facades = new FacadePart[6];

    public void writeToStream(ByteBuf out) throws IOException {
        int x;
        int facadeSides = 0;
        for (x = 0; x < this.facades.length; ++x) {
            if (this.getFacade(ForgeDirection.getOrientation((int)x)) == null) continue;
            facadeSides |= 1 << x;
        }
        out.writeByte((int)((byte)facadeSides));
        for (x = 0; x < this.facades.length; ++x) {
            IFacadePart part = this.getFacade(ForgeDirection.getOrientation((int)x));
            if (part == null) continue;
            int itemID = Item.func_150891_b((Item)part.getItem());
            int dmgValue = part.getItemDamage();
            out.writeInt(itemID * (part.isBC() ? -1 : 1));
            out.writeInt(dmgValue);
        }
    }

    public boolean readFromStream(ByteBuf out) throws IOException {
        byte facadeSides = out.readByte();
        boolean changed = false;
        int[] ids = new int[2];
        for (int x = 0; x < this.facades.length; ++x) {
            ForgeDirection side = ForgeDirection.getOrientation((int)x);
            int ix = 1 << x;
            if ((facadeSides & ix) == ix) {
                ItemFacade ifa;
                ItemStack facade;
                ids[0] = out.readInt();
                ids[1] = out.readInt();
                boolean isBC = ids[0] < 0;
                ids[0] = Math.abs(ids[0]);
                if (isBC && AppEng.instance.isIntegrationEnabled(IntegrationType.BC)) {
                    IBC bc = (IBC)AppEng.instance.getIntegration(IntegrationType.BC);
                    changed = changed || this.facades[x] == null;
                    this.facades[x] = bc.createFacadePart((Block)Block.field_149771_c.func_148754_a(ids[0]), ids[1], side);
                    continue;
                }
                if (isBC || (facade = (ifa = (ItemFacade)AEApi.instance().items().itemFacade.item()).createFromInts(ids)) == null) continue;
                changed = changed || this.facades[x] == null;
                this.facades[x] = ifa.createPartFromItemStack(facade, side);
                continue;
            }
            changed = changed || this.facades[x] != null;
            this.facades[x] = null;
        }
        return changed;
    }

    public void readFromNBT(NBTTagCompound c) {
        for (int x = 0; x < this.facades.length; ++x) {
            IBC bc;
            ItemStack is;
            this.facades[x] = null;
            NBTTagCompound t = c.func_74775_l("facade:" + x);
            if (t == null || (is = ItemStack.func_77949_a((NBTTagCompound)t)) == null) continue;
            Item i = is.func_77973_b();
            if (i instanceof IFacadeItem) {
                this.facades[x] = ((IFacadeItem)i).createPartFromItemStack(is, ForgeDirection.getOrientation((int)x));
                continue;
            }
            if (!AppEng.instance.isIntegrationEnabled(IntegrationType.BC) || !(bc = (IBC)AppEng.instance.getIntegration(IntegrationType.BC)).isFacade(is)) continue;
            this.facades[x] = bc.createFacadePart(is, ForgeDirection.getOrientation((int)x));
        }
    }

    public void writeToNBT(NBTTagCompound c) {
        for (int x = 0; x < this.facades.length; ++x) {
            if (this.facades[x] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            this.facades[x].getItemStack().func_77955_b(data);
            c.func_74782_a("facade:" + x, (NBTBase)data);
        }
    }

    @Override
    public boolean addFacade(IFacadePart a) {
        if (this.getFacade(a.getSide()) == null) {
            this.facades[a.getSide().ordinal()] = a;
            return true;
        }
        return false;
    }

    @Override
    public void removeFacade(IPartHost host, ForgeDirection side) {
        if (side != null && side != ForgeDirection.UNKNOWN && this.facades[side.ordinal()] != null) {
            this.facades[side.ordinal()] = null;
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public IFacadePart getFacade(ForgeDirection s) {
        return this.facades[s.ordinal()];
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.facades.length; ++x) {
            if (this.facades[x] == null) continue;
            return false;
        }
        return true;
    }

    public void rotateLeft() {
        FacadePart[] newfacades = new FacadePart[6];
        newfacades[ForgeDirection.UP.ordinal()] = this.facades[ForgeDirection.UP.ordinal()];
        newfacades[ForgeDirection.DOWN.ordinal()] = this.facades[ForgeDirection.DOWN.ordinal()];
        newfacades[ForgeDirection.EAST.ordinal()] = this.facades[ForgeDirection.NORTH.ordinal()];
        newfacades[ForgeDirection.SOUTH.ordinal()] = this.facades[ForgeDirection.EAST.ordinal()];
        newfacades[ForgeDirection.WEST.ordinal()] = this.facades[ForgeDirection.SOUTH.ordinal()];
        newfacades[ForgeDirection.NORTH.ordinal()] = this.facades[ForgeDirection.WEST.ordinal()];
        for (int x = 0; x < this.facades.length; ++x) {
            this.facades[x] = newfacades[x];
        }
    }
}

