/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigureableObject;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.helpers.MultiCraftingTracker;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.storage.MEMonitorIInventory;
import appeng.me.storage.MEMonitorPassthu;
import appeng.me.storage.NullInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.WrapperInvSlot;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DualityInterface
implements IGridTickable,
ISegmentedInventory,
IStorageMonitorable,
IInventoryDestination,
IAEAppEngInventory,
IConfigureableObject,
IConfigManagerHost,
ICraftingProvider,
IUpgradeableHost,
IPriorityHost {
    final int[] sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    final IAEItemStack[] requireWork = new IAEItemStack[]{null, null, null, null, null, null, null, null};
    final MultiCraftingTracker craftingTracker;
    boolean hasConfig = false;
    AENetworkProxy gridProxy;
    IInterfaceHost iHost;
    BaseActionSource mySrc;
    ConfigManager cm = new ConfigManager(this);
    int priority;
    List<ICraftingPatternDetails> craftingList = null;
    List<ItemStack> waitingToSend = null;
    private UpgradeInventory upgrades;
    AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 8);
    AppEngInternalInventory storage = new AppEngInternalInventory(this, 8);
    AppEngInternalInventory patterns = new AppEngInternalInventory(this, 9);
    WrapperInvSlot slotInv = new WrapperInvSlot(this.storage);
    IMEInventory<IAEItemStack> destination;
    private boolean isWorking = false;
    private static boolean interfaceRequest = false;
    MEMonitorPassthu<IAEItemStack> items = new MEMonitorPassthu(new NullInventory(), StorageChannel.ITEMS);
    MEMonitorPassthu<IAEFluidStack> fluids = new MEMonitorPassthu(new NullInventory(), StorageChannel.FLUIDS);
    static final Set<Block> badBlocks = new HashSet<Block>();

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        if (this.upgrades == null) {
            return 0;
        }
        return this.upgrades.getInstalledUpgrades(u);
    }

    public boolean hasItemsToSend() {
        return this.waitingToSend != null && !this.waitingToSend.isEmpty();
    }

    public void updateCraftingList() {
        Boolean[] accountedFor = new Boolean[]{false, false, false, false, false, false, false, false, false};
        assert (accountedFor.length == this.patterns.func_70302_i_());
        if (!this.gridProxy.isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patterns.func_70301_a(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (accountedFor[x].booleanValue()) continue;
            this.addToCraftingList(this.patterns.func_70301_a(x));
        }
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is == null) {
            return;
        }
        if (is.func_77973_b() instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.iHost.getTileEntity().func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new LinkedList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    public void addToSendList(ItemStack is) {
        if (is == null) {
            return;
        }
        if (this.waitingToSend == null) {
            this.waitingToSend = new LinkedList<ItemStack>();
        }
        this.waitingToSend.add(is);
        try {
            this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public DualityInterface(AENetworkProxy prox, IInterfaceHost ih) {
        this.gridProxy = prox;
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.upgrades = new UpgradeInventory(this.gridProxy.getMachineRepresentation(), this, 1);
        this.cm.registerSetting(Settings.BLOCK, YesNo.NO);
        this.cm.registerSetting(Settings.INTERFACE_TERMINAL, YesNo.YES);
        this.iHost = ih;
        this.craftingTracker = new MultiCraftingTracker(this.iHost, 9);
        this.fluids.changeSource = this.items.changeSource = new MachineSource(this.iHost);
        this.mySrc = this.items.changeSource;
    }

    @Override
    public void saveChanges() {
        this.iHost.saveChanges();
    }

    private void readConfig() {
        this.hasConfig = false;
        for (ItemStack p : this.config) {
            if (p == null) continue;
            this.hasConfig = true;
            break;
        }
        boolean had = this.hasWorkToDo();
        for (int x = 0; x < 8; ++x) {
            this.updatePlan(x);
        }
        boolean has = this.hasWorkToDo();
        if (had != has) {
            try {
                if (has) {
                    this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                } else {
                    this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.notifyNeightbors();
    }

    public void writeToNBT(NBTTagCompound data) {
        this.config.writeToNBT(data, "config");
        this.patterns.writeToNBT(data, "patterns");
        this.storage.writeToNBT(data, "storage");
        this.upgrades.writeToNBT(data, "upgrades");
        this.cm.writeToNBT(data);
        this.craftingTracker.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        NBTTagList waitingToSend = new NBTTagList();
        if (this.waitingToSend != null) {
            for (ItemStack is : this.waitingToSend) {
                NBTTagCompound item = new NBTTagCompound();
                is.func_77955_b(item);
                waitingToSend.func_74742_a((NBTBase)item);
            }
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.waitingToSend = null;
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        if (waitingList != null) {
            for (int x = 0; x < waitingList.func_74745_c(); ++x) {
                NBTTagCompound c = waitingList.func_150305_b(x);
                if (c == null) continue;
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)c);
                this.addToSendList(is);
            }
        }
        this.craftingTracker.readFromNBT(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.config.readFromNBT(data, "config");
        this.patterns.readFromNBT(data, "patterns");
        this.storage.readFromNBT(data, "storage");
        this.priority = data.func_74762_e("priority");
        this.cm.readFromNBT(data);
        this.readConfig();
        this.updateCraftingList();
    }

    private InventoryAdaptor getAdaptor(int slot) {
        return new AdaptorIInventory(this.slotInv.getWrapper(slot));
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        IAEItemStack out = this.destination.injectItems(AEApi.instance().storage().createItemStack(stack), Actionable.SIMULATE, null);
        if (out == null) {
            return true;
        }
        return out.getStackSize() != (long)stack.field_77994_a;
    }

    private void updatePlan(int slot) {
        IAEItemStack req = this.config.getAEStackInSlot(slot);
        if (req != null && req.getStackSize() <= 0L) {
            this.config.func_70299_a(slot, null);
            req = null;
        }
        ItemStack Stored = this.storage.func_70301_a(slot);
        if (req == null && Stored != null) {
            IAEItemStack work = AEApi.instance().storage().createItemStack(Stored);
            this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
            return;
        }
        if (req != null) {
            if (Stored == null) {
                this.requireWork[slot] = req.copy();
                return;
            }
            if (req.isSameType(Stored)) {
                if (req.getStackSize() != (long)Stored.field_77994_a) {
                    this.requireWork[slot] = req.copy();
                    this.requireWork[slot].setStackSize(req.getStackSize() - (long)Stored.field_77994_a);
                    return;
                }
            } else if (Stored != null) {
                IAEItemStack work = AEApi.instance().storage().createItemStack(Stored);
                this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
                return;
            }
        }
        this.requireWork[slot] = null;
    }

    private boolean usePlan(int x, IAEItemStack itemStack) {
        boolean changed = false;
        InventoryAdaptor adaptor = this.getAdaptor(x);
        this.isWorking = true;
        interfaceRequest = true;
        try {
            this.destination = this.gridProxy.getStorage().getItemInventory();
            IEnergyGrid src = this.gridProxy.getEnergy();
            if (this.craftingTracker.isBusy(x)) {
                changed = this.handleCrafting(x, adaptor, itemStack) || changed;
            } else if (itemStack.getStackSize() > 0L) {
                if (adaptor.simulateAdd(itemStack.getItemStack()) != null) {
                    changed = true;
                    throw new GridAccessException();
                }
                IAEItemStack aquired = Platform.poweredExtraction(src, this.destination, itemStack, this.mySrc);
                if (aquired != null) {
                    changed = true;
                    ItemStack issue = adaptor.addItems(aquired.getItemStack());
                    if (issue != null) {
                        throw new RuntimeException("bad attempt at managing inventory. ( addItems )");
                    }
                } else {
                    changed = this.handleCrafting(x, adaptor, itemStack) || changed;
                }
            } else if (itemStack.getStackSize() < 0L) {
                IAEItemStack toStore = itemStack.copy();
                toStore.setStackSize(-toStore.getStackSize());
                long diff = toStore.getStackSize();
                ItemStack canExtract = adaptor.simulateRemove((int)diff, toStore.getItemStack(), null);
                if (canExtract == null || (long)canExtract.field_77994_a != diff) {
                    changed = true;
                    throw new GridAccessException();
                }
                if ((toStore = Platform.poweredInsert(src, this.destination, toStore, this.mySrc)) != null) {
                    diff -= toStore.getStackSize();
                }
                if (diff != 0L) {
                    changed = true;
                    ItemStack removed = adaptor.removeItems((int)diff, null, null);
                    if (removed == null) {
                        throw new RuntimeException("bad attempt at managing inventory. ( removeItems )");
                    }
                    if ((long)removed.field_77994_a != diff) {
                        throw new RuntimeException("bad attempt at managing inventory. ( removeItems )");
                    }
                }
            }
        }
        catch (GridAccessException e) {
            // empty catch block
        }
        if (changed) {
            this.updatePlan(x);
        }
        this.isWorking = false;
        interfaceRequest = false;
        return changed;
    }

    private boolean handleCrafting(int x, InventoryAdaptor d, IAEItemStack itemStack) {
        try {
            if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && itemStack != null) {
                return this.craftingTracker.handleCrafting(x, itemStack.getStackSize(), itemStack, d, this.iHost.getTileEntity().func_145831_w(), this.gridProxy.getGrid(), this.gridProxy.getCrafting(), this.mySrc);
            }
        }
        catch (GridAccessException e) {
            // empty catch block
        }
        return false;
    }

    public IInventory getConfig() {
        return this.config;
    }

    public IInventory getPatterns() {
        return this.patterns;
    }

    public void gridChanged() {
        try {
            this.items.setInternal(this.gridProxy.getStorage().getItemInventory());
            this.fluids.setInternal(this.gridProxy.getStorage().getFluidInventory());
        }
        catch (GridAccessException gae) {
            this.items.setInternal(new NullInventory());
            this.fluids.setInternal(new NullInventory());
        }
        this.notifyNeightbors();
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.iHost.getTileEntity());
    }

    public IInventory getInternalInventory() {
        return this.storage;
    }

    public void markDirty() {
        for (int slot = 0; slot < this.storage.func_70302_i_(); ++slot) {
            this.onChangeInventory(this.storage, slot, InvOperation.markDirty, null, null);
        }
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isWorking) {
            return;
        }
        if (inv == this.config) {
            this.readConfig();
        } else if (inv == this.patterns && (removed != null || added != null)) {
            this.updateCraftingList();
        } else if (inv == this.storage && slot >= 0) {
            boolean had = this.hasWorkToDo();
            this.updatePlan(slot);
            boolean now = this.hasWorkToDo();
            if (had != now) {
                try {
                    if (now) {
                        this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                    } else {
                        this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                    }
                }
                catch (GridAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    public boolean hasWorkToDo() {
        return this.hasItemsToSend() || this.requireWork[0] != null || this.requireWork[1] != null || this.requireWork[2] != null || this.requireWork[3] != null || this.requireWork[4] != null || this.requireWork[5] != null || this.requireWork[6] != null || this.requireWork[7] != null;
    }

    private boolean updateStorage() {
        boolean didSomething = false;
        for (int x = 0; x < 8; ++x) {
            if (this.requireWork[x] == null) continue;
            didSomething = this.usePlan(x, this.requireWork[x]) || didSomething;
        }
        return didSomething;
    }

    public boolean hasConfig() {
        return this.hasConfig;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return this.sides;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Interface.min, TickRates.Interface.max, !this.hasWorkToDo(), true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.hasItemsToSend()) {
            this.pushItemsOut(EnumSet.allOf(ForgeDirection.class));
        }
        boolean couldDoWork = this.updateStorage();
        return this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        if (this.hasConfig()) {
            return new InterfaceInventory(this);
        }
        return this.items;
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.hasConfig()) {
            return null;
        }
        return this.fluids;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("storage")) {
            return this.storage;
        }
        if (name.equals("patterns")) {
            return this.patterns;
        }
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    public IInventory getStorage() {
        return this.storage;
    }

    @Override
    public TileEntity getTile() {
        return (TileEntity)(this.iHost instanceof TileEntity ? this.iHost : null);
    }

    public IPart getPart() {
        return (IPart)((Object)(this.iHost instanceof IPart ? this.iHost : null));
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) == 0) {
            this.cancelCrafting();
        }
        this.markDirty();
    }

    private void cancelCrafting() {
        this.craftingTracker.cancel();
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src, IStorageMonitorable myInterface) {
        if (Platform.canAccess(this.gridProxy, src)) {
            return myInterface;
        }
        final DualityInterface di = this;
        return new IStorageMonitorable(){

            @Override
            public IMEMonitor<IAEItemStack> getItemInventory() {
                return new InterfaceInventory(di);
            }

            @Override
            public IMEMonitor<IAEFluidStack> getFluidInventory() {
                return null;
            }
        };
    }

    @Override
    public boolean isBusy() {
        if (this.hasItemsToSend()) {
            return true;
        }
        boolean busy = false;
        if (this.isBlocking()) {
            EnumSet<ForgeDirection> possibleDirections = this.iHost.getTargets();
            TileEntity tile = this.iHost.getTileEntity();
            World w = tile.func_145831_w();
            boolean allAreBusy = true;
            for (ForgeDirection s : possibleDirections) {
                TileEntity te = w.func_147438_o(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
                InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.getOpposite());
                if (ad == null || ad.simulateRemove(1, null, null) != null) continue;
                allAreBusy = false;
                break;
            }
            busy = allAreBusy;
        }
        return busy;
    }

    private boolean isBlocking() {
        return this.cm.getSetting(Settings.BLOCK) == YesNo.YES;
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.hasItemsToSend() || !this.gridProxy.isActive()) {
            return false;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        EnumSet<ForgeDirection> possibleDirections = this.iHost.getTargets();
        for (ForgeDirection s : possibleDirections) {
            ICraftingMachine cm;
            TileEntity te = w.func_147438_o(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
            if (te instanceof IInterfaceHost) {
                try {
                    if (((IInterfaceHost)te).getInterfaceDuality().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            if (te instanceof ICraftingMachine && (cm = (ICraftingMachine)te).acceptsPlans()) {
                if (!cm.pushPattern(patternDetails, table, s.getOpposite())) continue;
                return true;
            }
            InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.getOpposite());
            if (ad == null || this.isBlocking() && ad.simulateRemove(1, null, null) != null || !this.acceptsItems(ad, table)) continue;
            for (int x = 0; x < table.func_70302_i_(); ++x) {
                ItemStack is = table.func_70301_a(x);
                if (is == null) continue;
                this.addToSendList(ad.addItems(is));
            }
            this.pushItemsOut(possibleDirections);
            return true;
        }
        return false;
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.gridProxy.getGrid();
    }

    private boolean acceptsItems(InventoryAdaptor ad, InventoryCrafting table) {
        for (int x = 0; x < table.func_70302_i_(); ++x) {
            ItemStack is = table.func_70301_a(x);
            if (is == null || ad.simulateAdd(is.func_77946_l()) == null) continue;
            return false;
        }
        return true;
    }

    private void pushItemsOut(EnumSet<ForgeDirection> possibleDirections) {
        if (!this.hasItemsToSend()) {
            return;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        Iterator<ItemStack> i = this.waitingToSend.iterator();
        while (i.hasNext()) {
            ItemStack whatToSend = i.next();
            for (ForgeDirection s : possibleDirections) {
                InventoryAdaptor ad;
                TileEntity te = w.func_147438_o(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
                if (te == null || (ad = InventoryAdaptor.getAdaptor(te, s.getOpposite())) == null) continue;
                ItemStack Result = ad.addItems(whatToSend);
                if (Result == null) {
                    whatToSend = null;
                } else {
                    whatToSend.field_77994_a -= whatToSend.field_77994_a - Result.field_77994_a;
                }
                if (whatToSend != null) continue;
                break;
            }
            if (whatToSend != null) continue;
            i.remove();
        }
        if (this.waitingToSend.isEmpty()) {
            this.waitingToSend = null;
        }
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.gridProxy.isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.priority);
                craftingTracker.addCraftingOption(this, details);
            }
        }
    }

    public void addDrops(List<ItemStack> drops) {
        if (this.waitingToSend != null) {
            for (ItemStack is : this.waitingToSend) {
                if (is == null) continue;
                drops.add(is);
            }
        }
        for (ItemStack is : this.upgrades) {
            if (is == null) continue;
            drops.add(is);
        }
        for (ItemStack is : this.storage) {
            if (is == null) continue;
            drops.add(is);
        }
        for (ItemStack is : this.patterns) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    public void notifyNeightbors() {
        TileEntity te;
        if (this.gridProxy.isActive()) {
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException e) {
                // empty catch block
            }
        }
        if ((te = this.iHost.getTileEntity()) != null && te.func_145831_w() != null) {
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
    }

    public IUpgradeableHost getHost() {
        if (this.getPart() instanceof IUpgradeableHost) {
            return (IUpgradeableHost)((Object)this.getPart());
        }
        if (this.getTile() instanceof IUpgradeableHost) {
            return (IUpgradeableHost)this.getTile();
        }
        return null;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public IAEItemStack injectCratedItems(ICraftingLink link, IAEItemStack aquired, Actionable mode) {
        int slot = this.craftingTracker.getSlot(link);
        if (aquired != null && slot >= 0 && slot <= this.requireWork.length) {
            InventoryAdaptor adaptor = this.getAdaptor(slot);
            if (mode == Actionable.SIMULATE) {
                return AEItemStack.create(adaptor.simulateAdd(aquired.getItemStack()));
            }
            AEItemStack is = AEItemStack.create(adaptor.addItems(aquired.getItemStack()));
            this.updatePlan(slot);
            return is;
        }
        return aquired;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    public String getTermName() {
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        if (((ICustomNameObject)((Object)this.iHost)).hasCustomName()) {
            return ((ICustomNameObject)((Object)this.iHost)).getCustomName();
        }
        EnumSet<ForgeDirection> possibleDirections = this.iHost.getTargets();
        for (ForgeDirection s : possibleDirections) {
            int[] sides;
            Item item;
            Vec3 from = Vec3.func_72443_a((double)((double)tile.field_145851_c + 0.5), (double)((double)tile.field_145848_d + 0.5), (double)((double)tile.field_145849_e + 0.5));
            from = from.func_72441_c((double)s.offsetX * 0.501, (double)s.offsetY * 0.501, (double)s.offsetZ * 0.501);
            Vec3 to = from.func_72441_c((double)s.offsetX, (double)s.offsetY, (double)s.offsetZ);
            Block blk = w.func_147439_a(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
            MovingObjectPosition mop = w.func_72901_a(from, to, true);
            TileEntity te = w.func_147438_o(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
            if (te == null) continue;
            if (te instanceof IInterfaceHost) {
                try {
                    if (((IInterfaceHost)te).getInterfaceDuality().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            if ((item = Item.func_150898_a((Block)blk)) == null) {
                return blk.func_149739_a();
            }
            ItemStack what = new ItemStack(item, 1, blk.func_149643_k(w, tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ));
            if (!(te instanceof ICraftingMachine) && InventoryAdaptor.getAdaptor(te, s.getOpposite()) == null || te instanceof IInventory && ((IInventory)te).func_70302_i_() == 0 || te instanceof ISidedInventory && ((sides = ((ISidedInventory)te).func_94128_d(s.getOpposite().ordinal())) == null || sides.length == 0)) continue;
            try {
                ItemStack g;
                if (mop != null && !badBlocks.contains(blk) && mop.field_72311_b == te.field_145851_c && mop.field_72312_c == te.field_145848_d && mop.field_72309_d == te.field_145849_e && (g = blk.getPickBlock(mop, w, te.field_145851_c, te.field_145848_d, te.field_145849_e)) != null) {
                    what = g;
                }
            }
            catch (Throwable t) {
                badBlocks.add(blk);
            }
            if (what.func_77973_b() == null) continue;
            return what.func_77977_a();
        }
        return "Nothing";
    }

    public long getSortValue() {
        TileEntity te = this.iHost.getTileEntity();
        return te.field_145849_e << 24 ^ te.field_145851_c << 8 ^ te.field_145848_d;
    }

    public void initalize() {
        this.updateCraftingList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.markDirty();
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    class InterfaceInventory
    extends MEMonitorIInventory {
        public InterfaceInventory(DualityInterface tileInterface) {
            super(new AdaptorIInventory(tileInterface.storage));
            this.mySource = new MachineSource(DualityInterface.this.iHost);
        }

        @Override
        public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
            if (interfaceRequest) {
                return input;
            }
            return super.injectItems(input, type, src);
        }

        @Override
        public IAEItemStack extractItems(IAEItemStack request, Actionable type, BaseActionSource src) {
            if (interfaceRequest) {
                return null;
            }
            return super.extractItems(request, type, src);
        }
    }
}

