/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.core.AEConfig;
import appeng.core.WorldSettings;
import appeng.core.features.AEFeature;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class MeteoritePlacer {
    int minBLocks = 200;
    HashSet<Block> validSpawn = new HashSet();
    HashSet<Block> invalidSpawn = new HashSet();
    Fallout type = new Fallout();
    Block skystone;
    Block skychest;
    double real_sizeOfMetorite;
    double real_crator;
    double sizeOfMetorite;
    double crator;
    NBTTagCompound settings;

    public MeteoritePlacer() {
        this.skystone = AEApi.instance().blocks().blockSkyStone.block();
        this.real_sizeOfMetorite = Math.random() * 6.0 + 2.0;
        this.real_crator = this.real_sizeOfMetorite * 2.0 + 5.0;
        this.sizeOfMetorite = this.real_sizeOfMetorite * this.real_sizeOfMetorite;
        this.crator = this.real_crator * this.real_crator;
        this.skychest = AEApi.instance().blocks().blockSkyChest.block() == null ? Blocks.field_150486_ae : AEApi.instance().blocks().blockSkyChest.block();
        this.validSpawn.add(Blocks.field_150348_b);
        this.validSpawn.add(Blocks.field_150347_e);
        this.validSpawn.add((Block)Blocks.field_150349_c);
        this.validSpawn.add((Block)Blocks.field_150354_m);
        this.validSpawn.add(Blocks.field_150346_d);
        this.validSpawn.add(Blocks.field_150351_n);
        this.validSpawn.add(Blocks.field_150424_aL);
        this.validSpawn.add(Blocks.field_150366_p);
        this.validSpawn.add(Blocks.field_150352_o);
        this.validSpawn.add(Blocks.field_150482_ag);
        this.validSpawn.add(Blocks.field_150450_ax);
        this.validSpawn.add(Blocks.field_150405_ch);
        this.validSpawn.add(Blocks.field_150432_aD);
        this.validSpawn.add(Blocks.field_150433_aE);
        this.invalidSpawn.add(this.skystone);
        this.invalidSpawn.add(Blocks.field_150344_f);
        this.invalidSpawn.add(Blocks.field_150454_av);
        this.invalidSpawn.add(Blocks.field_150411_aY);
        this.invalidSpawn.add(Blocks.field_150466_ao);
        this.invalidSpawn.add(Blocks.field_150336_V);
        this.invalidSpawn.add(Blocks.field_150435_aG);
        this.invalidSpawn.add(Blocks.field_150355_j);
        this.invalidSpawn.add(Blocks.field_150364_r);
        this.invalidSpawn.add(Blocks.field_150363_s);
    }

    public boolean spawnMeteorite(IMetroiteWorld w, NBTTagCompound metoriteBlob) {
        this.settings = metoriteBlob;
        int x = this.settings.func_74762_e("x");
        int y = this.settings.func_74762_e("y");
        int z = this.settings.func_74762_e("z");
        this.real_sizeOfMetorite = this.settings.func_74769_h("real_sizeOfMetorite");
        this.real_crator = this.settings.func_74769_h("real_crator");
        this.sizeOfMetorite = this.settings.func_74769_h("sizeOfMetorite");
        this.crator = this.settings.func_74769_h("crator");
        Block blk = Block.func_149729_e((int)this.settings.func_74762_e("blk"));
        if (blk == Blocks.field_150354_m) {
            this.type = new FalloutSand(w, x, y, z);
        } else if (blk == Blocks.field_150405_ch) {
            this.type = new FalloutCopy(w, x, y, z);
        } else if (blk == Blocks.field_150432_aD || blk == Blocks.field_150433_aE) {
            this.type = new FalloutSnow(w, x, y, z);
        }
        int skyMode = this.settings.func_74762_e("skyMode");
        if (skyMode > 10) {
            this.placeCrator(w, x, y, z);
        }
        this.placeMetor(w, x, y, z);
        if (skyMode > 3) {
            this.Decay(w, x, y, z);
        }
        w.done();
        return true;
    }

    public double getSqDistance(int x, int z) {
        int Cx = this.settings.func_74762_e("x") - x;
        int Cz = this.settings.func_74762_e("z") - z;
        return Cx * Cx + Cz * Cz;
    }

    public boolean spawnMeteorite(IMetroiteWorld w, int x, int y, int z) {
        int k;
        int j;
        int i;
        int validBlocks = 0;
        if (!w.hasNoSky()) {
            return false;
        }
        Block blk = w.getBlock(x, y, z);
        if (!this.validSpawn.contains(blk)) {
            return false;
        }
        this.settings = new NBTTagCompound();
        this.settings.func_74768_a("x", x);
        this.settings.func_74768_a("y", y);
        this.settings.func_74768_a("z", z);
        this.settings.func_74768_a("blk", Block.func_149682_b((Block)blk));
        this.settings.func_74780_a("real_sizeOfMetorite", this.real_sizeOfMetorite);
        this.settings.func_74780_a("real_crator", this.real_crator);
        this.settings.func_74780_a("sizeOfMetorite", this.sizeOfMetorite);
        this.settings.func_74780_a("crator", this.crator);
        this.settings.func_74757_a("lava", Math.random() > 0.9);
        if (blk == Blocks.field_150354_m) {
            this.type = new FalloutSand(w, x, y, z);
        } else if (blk == Blocks.field_150405_ch) {
            this.type = new FalloutCopy(w, x, y, z);
        } else if (blk == Blocks.field_150432_aD || blk == Blocks.field_150433_aE) {
            this.type = new FalloutSnow(w, x, y, z);
        }
        int realValidBlocks = 0;
        for (i = x - 6; i < x + 6; ++i) {
            for (j = y - 6; j < y + 6; ++j) {
                for (k = z - 6; k < z + 6; ++k) {
                    blk = w.getBlock(i, j, k);
                    if (!this.validSpawn.contains(blk)) continue;
                    ++realValidBlocks;
                }
            }
        }
        for (i = x - 15; i < x + 15; ++i) {
            for (j = y - 15; j < y + 15; ++j) {
                for (k = z - 15; k < z + 15; ++k) {
                    blk = w.getBlock(i, j, k);
                    if (this.invalidSpawn.contains(blk)) {
                        return false;
                    }
                    if (!this.validSpawn.contains(blk)) continue;
                    ++validBlocks;
                }
            }
        }
        if (validBlocks > this.minBLocks && realValidBlocks > 80) {
            int j2;
            int skyMode = 0;
            for (int i2 = x - 15; i2 < x + 15; ++i2) {
                for (j2 = y - 15; j2 < y + 11; ++j2) {
                    for (int k2 = z - 15; k2 < z + 15; ++k2) {
                        if (!w.canBlockSeeTheSky(i2, j2, k2)) continue;
                        ++skyMode;
                    }
                }
            }
            boolean solid = true;
            for (j2 = y - 15; j2 < y - 1; ++j2) {
                if (w.getBlock(x, j2, z) != Platform.air) continue;
                solid = false;
            }
            if (!solid) {
                skyMode = 0;
            }
            if (skyMode > 10) {
                this.placeCrator(w, x, y, z);
            }
            this.placeMetor(w, x, y, z);
            if (skyMode > 3) {
                this.Decay(w, x, y, z);
            }
            this.settings.func_74768_a("skyMode", skyMode);
            w.done();
            WorldSettings.getInstance().addNearByMetetorites(w.getWorld().field_73011_w.field_76574_g, x >> 4, z >> 4, this.settings);
            return true;
        }
        return false;
    }

    private void placeCrator(IMetroiteWorld w, int x, int y, int z) {
        boolean lava = this.settings.func_74767_n("lava");
        int maxY = 255;
        int minX = w.minX(x - 200);
        int maxX = w.maxX(x + 200);
        int minZ = w.minZ(z - 200);
        int maxZ = w.maxZ(z + 200);
        for (int j = y - 5; j < maxY; ++j) {
            boolean changed = false;
            for (int i = minX; i < maxX; ++i) {
                for (int k = minZ; k < maxZ; ++k) {
                    double distanceFrom;
                    double dx = i - x;
                    double dz = k - z;
                    double h = (double)y - this.real_sizeOfMetorite + 1.0 + (double)this.type.adjustCrator();
                    if (!((double)j > h + (distanceFrom = dx * dx + dz * dz) * 0.02)) continue;
                    if (lava && j < y && w.getBlock(x, y - 1, z).func_149747_d((IBlockAccess)w.getWorld(), i, j, k, 0)) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.put(w, i, j, k, Blocks.field_150353_l);
                        continue;
                    }
                    changed = this.put(w, i, j, k, Platform.air) || changed;
                }
            }
        }
        for (Object o : w.getWorld().func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)w.minX(x - 30), (double)(y - 5), (double)w.minZ(z - 30), (double)w.maxX(x + 30), (double)(y + 30), (double)w.maxZ(z + 30)))) {
            Entity e = (Entity)o;
            e.func_70106_y();
        }
    }

    private void placeMetor(IMetroiteWorld w, int x, int y, int z) {
        int Xmeteor_l = w.minX(x - 8);
        int Xmeteor_h = w.maxX(x + 8);
        int Zmeteor_l = w.minZ(z - 8);
        int Zmeteor_h = w.maxZ(z + 8);
        for (int i = Xmeteor_l; i < Xmeteor_h; ++i) {
            for (int j = y - 8; j < y + 8; ++j) {
                for (int k = Zmeteor_l; k < Zmeteor_h; ++k) {
                    double dx = i - x;
                    double dy = j - y;
                    double dz = k - z;
                    double d = j > y ? 1.4 : 0.8;
                    if (!(dx * dx * 0.7 + dy * dy * d + dz * dz * 0.7 < this.sizeOfMetorite)) continue;
                    this.put(w, i, j, k, this.skystone);
                }
            }
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.SpawnPressesInMeteorites)) {
            this.put(w, x, y, z, this.skychest);
            TileEntity te = w.getTileEntity(x, y, z);
            if (te != null && te instanceof IInventory) {
                InventoryAdaptor ap = InventoryAdaptor.getAdaptor(te, ForgeDirection.UP);
                int primary = Math.max(1, (int)(Math.random() * 4.0));
                if (primary > 3) {
                    primary = 3;
                }
                for (int zz = 0; zz < primary; ++zz) {
                    int r = 0;
                    boolean duplicate = false;
                    do {
                        duplicate = false;
                        r = Math.random() > 0.7 ? WorldSettings.getInstance().getNextOrderedValue("presses") : (int)(Math.random() * 1000.0);
                        ItemStack toAdd = null;
                        switch (r % 4) {
                            case 0: {
                                toAdd = AEApi.instance().materials().materialCalcProcessorPress.stack(1);
                                break;
                            }
                            case 1: {
                                toAdd = AEApi.instance().materials().materialEngProcessorPress.stack(1);
                                break;
                            }
                            case 2: {
                                toAdd = AEApi.instance().materials().materialLogicProcessorPress.stack(1);
                                break;
                            }
                            case 3: {
                                toAdd = AEApi.instance().materials().materialSiliconPress.stack(1);
                                break;
                            }
                        }
                        if (toAdd == null) continue;
                        if (ap.simulateRemove(1, toAdd, null) == null) {
                            ap.addItems(toAdd);
                            continue;
                        }
                        duplicate = true;
                    } while (duplicate);
                }
                int secondary = Math.max(1, (int)(Math.random() * 3.0));
                block15: for (int zz = 0; zz < secondary; ++zz) {
                    switch ((int)(Math.random() * 1000.0) % 3) {
                        case 0: {
                            ap.addItems(AEApi.instance().blocks().blockSkyStone.stack((int)(Math.random() * 12.0) + 1));
                            continue block15;
                        }
                        case 1: {
                            LinkedList<ItemStack> possibles = new LinkedList<ItemStack>();
                            possibles.addAll(OreDictionary.getOres((String)"nuggetIron"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetCopper"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetTin"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetSilver"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetLead"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetPlatinum"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetNickel"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetAluminium"));
                            possibles.addAll(OreDictionary.getOres((String)"nuggetElectrum"));
                            possibles.add(new ItemStack(Items.field_151074_bl));
                            ItemStack nugget = (ItemStack)Platform.pickRandom(possibles);
                            if (nugget == null) continue block15;
                            nugget = nugget.func_77946_l();
                            nugget.field_77994_a = (int)(Math.random() * 12.0) + 1;
                            ap.addItems(nugget);
                        }
                    }
                }
            }
        }
    }

    private void Decay(IMetroiteWorld w, int x, int y, int z) {
        double randomShit = 0.0;
        int Xmeteor_l = w.minX(x - 30);
        int Xmeteor_h = w.maxX(x + 30);
        int Zmeteor_l = w.minZ(z - 30);
        int Zmeteor_h = w.maxZ(z + 30);
        for (int i = Xmeteor_l; i < Xmeteor_h; ++i) {
            for (int k = Zmeteor_l; k < Zmeteor_h; ++k) {
                for (int j = y - 9; j < y + 30; ++j) {
                    double dx;
                    double dz;
                    double dy;
                    Block blk_b;
                    Block blk = w.getBlock(i, j, k);
                    if (blk == Blocks.field_150353_l) continue;
                    if (blk.isReplaceable((IBlockAccess)w.getWorld(), i, j, k)) {
                        blk = Platform.air;
                        blk_b = w.getBlock(i, j + 1, k);
                        if (blk_b != blk) {
                            int meta_b = w.getBlockMetadata(i, j + 1, k);
                            w.setBlock(i, j, k, blk_b, meta_b, 3);
                            w.setBlock(i, j + 1, k, blk);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.crator)) continue;
                        double dx2 = i - x;
                        dy = j - y;
                        dz = k - z;
                        double dist = dx2 * dx2 + dy * dy + dz * dz;
                        Block xf = w.getBlock(i, j - 1, k);
                        if (xf.isReplaceable((IBlockAccess)w.getWorld(), i, j - 1, k)) continue;
                        double extrRange = Math.random() * 0.6;
                        double height = this.crator * (extrRange + 0.2) - Math.abs(dist - this.crator * 1.7);
                        if (xf == blk || !(height > 0.0) || !(Math.random() > 0.6)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(w, i, j, k);
                        continue;
                    }
                    blk_b = w.getBlock(i, j + 1, k);
                    if (blk_b != Platform.air || !(Math.random() > 0.4) || !((dx = (double)(i - x)) * dx + (dy = (double)(j - y)) * dy + (dz = (double)(k - z)) * dz < this.crator * 1.6)) continue;
                    this.type.getRandomInset(w, i, j, k);
                }
            }
        }
    }

    private boolean put(IMetroiteWorld w, int i, int j, int k, Block blk) {
        Block original = w.getBlock(i, j, k);
        if (original == Blocks.field_150357_h || original == blk) {
            return false;
        }
        w.setBlock(i, j, k, blk);
        return true;
    }

    private void put(IMetroiteWorld w, int i, int j, int k, Block blk, int meta) {
        if (w.getBlock(i, j, k) == Blocks.field_150357_h) {
            return;
        }
        w.setBlock(i, j, k, blk, meta, 3);
    }

    public NBTTagCompound getSettings() {
        return this.settings;
    }

    public static class ChunkOnly
    extends StandardWorld {
        Chunk target;
        int verticalBits = 0;
        final int cx;
        final int cz;

        public ChunkOnly(World w, int cx, int cz) {
            super(w);
            this.target = w.func_72964_e(cx, cz);
            this.cx = cx;
            this.cz = cz;
        }

        @Override
        public void done() {
            if (this.verticalBits != 0) {
                Platform.sendChunk(this.target, this.verticalBits);
            }
        }

        @Override
        public void setBlock(int x, int y, int z, Block blk) {
            if (this.range(x, y, z)) {
                this.verticalBits |= 1 << (y >> 4);
                this.w.func_147465_d(x, y, z, blk, 0, 1);
            }
        }

        @Override
        public void setBlock(int x, int y, int z, Block blk, int metadata, int flags) {
            if (this.range(x, y, z)) {
                this.verticalBits |= 1 << (y >> 4);
                this.w.func_147465_d(x, y, z, blk, metadata, flags & 0xFFFFFFFD);
            }
        }

        @Override
        public Block getBlock(int x, int y, int z) {
            if (this.range(x, y, z)) {
                return this.target.func_150810_a(x & 0xF, y, z & 0xF);
            }
            return Platform.air;
        }

        @Override
        public int getBlockMetadata(int x, int y, int z) {
            if (this.range(x, y, z)) {
                return this.target.func_76628_c(x & 0xF, y, z & 0xF);
            }
            return 0;
        }

        @Override
        public boolean range(int x, int y, int z) {
            return this.cx == x >> 4 && this.cz == z >> 4;
        }

        @Override
        public int minX(int in) {
            return Math.max(in, this.cx << 4);
        }

        @Override
        public int minZ(int in) {
            return Math.max(in, this.cz << 4);
        }

        @Override
        public int maxX(int in) {
            return Math.min(in, this.cx + 1 << 4);
        }

        @Override
        public int maxZ(int in) {
            return Math.min(in, this.cz + 1 << 4);
        }
    }

    public static class StandardWorld
    implements IMetroiteWorld {
        protected World w;

        public StandardWorld(World w) {
            this.w = w;
        }

        @Override
        public boolean hasNoSky() {
            return !this.w.field_73011_w.field_76576_e;
        }

        @Override
        public int getBlockMetadata(int x, int y, int z) {
            if (this.range(x, y, z)) {
                return this.w.func_72805_g(x, y, z);
            }
            return 0;
        }

        @Override
        public Block getBlock(int x, int y, int z) {
            if (this.range(x, y, z)) {
                return this.w.func_147439_a(x, y, z);
            }
            return Platform.air;
        }

        @Override
        public boolean canBlockSeeTheSky(int x, int y, int z) {
            if (this.range(x, y, z)) {
                return this.w.func_72937_j(x, y, z);
            }
            return false;
        }

        @Override
        public TileEntity getTileEntity(int x, int y, int z) {
            if (this.range(x, y, z)) {
                return this.w.func_147438_o(x, y, z);
            }
            return null;
        }

        @Override
        public World getWorld() {
            return this.w;
        }

        @Override
        public void setBlock(int x, int y, int z, Block blk) {
            if (this.range(x, y, z)) {
                this.w.func_147449_b(x, y, z, blk);
            }
        }

        @Override
        public void setBlock(int x, int y, int z, Block blk, int metadata, int flags) {
            if (this.range(x, y, z)) {
                this.w.func_147465_d(x, y, z, blk, metadata, flags);
            }
        }

        public boolean range(int x, int y, int z) {
            return true;
        }

        @Override
        public int minX(int in) {
            return in;
        }

        @Override
        public int minZ(int in) {
            return in;
        }

        @Override
        public int maxX(int in) {
            return in;
        }

        @Override
        public int maxZ(int in) {
            return in;
        }

        @Override
        public void done() {
        }
    }

    public static interface IMetroiteWorld {
        public int minX(int var1);

        public int minZ(int var1);

        public int maxX(int var1);

        public int maxZ(int var1);

        public boolean hasNoSky();

        public int getBlockMetadata(int var1, int var2, int var3);

        public Block getBlock(int var1, int var2, int var3);

        public boolean canBlockSeeTheSky(int var1, int var2, int var3);

        public TileEntity getTileEntity(int var1, int var2, int var3);

        public World getWorld();

        public void setBlock(int var1, int var2, int var3, Block var4);

        public void setBlock(int var1, int var2, int var3, Block var4, int var5, int var6);

        public void done();
    }

    private class FalloutSnow
    extends FalloutCopy {
        public FalloutSnow(IMetroiteWorld w, int x, int y, int z) {
            super(w, x, y, z);
        }

        @Override
        public int adjustCrator() {
            return 2;
        }

        @Override
        public void getOther(IMetroiteWorld w, int x, int y, int z, double a) {
            if (a > 0.7) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150433_aE);
            } else if (a > 0.5) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150432_aD);
            }
        }
    }

    private class FalloutSand
    extends FalloutCopy {
        public FalloutSand(IMetroiteWorld w, int x, int y, int z) {
            super(w, x, y, z);
        }

        @Override
        public int adjustCrator() {
            return 2;
        }

        @Override
        public void getOther(IMetroiteWorld w, int x, int y, int z, double a) {
            if (a > 0.66) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150359_w);
            }
        }
    }

    private class FalloutCopy
    extends Fallout {
        Block blk;
        int meta;

        public FalloutCopy(IMetroiteWorld w, int x, int y, int z) {
            this.blk = w.getBlock(x, y, z);
            this.meta = w.getBlockMetadata(x, y, z);
        }

        public void getOther(IMetroiteWorld w, int x, int y, int z, double a) {
        }

        @Override
        public void getRandomFall(IMetroiteWorld w, int x, int y, int z) {
            double a = Math.random();
            if (a > 0.9) {
                MeteoritePlacer.this.put(w, x, y, z, this.blk, this.meta);
            } else {
                this.getOther(w, x, y, z, a);
            }
        }

        @Override
        public void getRandomInset(IMetroiteWorld w, int x, int y, int z) {
            double a = Math.random();
            if (a > 0.9) {
                MeteoritePlacer.this.put(w, x, y, z, this.blk, this.meta);
            } else if (a > 0.8) {
                MeteoritePlacer.this.put(w, x, y, z, Platform.air);
            } else {
                this.getOther(w, x, y, z, a - 0.1);
            }
        }
    }

    private class Fallout {
        private Fallout() {
        }

        public int adjustCrator() {
            return 0;
        }

        public void getRandomFall(IMetroiteWorld w, int x, int y, int z) {
            double a = Math.random();
            if (a > 0.9) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150348_b);
            } else if (a > 0.8) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150347_e);
            } else if (a > 0.7) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150346_d);
            } else if (a > 0.7) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150351_n);
            }
        }

        public void getRandomInset(IMetroiteWorld w, int x, int y, int z) {
            double a = Math.random();
            if (a > 0.9) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150347_e);
            } else if (a > 0.8) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150348_b);
            } else if (a > 0.7) {
                MeteoritePlacer.this.put(w, x, y, z, (Block)Blocks.field_150349_c);
            } else if (a > 0.6) {
                MeteoritePlacer.this.put(w, x, y, z, MeteoritePlacer.this.skystone);
            } else if (a > 0.5) {
                MeteoritePlacer.this.put(w, x, y, z, Blocks.field_150351_n);
            } else if (a > 0.5) {
                MeteoritePlacer.this.put(w, x, y, z, Platform.air);
            }
        }
    }
}

