/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompassRequest;
import appeng.hooks.CompassResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class CompassManager {
    public static CompassManager instance = new CompassManager();
    HashMap<CompassReq, CompassResult> reqs = new HashMap();

    public void postResult(long attunement, int x, int y, int z, CompassResult res) {
        CompassReq r = new CompassReq(attunement, x, y, z);
        this.reqs.put(r, res);
    }

    public CompassResult getCompassDirection(long attunement, int x, int y, int z) {
        long now = System.currentTimeMillis();
        Iterator<CompassResult> i = this.reqs.values().iterator();
        while (i.hasNext()) {
            CompassResult res = i.next();
            long diff = now - res.time;
            if (diff <= 20000L) continue;
            i.remove();
        }
        CompassReq r = new CompassReq(attunement, x, y, z);
        CompassResult res = this.reqs.get(r);
        if (res == null) {
            res = new CompassResult(false, true, 0.0);
            this.reqs.put(r, res);
            this.requestUpdate(r);
        } else if (now - res.time > 3000L && !res.requested) {
            res.requested = true;
            this.requestUpdate(r);
        }
        return res;
    }

    private void requestUpdate(CompassReq r) {
        try {
            NetworkHandler.instance.sendToServer(new PacketCompassRequest(r.attunement, r.cx, r.cz, r.cdy));
        }
        catch (IOException e) {
            AELog.error(e);
        }
    }

    class CompassReq {
        final int hash;
        final long attunement;
        final int cx;
        final int cdy;
        final int cz;

        public CompassReq(long attunement, int x, int y, int z) {
            this.attunement = attunement;
            this.cx = x >> 4;
            this.cdy = y >> 5;
            this.cz = z >> 4;
            this.hash = Integer.valueOf(this.cx).hashCode() ^ Integer.valueOf(this.cdy).hashCode() ^ Integer.valueOf(this.cz).hashCode() ^ Long.valueOf(attunement).hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            CompassReq b = (CompassReq)obj;
            return this.attunement == b.attunement && this.cx == b.cx && this.cdy == b.cdy && this.cz == b.cz;
        }
    }
}

