/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.api.exceptions.ModNotInstalled;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationStage;
import appeng.integration.IntegrationType;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Field;

public class IntegrationNode {
    IntegrationStage state = IntegrationStage.PREINIT;
    IntegrationStage failedStage = IntegrationStage.PREINIT;
    Throwable exception = null;
    String displayName;
    String modID;
    IntegrationType shortName;
    String name = null;
    Class classValue = null;
    Object instance;
    IIntegrationModule mod = null;

    public IntegrationNode(String dspname, String _modID, IntegrationType sName, String n) {
        this.displayName = dspname;
        this.shortName = sName;
        this.modID = _modID;
        this.name = n;
    }

    public String toString() {
        return this.shortName.name() + ":" + this.state.name();
    }

    void Call(IntegrationStage stage) {
        if (this.state != IntegrationStage.FAILED) {
            if (this.state.ordinal() > stage.ordinal()) {
                return;
            }
            try {
                switch (stage) {
                    case PREINIT: {
                        boolean enabled = this.modID == null || Loader.isModLoaded((String)this.modID);
                        AEConfig.instance.addCustomCategoryComment("ModIntegration", "Valid Values are 'AUTO', 'ON', or 'OFF' - defaults to 'AUTO' ; Suggested that you leave this alone unless your experiencing an issue, or wish to disable the integration for a reason.");
                        String Mode = AEConfig.instance.get("ModIntegration", this.displayName.replace(" ", ""), "AUTO").getString();
                        if (Mode.toUpperCase().equals("ON")) {
                            enabled = true;
                        }
                        if (Mode.toUpperCase().equals("OFF")) {
                            enabled = false;
                        }
                        if (!enabled) {
                            throw new ModNotInstalled(this.modID);
                        }
                        this.classValue = this.getClass().getClassLoader().loadClass(this.name);
                        this.mod = (IIntegrationModule)this.classValue.getConstructor(new Class[0]).newInstance(new Object[0]);
                        Field f = this.classValue.getField("instance");
                        this.instance = this.mod;
                        f.set(this.classValue, this.instance);
                        this.state = IntegrationStage.INIT;
                        break;
                    }
                    case INIT: {
                        this.mod.Init();
                        this.state = IntegrationStage.POSTINIT;
                        break;
                    }
                    case POSTINIT: {
                        this.mod.PostInit();
                        this.state = IntegrationStage.READY;
                        break;
                    }
                }
            }
            catch (Throwable t) {
                this.failedStage = stage;
                this.exception = t;
                this.state = IntegrationStage.FAILED;
            }
        }
        if (stage == IntegrationStage.POSTINIT) {
            if (this.state == IntegrationStage.FAILED) {
                AELog.info(this.displayName + " - Integration Disabled", new Object[0]);
                if (!(this.exception instanceof ModNotInstalled)) {
                    AELog.integration(this.exception);
                }
            } else {
                AELog.info(this.displayName + " - Integration Enable", new Object[0]);
            }
        }
    }

    public boolean isActive() {
        if (this.state == IntegrationStage.PREINIT) {
            this.Call(IntegrationStage.PREINIT);
        }
        return this.state != IntegrationStage.FAILED;
    }
}

