/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.integration.IntegrationNode;
import appeng.integration.IntegrationSide;
import appeng.integration.IntegrationStage;
import appeng.integration.IntegrationType;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.LinkedList;

public class IntegrationRegistry {
    public static IntegrationRegistry instance = null;
    private LinkedList<IntegrationNode> modules = new LinkedList();

    public void add(IntegrationType type) {
        if (type.side == IntegrationSide.CLIENT && FMLLaunchHandler.side() == Side.SERVER) {
            return;
        }
        if (type.side == IntegrationSide.SERVER && FMLLaunchHandler.side() == Side.CLIENT) {
            return;
        }
        this.modules.add(new IntegrationNode(type.dspName, type.modID, type, "appeng.integration.modules." + type.name()));
    }

    public IntegrationRegistry() {
        instance = this;
    }

    public void init() {
        for (IntegrationNode node : this.modules) {
            node.Call(IntegrationStage.PREINIT);
        }
        for (IntegrationNode node : this.modules) {
            node.Call(IntegrationStage.INIT);
        }
    }

    public void postinit() {
        for (IntegrationNode node : this.modules) {
            node.Call(IntegrationStage.POSTINIT);
        }
    }

    public String getStatus() {
        String out = null;
        for (IntegrationNode node : this.modules) {
            String str = (Object)((Object)node.shortName) + ":" + (node.state == IntegrationStage.FAILED ? "OFF" : "ON");
            if (out == null) {
                out = str;
                continue;
            }
            out = out + ", " + str;
        }
        return out;
    }

    public boolean isEnabled(IntegrationType name) {
        for (IntegrationNode node : this.modules) {
            if (node.shortName != name) continue;
            return node.isActive();
        }
        return false;
    }

    public Object getInstance(IntegrationType name) {
        for (IntegrationNode node : this.modules) {
            if (!node.shortName.equals((Object)name) || !node.isActive()) continue;
            return node.instance;
        }
        throw new RuntimeException("integration with " + name.name() + " is disabled.");
    }
}

