/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.config.TunnelType;
import appeng.api.definitions.Blocks;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.parts.IFacadePart;
import appeng.api.util.AEItemDefinition;
import appeng.api.util.IOrientableBlock;
import appeng.facade.FacadePart;
import appeng.integration.BaseModule;
import appeng.integration.abstraction.IBC;
import appeng.integration.modules.BCHelpers.AECableSchematicTile;
import appeng.integration.modules.BCHelpers.AEGenericSchematicTile;
import appeng.integration.modules.BCHelpers.AERotateableBlockSchematic;
import appeng.integration.modules.BCHelpers.BCPipeHandler;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftTransport;
import buildcraft.api.blueprints.SchematicRegistry;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class BC
extends BaseModule
implements IBC {
    public static BC instance;

    public BC() {
        this.TestClass(IPipeConnection.class);
        this.TestClass(ItemFacade.class);
        this.TestClass(IToolWrench.class);
    }

    @Override
    public void addFacade(ItemStack item) {
        if (item != null) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (ItemStack)item);
        }
    }

    @Override
    public boolean isWrench(Item eq) {
        return eq instanceof IToolWrench;
    }

    @Override
    public boolean isPipe(TileEntity te, ForgeDirection dir) {
        if (te instanceof IPipeTile) {
            try {
                if (te instanceof TileGenericPipe && ((TileGenericPipe)te).hasPlug(dir.getOpposite())) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrench(Item i, EntityPlayer p, int x, int y, int z) {
        return ((IToolWrench)i).canWrench(p, x, y, z);
    }

    @Override
    public void wrenchUsed(Item i, EntityPlayer p, int x, int y, int z) {
        ((IToolWrench)i).wrenchUsed(p, x, y, z);
    }

    @Override
    public boolean addItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        int amt;
        IPipeTile pt;
        if (is != null && te != null && te instanceof IPipeTile && (pt = (IPipeTile)te).getPipeType() == IPipeTile.PipeType.ITEM && (amt = pt.injectItem(is, false, dir)) == is.field_77994_a) {
            pt.injectItem(is, true, dir);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFacade(ItemStack is) {
        if (is == null) {
            return false;
        }
        try {
            return is.func_77973_b() instanceof ItemFacade && ItemFacade.getType((ItemStack)is) == ItemFacade.FacadeType.Basic;
        }
        catch (Throwable t) {
            try {
                return is.func_77973_b() instanceof ItemFacade && ItemFacade.getType((ItemStack)is) == ItemFacade.TYPE_BASIC;
            }
            catch (Throwable g) {
                return is.func_77973_b() instanceof ItemFacade;
            }
        }
    }

    @Override
    public boolean canAddItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        int amt;
        IPipeTile pt;
        return is != null && te != null && te instanceof IPipeTile && (pt = (IPipeTile)te).getPipeType() == IPipeTile.PipeType.ITEM && (amt = pt.injectItem(is, false, dir)) == is.field_77994_a;
    }

    @Override
    public void registerPowerP2P() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 0), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 1), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 2), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerCobblestone), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerDiamond), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerGold), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerQuartz), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerStone), TunnelType.BC_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerWood), TunnelType.BC_POWER);
    }

    @Override
    public void registerItemP2P() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsWood), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsVoid), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsSandstone), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsQuartz), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsObsidian), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsIron), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsGold), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsEmerald), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsDiamond), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsStone), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsCobblestone), TunnelType.ITEM);
    }

    @Override
    public void registerLiquidsP2P() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsCobblestone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsEmerald), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsGold), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsIron), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsSandstone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsStone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsVoid), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsWood), TunnelType.FLUID);
    }

    @Override
    public void Init() {
        AEApi.instance().partHelper().registerNewLayer("appeng.parts.layers.LayerIPipeConnection", "buildcraft.api.transport.IPipeConnection");
        AEApi.instance().registries().externalStorage().addExternalStorageInterface(new BCPipeHandler());
        Blocks b = AEApi.instance().blocks();
        this.addFacade(b.blockFluix.stack(1));
        this.addFacade(b.blockQuartz.stack(1));
        this.addFacade(b.blockQuartzChiseled.stack(1));
        this.addFacade(b.blockQuartzPiller.stack(1));
        try {
            this.initBuilderSupport();
        }
        catch (Throwable builderSupport) {
            // empty catch block
        }
        Block skyStone = b.blockSkyStone.block();
        if (skyStone != null) {
            this.addFacade(new ItemStack(skyStone, 1, 0));
            this.addFacade(new ItemStack(skyStone, 1, 1));
            this.addFacade(new ItemStack(skyStone, 1, 2));
            this.addFacade(new ItemStack(skyStone, 1, 3));
        }
    }

    private void initBuilderSupport() {
        SchematicRegistry.declareBlueprintSupport((String)"appliedenergistics2");
        Blocks blks = AEApi.instance().blocks();
        Block cable = blks.blockMultiPart.block();
        for (Field f : blks.getClass().getFields()) {
            try {
                AEItemDefinition def = (AEItemDefinition)f.get(blks);
                if (def == null) continue;
                Block myBlock = def.block();
                if (myBlock instanceof IOrientableBlock && ((IOrientableBlock)myBlock).usesMetadata() && def.entity() == null) {
                    SchematicRegistry.registerSchematicBlock((Block)myBlock, AERotateableBlockSchematic.class, (Object[])new Object[0]);
                    continue;
                }
                if (myBlock == cable) {
                    SchematicRegistry.registerSchematicBlock((Block)myBlock, AECableSchematicTile.class, (Object[])new Object[0]);
                    continue;
                }
                if (def.entity() == null) continue;
                SchematicRegistry.registerSchematicBlock((Block)myBlock, AEGenericSchematicTile.class, (Object[])new Object[0]);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    @Override
    public void PostInit() {
        this.registerPowerP2P();
        this.registerItemP2P();
        this.registerLiquidsP2P();
    }

    @Override
    public IFacadePart createFacadePart(Block blk, int meta, ForgeDirection side) {
        try {
            ItemStack fs = ItemFacade.getFacade((Block)blk, (int)meta);
            return new FacadePart(fs, side);
        }
        catch (Throwable t) {
            try {
                ItemStack fs = ItemFacade.getStack((Block)blk, (int)meta);
                return new FacadePart(fs, side);
            }
            catch (Throwable t2) {
                return null;
            }
        }
    }

    @Override
    public IFacadePart createFacadePart(ItemStack fs, ForgeDirection side) {
        return new FacadePart(fs, side);
    }

    @Override
    public ItemStack getTextureForFacade(ItemStack facade) {
        Block blk;
        try {
            blk = ItemFacade.getBlocks((ItemStack)facade);
            int[] meta = ItemFacade.getMetaValues((ItemStack)facade);
            if (blk == null || ((Block)blk).length < 1) {
                return null;
            }
            if (blk[0] != null) {
                return new ItemStack(blk[0], 1, meta[0]);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            blk = ItemFacade.getBlock((ItemStack)facade);
            if (blk != null) {
                return new ItemStack(blk, 1, ItemFacade.getMetaData((ItemStack)facade));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IIcon getFacadeTexture() {
        try {
            return BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

