/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.api.AEApi;
import appeng.api.util.AEItemDefinition;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIWorldCraftingHandler
implements ICraftingHandler,
IUsageHandler {
    HashMap<AEItemDefinition, String> details = new HashMap();
    List<AEItemDefinition> offsets = new LinkedList<AEItemDefinition>();
    List<PositionedStack> outputs = new LinkedList<PositionedStack>();
    ItemStack target;

    private void addRecipe(AEItemDefinition def, String msg) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)def.stack(1), (ItemStack)this.target)) {
            this.offsets.add(def);
            this.outputs.add(new PositionedStack((Object)def.stack(1), 75, 4));
            this.details.put(def, msg);
        }
    }

    private void addRecipes() {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.CertusQuartzWorldGen)) {
            this.addRecipe(AEApi.instance().materials().materialCertusQuartzCrystalCharged, GuiText.ChargedQuartz.getLocal() + "\n\n" + GuiText.ChargedQuartzFind.getLocal());
        } else {
            this.addRecipe(AEApi.instance().materials().materialCertusQuartzCrystalCharged, GuiText.ChargedQuartzFind.getLocal());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.MeteoriteWorldGen)) {
            this.addRecipe(AEApi.instance().materials().materialLogicProcessorPress, GuiText.inWorldCraftingPresses.getLocal());
            this.addRecipe(AEApi.instance().materials().materialCalcProcessorPress, GuiText.inWorldCraftingPresses.getLocal());
            this.addRecipe(AEApi.instance().materials().materialEngProcessorPress, GuiText.inWorldCraftingPresses.getLocal());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.inWorldFluix)) {
            this.addRecipe(AEApi.instance().materials().materialFluixCrystal, GuiText.inWorldFluix.getLocal());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.inWorldSingularity)) {
            this.addRecipe(AEApi.instance().materials().materialQESingularity, GuiText.inWorldSingularity.getLocal());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.inWorldPurification)) {
            this.addRecipe(AEApi.instance().materials().materialPureifiedCertusQuartzCrystal, GuiText.inWorldPurificationCertus.getLocal());
            this.addRecipe(AEApi.instance().materials().materialPureifiedNetherQuartzCrystal, GuiText.inWorldPurificationNether.getLocal());
            this.addRecipe(AEApi.instance().materials().materialPureifiedFluixCrystal, GuiText.inWorldPurificationFluix.getLocal());
        }
    }

    public String getRecipeName() {
        return GuiText.InWorldCrafting.getLocal();
    }

    public int numRecipes() {
        return this.offsets.size();
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawForeground(int recipe) {
        if (this.outputs.size() > recipe) {
            String details = this.details.get(this.offsets.get(recipe));
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            fr.func_78279_b(details, 10, 25, 150, 0);
        }
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public List<PositionedStack> getOtherStacks(int recipetype) {
        return new ArrayList<PositionedStack>();
    }

    public PositionedStack getResultStack(int recipe) {
        return this.outputs.get(recipe);
    }

    public void onUpdate() {
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        return false;
    }

    public NEIWorldCraftingHandler newInstance() {
        try {
            return (NEIWorldCraftingHandler)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        return this;
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        NEIWorldCraftingHandler g = this.newInstance();
        if (results.length > 0 && results[0] instanceof ItemStack) {
            g.target = (ItemStack)results[0];
            g.addRecipes();
            return g;
        }
        return this;
    }
}

