/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.block.AEBaseBlock;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.localization.WailaText;
import appeng.integration.BaseModule;
import appeng.integration.IntegrationType;
import appeng.parts.networking.PartCableSmart;
import appeng.parts.networking.PartDenseCable;
import appeng.tile.misc.TileCharger;
import appeng.tile.networking.TileCableBus;
import appeng.tile.networking.TileEnergyCell;
import appeng.util.Platform;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaFMPAccessor;
import mcp.mobius.waila.api.IWailaFMPProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class Waila
extends BaseModule
implements IWailaDataProvider,
IWailaFMPProvider {
    public static Waila instance;

    public static void register(IWailaRegistrar registrar) {
        Waila w = (Waila)AppEng.instance.getIntegration(IntegrationType.Waila);
        registrar.registerBodyProvider((IWailaDataProvider)w, AEBaseBlock.class);
        registrar.registerBodyProvider((IWailaFMPProvider)w, "ae2_cablebus");
        registrar.registerSyncedNBTKey("internalCurrentPower", TileEnergyCell.class);
        registrar.registerSyncedNBTKey("extra:6.usedChannels", TileCableBus.class);
    }

    @Override
    public void Init() throws Throwable {
        this.TestClass(IWailaDataProvider.class);
        this.TestClass(IWailaRegistrar.class);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)(this.getClass().getName() + ".register"));
    }

    @Override
    public void PostInit() throws Throwable {
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        MovingObjectPosition mop = accessor.getPosition();
        NBTTagCompound nbt = null;
        try {
            nbt = accessor.getNBTData();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return this.getBody(itemStack, currenttip, accessor.getPlayer(), nbt, te, mop);
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaFMPAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        MovingObjectPosition mop = accessor.getPosition();
        NBTTagCompound nbt = null;
        try {
            nbt = accessor.getNBTData();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return this.getBody(itemStack, currenttip, accessor.getPlayer(), nbt, te, mop);
    }

    public List<String> getBody(ItemStack itemStack, List<String> currenttip, EntityPlayer player, NBTTagCompound nbt, TileEntity te, MovingObjectPosition mop) {
        TileCharger tc;
        IInventory inv;
        ItemStack is;
        Object ThingOfInterest = te;
        if (te instanceof IPartHost) {
            Vec3 Pos2 = mop.field_72307_f.func_72441_c((double)(-mop.field_72311_b), (double)(-mop.field_72312_c), (double)(-mop.field_72309_d));
            SelectedPart sp = ((IPartHost)te).selectPart(Pos2);
            if (sp.facade != null) {
                IFacadePart fp = sp.facade;
                ThingOfInterest = fp;
            } else if (sp.part != null) {
                IPart part = sp.part;
                ThingOfInterest = part;
            }
        }
        try {
            NBTTagCompound ic;
            NBTTagCompound c;
            if ((ThingOfInterest instanceof PartCableSmart || ThingOfInterest instanceof PartDenseCable) && (c = nbt) != null && c.func_74764_b("extra:6") && (ic = c.func_74775_l("extra:6")) != null && ic.func_74764_b("usedChannels")) {
                byte channels = ic.func_74771_c("usedChannels");
                currenttip.add(channels + " " + GuiText.Of.getLocal() + " " + (ThingOfInterest instanceof PartDenseCable ? 32 : 8) + " " + WailaText.Channels.getLocal());
            }
            if (ThingOfInterest instanceof TileEnergyCell && (c = nbt) != null && c.func_74764_b("internalCurrentPower")) {
                TileEnergyCell tec = (TileEnergyCell)ThingOfInterest;
                long power = (long)(100.0 * c.func_74769_h("internalCurrentPower"));
                currenttip.add((Object)((Object)WailaText.Contains) + ": " + Platform.formatPowerLong(power, false) + " / " + Platform.formatPowerLong((long)(100.0 * tec.getAEMaxPower()), false));
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (ThingOfInterest instanceof IPartStorageMonitor) {
            IAEStack<IAEItemStack> ais;
            IPartStorageMonitor psm = (IPartStorageMonitor)ThingOfInterest;
            IAEStack stack = psm.getDisplayed();
            boolean isLocked = psm.isLocked();
            if (stack instanceof IAEItemStack) {
                ais = (IAEItemStack)stack;
                currenttip.add(WailaText.Showing.getLocal() + ": " + ais.getItemStack().func_82833_r());
            }
            if (stack instanceof IAEFluidStack) {
                ais = (IAEFluidStack)stack;
                currenttip.add(WailaText.Showing.getLocal() + ": " + ais.getFluid().getLocalizedName(ais.getFluidStack()));
            }
            if (isLocked) {
                currenttip.add(WailaText.Locked.getLocal());
            } else {
                currenttip.add(WailaText.Unlocked.getLocal());
            }
        }
        if (ThingOfInterest instanceof TileCharger && (is = (inv = (tc = (TileCharger)ThingOfInterest).getInternalInventory()).func_70301_a(0)) != null) {
            currenttip.add((Object)((Object)WailaText.Contains) + ": " + is.func_82833_r());
            is.func_77973_b().func_77624_a(is, player, currenttip, true);
        }
        if (ThingOfInterest instanceof IPowerChannelState) {
            IPowerChannelState pbs = (IPowerChannelState)ThingOfInterest;
            if (pbs.isActive() && pbs.isPowered()) {
                currenttip.add(WailaText.DeviceOnline.getLocal());
            } else if (pbs.isPowered()) {
                currenttip.add(WailaText.DeviceMissingChannel.getLocal());
            } else {
                currenttip.add(WailaText.DeviceOffline.getLocal());
            }
        }
        return currenttip;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaFMPAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaFMPAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

