/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.features.AEFeatureHandler;
import appeng.core.features.ItemStackSrc;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.parts.PartType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMultiPart
extends AEBaseItem
implements IPartItem,
IItemGroup {
    HashMap<Integer, PartTypeIst> dmgToPart = new HashMap();
    public static ItemMultiPart instance;

    public ItemMultiPart() {
        super(ItemMultiPart.class);
        this.setfeature(EnumSet.of(AEFeature.Core));
        AEApi.instance().partHelper().setItemBusRenderer(this);
        this.func_77627_a(true);
        instance = this;
    }

    public ItemStackSrc createPart(PartType mat, Enum varient) {
        try {
            ItemStack is = new ItemStack((Item)this);
            mat.getPart().getConstructor(ItemStack.class).newInstance(is);
        }
        catch (Throwable e) {
            AELog.integration(e);
            return null;
        }
        int varID = varient == null ? 0 : varient.ordinal();
        for (PartTypeIst p : this.dmgToPart.values()) {
            if (p.part != mat || p.varient != varID) continue;
            throw new RuntimeException("Cannot create the same material twice...");
        }
        boolean enabled = true;
        for (AEFeature f : mat.getFeature()) {
            enabled = enabled && AEConfig.instance.isFeatureEnabled(f);
        }
        if (enabled) {
            int newPartNum = mat.baseDamage + varID;
            ItemStackSrc output = new ItemStackSrc(this, newPartNum);
            PartTypeIst pti = new PartTypeIst();
            pti.part = mat;
            pti.varient = varID;
            if (this.dmgToPart.get(newPartNum) == null) {
                this.dmgToPart.put(newPartNum, pti);
                return output;
            }
            throw new RuntimeException("Meta Overlap detected.");
        }
        return null;
    }

    public int getDamageByType(PartType t) {
        for (Map.Entry<Integer, PartTypeIst> pt : this.dmgToPart.entrySet()) {
            if (pt.getValue().part != t) continue;
            return pt.getKey();
        }
        return -1;
    }

    public PartType getTypeByStack(ItemStack is) {
        if (is == null) {
            return null;
        }
        PartTypeIst pt = this.dmgToPart.get(is.func_77960_j());
        if (pt != null) {
            return pt.part;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public IIcon func_77617_a(int dmg) {
        IIcon ico = this.dmgToPart.get((Object)Integer.valueOf((int)dmg)).ico;
        return ico;
    }

    public String func_77667_c(ItemStack is) {
        return "item.appliedenergistics2." + this.getname(is);
    }

    public String getname(ItemStack is) {
        return AEFeatureHandler.getName(ItemMultiPart.class, this.getTypeByStack(is).name());
    }

    public String func_77653_i(ItemStack is) {
        PartType pt = this.getTypeByStack(is);
        if (pt == null) {
            return "Unnamed";
        }
        Enum[] varients = pt.getVarients();
        if (varients != null) {
            return super.func_77653_i(is) + " - " + varients[this.dmgToPart.get((Object)Integer.valueOf((int)is.func_77960_j())).varient].toString();
        }
        if (pt.getExtraName() != null) {
            return super.func_77653_i(is) + " - " + pt.getExtraName().getLocal();
        }
        return super.func_77653_i(is);
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        for (Map.Entry<Integer, PartTypeIst> part : this.dmgToPart.entrySet()) {
            String tex = "appliedenergistics2:" + this.getname(new ItemStack((Item)this, 1, part.getKey().intValue()));
            part.getValue().ico = par1IconRegister.func_94245_a(tex);
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return AEApi.instance().partHelper().placeBus(is, x, y, z, side, player, w);
    }

    @Override
    public IPart createPartFromItemStack(ItemStack is) {
        try {
            PartType t = this.getTypeByStack(is);
            if (t != null) {
                return t.getPart().getConstructor(ItemStack.class).newInstance(is);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to construct IBusPart from IBusItem : " + this.getTypeByStack(is).getPart().getName() + " ; Possibly didn't have correct constructor( ItemStack )", e);
        }
        return null;
    }

    public void func_150895_a(Item number, CreativeTabs tab, List cList) {
        ArrayList<Map.Entry<Integer, PartTypeIst>> types = new ArrayList<Map.Entry<Integer, PartTypeIst>>(this.dmgToPart.entrySet());
        Collections.sort(types, new Comparator<Map.Entry<Integer, PartTypeIst>>(){

            @Override
            public int compare(Map.Entry<Integer, PartTypeIst> o1, Map.Entry<Integer, PartTypeIst> o2) {
                return o1.getValue().part.name().compareTo(o2.getValue().part.name());
            }
        });
        for (Map.Entry entry : types) {
            cList.add(new ItemStack((Item)this, 1, ((Integer)entry.getKey()).intValue()));
        }
    }

    public int varientOf(int itemDamage) {
        if (this.dmgToPart.containsKey(itemDamage)) {
            return this.dmgToPart.get((Object)Integer.valueOf((int)itemDamage)).varient;
        }
        return 0;
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        boolean importBus = false;
        boolean exportBus = false;
        boolean group = false;
        PartType u = this.getTypeByStack(is);
        for (ItemStack stack : others) {
            if (stack.func_77973_b() != this) continue;
            PartType pt = this.getTypeByStack(stack);
            switch (pt) {
                case ImportBus: {
                    importBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
                case ExportBus: {
                    exportBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
            }
        }
        if (group && importBus && exportBus) {
            return GuiText.IOBuses.getUnlocalized();
        }
        return null;
    }

    public ItemStack getStackFromTypeAndVarient(PartType mt, int varient) {
        return new ItemStack((Item)this, 1, mt.baseDamage + varient);
    }

    class PartTypeIst {
        PartType part;
        int varient;
        @SideOnly(value=Side.CLIENT)
        IIcon ico;

        PartTypeIst() {
        }
    }
}

