/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBasicStorageCell
extends AEBaseItem
implements IStorageCell,
IItemGroup {
    final MaterialType component;
    final int totalBytes;
    final int perType;
    final double idleDrain;

    public ItemBasicStorageCell(MaterialType whichCell, int Kilobytes) {
        super(ItemBasicStorageCell.class, Kilobytes + "k");
        this.setfeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
        this.totalBytes = Kilobytes * 1024;
        this.component = whichCell;
        switch (this.component) {
            case Cell1kPart: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case Cell4kPart: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case Cell16kPart: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case Cell64kPart: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    public void func_77624_a(ItemStack i, EntityPlayer p, List l, boolean b) {
        IMEInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(i, null, StorageChannel.ITEMS);
        if (cdi instanceof ICellInventoryHandler) {
            ICellInventoryHandler CI = (ICellInventoryHandler)cdi;
            ICellInventory cd = ((ICellInventoryHandler)cdi).getCellInv();
            if (cd != null) {
                l.add(cd.getUsedBytes() + " " + GuiText.Of.getLocal() + " " + cd.getTotalBytes() + " " + GuiText.BytesUsed.getLocal());
                l.add(cd.getStoredItemTypes() + " " + GuiText.Of.getLocal() + " " + cd.getTotalItemTypes() + " " + GuiText.Types.getLocal());
                if (CI.isPreformatted()) {
                    String List2 = (CI.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                    if (CI.isFuzzy()) {
                        l.add(GuiText.Partitioned.getLocal() + " - " + List2 + " " + GuiText.Fuzzy.getLocal());
                    } else {
                        l.add(GuiText.Partitioned.getLocal() + " - " + List2 + " " + GuiText.Precise.getLocal());
                    }
                }
            }
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public int BytePerType(ItemStack iscellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 63;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requsetedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    private boolean dissassembleDrive(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer pinv = player.field_71071_by;
            IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
            if (inv != null && pinv.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                IItemList list = inv.getAvailableItems(StorageChannel.ITEMS.createList());
                if (list.isEmpty() && ia != null) {
                    pinv.func_70299_a(pinv.field_70461_c, null);
                    ItemStack extraB = ia.addItems(this.component.stack(1));
                    ItemStack extraA = ia.addItems(AEApi.instance().materials().materialEmptyStorageCell.stack(1));
                    if (extraA != null) {
                        player.func_71019_a(extraA, false);
                    }
                    if (extraB != null) {
                        player.func_71019_a(extraB, false);
                    }
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        this.dissassembleDrive(stack, world, player);
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.dissassembleDrive(stack, world, player);
    }

    public boolean func_77634_r() {
        return AEConfig.instance.isFeatureEnabled(AEFeature.enableDisassemblyCrafting);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return AEApi.instance().materials().materialEmptyStorageCell.stack(1);
    }
}

