/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.features.AEFeature;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.IPartitionList;
import appeng.util.prioitylist.MergedPriorityList;
import appeng.util.prioitylist.PrecisePriorityList;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ItemViewCell
extends AEBaseItem
implements ICellWorkbenchItem {
    public ItemViewCell() {
        super(ItemViewCell.class);
        this.setfeature(EnumSet.of(AEFeature.Core));
        this.func_77625_d(1);
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public static IPartitionList<IAEItemStack> createFilter(ItemStack[] list) {
        MergedPriorityList<IAEItemStack> myPartitionList = null;
        MergedPriorityList<IAEItemStack> myMergedList = new MergedPriorityList<IAEItemStack>();
        for (ItemStack currentViewCell : list) {
            ItemStack is;
            int x;
            if (currentViewCell == null || !(currentViewCell.func_77973_b() instanceof ItemViewCell)) continue;
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
            ItemViewCell vc = (ItemViewCell)currentViewCell.func_77973_b();
            IInventory upgrades = vc.getUpgradesInventory(currentViewCell);
            IInventory config = vc.getConfigInventory(currentViewCell);
            FuzzyMode fzMode = vc.getFuzzyMode(currentViewCell);
            hasInverter = false;
            hasFuzzy = false;
            block5: for (x = 0; x < upgrades.func_70302_i_(); ++x) {
                Upgrades u;
                is = upgrades.func_70301_a(x);
                if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block5;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block5;
                    }
                }
            }
            for (x = 0; x < config.func_70302_i_(); ++x) {
                is = config.func_70301_a(x);
                if (is == null) continue;
                priorityList.add(AEItemStack.create(is));
            }
            if (priorityList.isEmpty()) continue;
            if (hasFuzzy) {
                myMergedList.addNewList(new FuzzyPriorityList<IAEItemStack>(priorityList, fzMode), !hasInverter);
            } else {
                myMergedList.addNewList(new PrecisePriorityList<IAEItemStack>(priorityList), !hasInverter);
            }
            myPartitionList = myMergedList;
        }
        return myPartitionList;
    }
}

