/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.block.misc.BlockPaint;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.items.ToolColorApplicatorRender;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.DispenserBlockTool;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.ItemPaintBall;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.storage.CellInventoryHandler;
import appeng.tile.misc.TilePaint;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class ToolColorApplicator
extends AEBasePoweredItem
implements IStorageCell,
IItemGroup,
IBlockTool,
IMouseWheelItem {
    static final HashMap<Integer, AEColor> oreToColor = new HashMap();

    public ToolColorApplicator() {
        super(ToolColorApplicator.class, null);
        this.setfeature(EnumSet.of(AEFeature.ColorApplicator, AEFeature.PoweredTools));
        this.maxStoredPower = AEConfig.instance.colorapplicator_battery;
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new ToolColorApplicatorRender());
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBlockTool());
    }

    public ItemStack getColor(ItemStack is) {
        NBTTagCompound color;
        ItemStack oldColor;
        NBTTagCompound c = is.func_77978_p();
        if (c != null && c.func_74764_b("color") && (oldColor = ItemStack.func_77949_a((NBTTagCompound)(color = c.func_74775_l("color")))) != null) {
            return oldColor;
        }
        return this.findNextColor(is, null, 0);
    }

    public AEColor getColorFromItem(ItemStack paintBall) {
        int[] id;
        if (paintBall == null) {
            return null;
        }
        if (paintBall.func_77973_b() instanceof ItemSnowball) {
            return AEColor.Transparent;
        }
        if (paintBall.func_77973_b() instanceof ItemPaintBall) {
            ItemPaintBall ipb = (ItemPaintBall)paintBall.func_77973_b();
            return ipb.getColor(paintBall);
        }
        for (int oreID : id = OreDictionary.getOreIDs((ItemStack)paintBall)) {
            if (!oreToColor.containsKey(oreID)) continue;
            return oreToColor.get(oreID);
        }
        return null;
    }

    public AEColor getActiveColor(ItemStack tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    private ItemStack findNextColor(ItemStack is, ItemStack anchor, int scrollOffset) {
        ItemStack newColor = null;
        IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (inv != null) {
            IItemList<IAEItemStack> itemList = inv.getAvailableItems(AEApi.instance().storage().createItemList());
            if (anchor == null) {
                IAEItemStack firstItem = itemList.getFirstItem();
                if (firstItem != null) {
                    newColor = firstItem.getItemStack();
                }
            } else {
                LinkedList<IAEItemStack> list = new LinkedList<IAEItemStack>();
                for (IAEItemStack i : itemList) {
                    list.add(i);
                }
                Collections.sort(list, new Comparator<IAEItemStack>(){

                    @Override
                    public int compare(IAEItemStack a, IAEItemStack b) {
                        return ItemSorters.compareInt(a.getItemDamage(), b.getItemDamage());
                    }
                });
                if (list.size() <= 0) {
                    return null;
                }
                IAEItemStack where = (IAEItemStack)list.getFirst();
                for (int cycles = 1 + list.size(); cycles > 0 && !where.equals(anchor); --cycles) {
                    list.addLast((IAEItemStack)list.removeFirst());
                    where = (IAEItemStack)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((IAEItemStack)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((IAEItemStack)list.removeLast());
                }
                return ((IAEItemStack)list.get(0)).getItemStack();
            }
        }
        if (newColor != null) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    public void setColor(ItemStack is, ItemStack newColor) {
        NBTTagCompound data = Platform.openNbtData(is);
        if (newColor == null) {
            data.func_82580_o("color");
        } else {
            NBTTagCompound color = new NBTTagCompound();
            newColor.func_77955_b(color);
            data.func_74782_a("color", (NBTBase)color);
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int side, float hitx, float hity, float hitz) {
        Block blk = w.func_147439_a(x, y, z);
        double powerPerUse = 100.0;
        ItemStack paintBall = this.getColor(is);
        IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (inv != null) {
            AEColor color;
            IAEItemStack option = inv.extractItems(AEItemStack.create(paintBall), Actionable.SIMULATE, new BaseActionSource());
            if (option != null) {
                paintBall = option.getItemStack();
                paintBall.field_77994_a = 1;
            } else {
                paintBall = null;
            }
            if (!Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
                return false;
            }
            if (paintBall != null && paintBall.func_77973_b() instanceof ItemSnowball) {
                ForgeDirection oside = ForgeDirection.getOrientation((int)side);
                TileEntity te = w.func_147438_o(x, y, z);
                if (te instanceof IColorableTile && this.getAECurrentPower(is) > powerPerUse && ((IColorableTile)te).getColor() != AEColor.Transparent && ((IColorableTile)te).recolourBlock(oside, AEColor.Transparent, p)) {
                    inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, powerPerUse);
                    return true;
                }
                Block testBlk = w.func_147439_a(x + oside.offsetX, y + oside.offsetY, z + oside.offsetZ);
                TileEntity painte = w.func_147438_o(x + oside.offsetX, y + oside.offsetY, z + oside.offsetZ);
                if (this.getAECurrentPower(is) > powerPerUse && testBlk instanceof BlockPaint && painte instanceof TilePaint) {
                    inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, powerPerUse);
                    ((TilePaint)painte).cleanSide(oside.getOpposite());
                    return true;
                }
            } else if (paintBall != null && (color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > powerPerUse && color != AEColor.Transparent && this.recolourBlock(blk, ForgeDirection.getOrientation((int)side), w, x, y, z, ForgeDirection.getOrientation((int)side), color, p)) {
                inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                this.extractAEPower(is, powerPerUse);
                return true;
            }
        }
        if (p.func_70093_af()) {
            this.cycleColors(is, paintBall, 1);
        }
        return false;
    }

    private boolean recolourBlock(Block blk, ForgeDirection side, World w, int x, int y, int z, ForgeDirection orientation, AEColor newColor, EntityPlayer p) {
        if (blk == Blocks.field_150404_cg) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, Blocks.field_150404_cg, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150359_w) {
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150399_cn, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150399_cn) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150399_cn, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150410_aZ) {
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150397_co, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150397_co) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, (Block)Blocks.field_150397_co, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150405_ch) {
            return w.func_147465_d(x, y, z, Blocks.field_150406_ce, newColor.ordinal(), 3);
        }
        if (blk == Blocks.field_150406_ce) {
            int meta = w.func_72805_g(x, y, z);
            if (newColor.ordinal() == meta) {
                return false;
            }
            return w.func_147465_d(x, y, z, Blocks.field_150406_ce, newColor.ordinal(), 3);
        }
        if (blk instanceof BlockCableBus) {
            return ((BlockCableBus)blk).recolourBlock(w, x, y, z, side, newColor.ordinal(), p);
        }
        return blk.recolourBlock(w, x, y, z, side, newColor.ordinal());
    }

    public void cycleColors(ItemStack is, ItemStack paintBall, int i) {
        if (paintBall == null) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        String extra = GuiText.Empty.getLocal();
        AEColor selected = this.getActiveColor(par1ItemStack);
        if (selected != null) {
            extra = Platform.gui_localize(selected.unlocalizedName);
        }
        return super.func_77653_i(par1ItemStack) + " - " + extra;
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        ICellInventory cd;
        super.func_77624_a(is, player, lines, advancedItemTooltips);
        IMEInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (cdi instanceof CellInventoryHandler && (cd = ((ICellInventoryHandler)cdi).getCellInv()) != null) {
            lines.add(cd.getUsedBytes() + " " + GuiText.Of.getLocal() + " " + cd.getTotalBytes() + " " + GuiText.BytesUsed.getLocal());
            lines.add(cd.getStoredItemTypes() + " " + GuiText.Of.getLocal() + " " + cd.getTotalItemTypes() + " " + GuiText.Types.getLocal());
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int BytePerType(ItemStack iscellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requsetedAddition) {
        if (requsetedAddition != null) {
            int[] id;
            for (int x : id = OreDictionary.getOreIDs((ItemStack)requsetedAddition.getItemStack())) {
                if (!oreToColor.containsKey(x)) continue;
                return false;
            }
            if (requsetedAddition.getItem() instanceof ItemSnowball) {
                return false;
            }
            return !(requsetedAddition.getItem() instanceof ItemPaintBall) || requsetedAddition.getItemDamage() >= 20;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public void onWheel(ItemStack is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    static {
        for (AEColor col : AEColor.values()) {
            if (col == AEColor.Transparent) continue;
            oreToColor.put(OreDictionary.getOreID((String)("dye" + col.name())), col);
        }
    }
}

