/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMatterCannon;
import appeng.hooks.DispenserMatterCannon;
import appeng.hooks.TickHandler;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.ItemPaintBall;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.storage.CellInventoryHandler;
import appeng.tile.misc.TilePaint;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolMassCannon
extends AEBasePoweredItem
implements IStorageCell {
    public ToolMassCannon() {
        super(ToolMassCannon.class, null);
        this.setfeature(EnumSet.of(AEFeature.MatterCannon, AEFeature.PoweredTools));
        this.maxStoredPower = AEConfig.instance.mattercannon_battery;
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserMatterCannon());
    }

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        ICellInventory cd;
        super.func_77624_a(is, player, lines, advancedItemTooltips);
        IMEInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (cdi instanceof CellInventoryHandler && (cd = ((ICellInventoryHandler)cdi).getCellInv()) != null) {
            lines.add(cd.getUsedBytes() + " " + GuiText.Of.getLocal() + " " + cd.getTotalBytes() + " " + GuiText.BytesUsed.getLocal());
            lines.add(cd.getStoredItemTypes() + " " + GuiText.Of.getLocal() + " " + cd.getTotalItemTypes() + " " + GuiText.Types.getLocal());
        }
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer p) {
        if (this.getAECurrentPower(item) > 1600.0) {
            IMEInventoryHandler inv;
            int shots = 1;
            CellUpgrades cu = (CellUpgrades)this.getUpgradesInventory(item);
            if (cu != null) {
                shots += cu.getInstalledUpgrades(Upgrades.SPEED);
            }
            if ((inv = AEApi.instance().registries().cell().getCellInventory(item, null, StorageChannel.ITEMS)) != null) {
                IItemList<IAEItemStack> itemList = inv.getAvailableItems(AEApi.instance().storage().createItemList());
                IAEItemStack aeammo = itemList.getFirstItem();
                if (aeammo instanceof IAEItemStack) {
                    shots = Math.min(shots, (int)aeammo.getStackSize());
                    for (int sh = 0; sh < shots; ++sh) {
                        this.extractAEPower(item, 1600.0);
                        if (Platform.isClient()) {
                            return item;
                        }
                        aeammo.setStackSize(1L);
                        ItemStack ammo = aeammo.getItemStack();
                        if (ammo == null) {
                            return item;
                        }
                        ammo.field_77994_a = 1;
                        if ((aeammo = inv.extractItems(aeammo, Actionable.MODULATE, new PlayerSource(p, null))) == null) {
                            return item;
                        }
                        float f = 1.0f;
                        float f1 = p.field_70127_C + (p.field_70125_A - p.field_70127_C) * f;
                        float f2 = p.field_70126_B + (p.field_70177_z - p.field_70126_B) * f;
                        double d0 = p.field_70169_q + (p.field_70165_t - p.field_70169_q) * (double)f;
                        double d1 = p.field_70167_r + (p.field_70163_u - p.field_70167_r) * (double)f + 1.62 - (double)p.field_70129_M;
                        double d2 = p.field_70166_s + (p.field_70161_v - p.field_70166_s) * (double)f;
                        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
                        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
                        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
                        float f7 = f4 * f5;
                        float f8 = f3 * f5;
                        double d3 = 32.0;
                        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                        Vec3 direction = Vec3.func_72443_a((double)((double)f7 * d3), (double)((double)f6 * d3), (double)((double)f8 * d3));
                        direction.func_72432_b();
                        float penitration = AEApi.instance().registries().matterCannon().getPenetration(ammo);
                        if (penitration <= 0.0f) {
                            ItemStack type = aeammo.getItemStack();
                            if (type.func_77973_b() instanceof ItemPaintBall) {
                                this.shootPaintBalls(type, w, p, vec3, vec31, direction, d0, d1, d2);
                            }
                            return item;
                        }
                        this.standardAmmo(penitration, w, p, vec3, vec31, direction, d0, d1, d2);
                    }
                } else {
                    if (Platform.isServer()) {
                        p.func_145747_a(PlayerMessages.AmmoDepleted.get());
                    }
                    return item;
                }
            }
        }
        return item;
    }

    private void shootPaintBalls(ItemStack type, World w, EntityPlayer p, Vec3 vec3, Vec3 vec31, Vec3 direction, double d0, double d1, double d2) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)Math.min(vec3.field_72450_a, vec31.field_72450_a), (double)Math.min(vec3.field_72448_b, vec31.field_72448_b), (double)Math.min(vec3.field_72449_c, vec31.field_72449_c), (double)Math.max(vec3.field_72450_a, vec31.field_72450_a), (double)Math.max(vec3.field_72448_b, vec31.field_72448_b), (double)Math.max(vec3.field_72449_c, vec31.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
        Entity entity = null;
        List list = w.func_72839_b((Entity)p, bb);
        double Closeest = 9999999.0;
        for (int l = 0; l < list.size(); ++l) {
            double nd;
            float f1;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(l);
            if (entity1.field_70128_L || entity1 == p || entity1 instanceof EntityItem || !entity1.func_70089_S() || entity1.field_70153_n == p || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f1 = 0.3f), (double)f1, (double)f1)).func_72327_a(vec3, vec31)) == null || !((nd = vec3.func_72436_e(movingobjectposition1.field_72307_f)) < Closeest)) continue;
            entity = entity1;
            Closeest = nd;
        }
        MovingObjectPosition pos = w.func_72901_a(vec3, vec31, false);
        Vec3 Srec = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        if (entity != null && pos != null && pos.field_72307_f.func_72436_e(Srec) > Closeest) {
            pos = new MovingObjectPosition(entity);
        } else if (entity != null && pos == null) {
            pos = new MovingObjectPosition(entity);
        }
        try {
            CommonHelper.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new PacketMatterCannon(d0, d1, d2, (float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c, (byte)(pos == null ? 32.0 : pos.field_72307_f.func_72436_e(Srec) + 1.0)));
        }
        catch (Exception err) {
            AELog.error(err);
        }
        if (pos != null && type != null && type.func_77973_b() instanceof ItemPaintBall) {
            ItemPaintBall ipb = (ItemPaintBall)type.func_77973_b();
            AEColor col = ipb.getColor(type);
            if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                int id = pos.field_72308_g.func_145782_y();
                TickHandler.PlayerColor marker = new TickHandler.PlayerColor(id, col, 600);
                TickHandler.instance.getPlayerColors().put(id, marker);
                if (pos.field_72308_g instanceof EntitySheep) {
                    EntitySheep sh = (EntitySheep)pos.field_72308_g;
                    sh.func_70891_b(col.ordinal());
                }
                pos.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)p), 0.0f);
                NetworkHandler.instance.sendToAll(marker.getPacket());
            } else if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                TileEntity te;
                ForgeDirection side = ForgeDirection.getOrientation((int)pos.field_72310_e);
                int x = pos.field_72311_b + side.offsetX;
                int y = pos.field_72312_c + side.offsetY;
                int z = pos.field_72309_d + side.offsetZ;
                if (!Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
                    return;
                }
                Block whatsThere = w.func_147439_a(x, y, z);
                if (whatsThere != AEApi.instance().blocks().blockPaint.block() && whatsThere.isReplaceable((IBlockAccess)w, x, y, z) && w.func_147437_c(x, y, z)) {
                    w.func_147465_d(x, y, z, AEApi.instance().blocks().blockPaint.block(), 0, 3);
                }
                if ((te = w.func_147438_o(x, y, z)) instanceof TilePaint) {
                    pos.field_72307_f.field_72450_a -= (double)x;
                    pos.field_72307_f.field_72448_b -= (double)y;
                    pos.field_72307_f.field_72449_c -= (double)z;
                    ((TilePaint)te).addBlot(type, side.getOpposite(), pos.field_72307_f);
                }
            }
        }
    }

    private void standardAmmo(float penitration, World w, EntityPlayer p, Vec3 vec3, Vec3 vec31, Vec3 direction, double d0, double d1, double d2) {
        boolean hasDestroyedSomething = true;
        while (penitration > 0.0f && hasDestroyedSomething) {
            hasDestroyedSomething = false;
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)Math.min(vec3.field_72450_a, vec31.field_72450_a), (double)Math.min(vec3.field_72448_b, vec31.field_72448_b), (double)Math.min(vec3.field_72449_c, vec31.field_72449_c), (double)Math.max(vec3.field_72450_a, vec31.field_72450_a), (double)Math.max(vec3.field_72448_b, vec31.field_72448_b), (double)Math.max(vec3.field_72449_c, vec31.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
            Entity entity = null;
            List list = w.func_72839_b((Entity)p, bb);
            double Closeest = 9999999.0;
            for (int l = 0; l < list.size(); ++l) {
                double nd;
                float f1;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(l);
                if (entity1.field_70128_L || entity1 == p || entity1 instanceof EntityItem || !entity1.func_70089_S() || entity1.field_70153_n == p || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f1 = 0.3f), (double)f1, (double)f1)).func_72327_a(vec3, vec31)) == null || !((nd = vec3.func_72436_e(movingobjectposition1.field_72307_f)) < Closeest)) continue;
                entity = entity1;
                Closeest = nd;
            }
            Vec3 Srec = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
            MovingObjectPosition pos = w.func_72901_a(vec3, vec31, true);
            if (entity != null && pos != null && pos.field_72307_f.func_72436_e(Srec) > Closeest) {
                pos = new MovingObjectPosition(entity);
            } else if (entity != null && pos == null) {
                pos = new MovingObjectPosition(entity);
            }
            try {
                CommonHelper.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new PacketMatterCannon(d0, d1, d2, (float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c, (byte)(pos == null ? 32.0 : pos.field_72307_f.func_72436_e(Srec) + 1.0)));
            }
            catch (Exception err) {
                AELog.error(err);
            }
            if (pos == null) continue;
            DamageSource dmgSrc = DamageSource.func_76365_a((EntityPlayer)p);
            dmgSrc.field_76373_n = "masscannon";
            if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                int dmg = (int)Math.ceil(penitration / 20.0f);
                if (pos.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase el = (EntityLivingBase)pos.field_72308_g;
                    penitration -= (float)dmg;
                    el.func_70653_a((Entity)p, 0.0f, -direction.field_72450_a, -direction.field_72449_c);
                    el.func_70097_a(dmgSrc, (float)dmg);
                    if (el.func_70089_S()) continue;
                    hasDestroyedSomething = true;
                    continue;
                }
                if (pos.field_72308_g instanceof EntityItem) {
                    hasDestroyedSomething = true;
                    pos.field_72308_g.func_70106_y();
                    continue;
                }
                if (!pos.field_72308_g.func_70097_a(dmgSrc, (float)dmg)) continue;
                hasDestroyedSomething = true;
                continue;
            }
            if (pos.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) continue;
            if (!AEConfig.instance.isFeatureEnabled(AEFeature.MassCannonBlockDamage)) {
                penitration = 0.0f;
                continue;
            }
            Block b = w.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            float hardness = b.func_149712_f(w, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) * 9.0f;
            if (!((double)hardness >= 0.0) || !(penitration > hardness) || !Platform.hasPermissions(new DimensionalCoord(w, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d), p)) continue;
            hasDestroyedSomething = true;
            penitration -= hardness;
            penitration = (float)((double)penitration * 0.6);
            w.func_147480_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, true);
        }
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 4);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int BytePerType(ItemStack iscellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 1;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requsetedAddition) {
        float pen = AEApi.instance().registries().matterCannon().getPenetration(requsetedAddition.getItemStack());
        if (pen > 0.0f) {
            return false;
        }
        return !(requsetedAddition.getItem() instanceof ItemPaintBall);
    }
}

