/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AERootPoweredItem
extends AEBaseItem
implements IAEItemPowerStorage {
    public double maxStoredPower = 200000.0;
    final String EnergyVar = "internalCurrentPower";

    public AERootPoweredItem(Class c, String subname) {
        super(c, subname);
        this.func_77656_e(32);
        this.field_77787_bX = false;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        NBTTagCompound tag = is.func_77978_p();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getAEMaxPower(is);
        if (tag != null) {
            internalCurrentPower = tag.func_74769_h("internalCurrentPower");
        }
        double percent = internalCurrentPower / internalMaxPower;
        lines.add(GuiText.StoredEnergy.getLocal() + ":" + MessageFormat.format(" {0,number,#} ", internalCurrentPower) + Platform.gui_localize(PowerUnits.AE.unlocalizedName) + " - " + MessageFormat.format(" {0,number,#.##%} ", percent));
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    private double getInternalBattery(ItemStack is, batteryOperation op, double adjustment) {
        NBTTagCompound data = Platform.openNbtData(is);
        double currentStorage = data.func_74769_h("internalCurrentPower");
        double maxStorage = this.getAEMaxPower(is);
        switch (op) {
            case INJECT: {
                currentStorage += adjustment;
                if (currentStorage > maxStorage) {
                    double diff = currentStorage - maxStorage;
                    data.func_74780_a("internalCurrentPower", maxStorage);
                    return diff;
                }
                data.func_74780_a("internalCurrentPower", currentStorage);
                return 0.0;
            }
            case EXTRACT: {
                if (currentStorage > adjustment) {
                    data.func_74780_a("internalCurrentPower", currentStorage -= adjustment);
                    return adjustment;
                }
                data.func_74780_a("internalCurrentPower", 0.0);
                return currentStorage;
            }
        }
        return currentStorage;
    }

    double injectExternalPower(PowerUnits input, ItemStack is, double amount, boolean simulate) {
        if (simulate) {
            int requiredEU = (int)PowerUnits.AE.convertTo(PowerUnits.EU, this.getAEMaxPower(is) - this.getAECurrentPower(is));
            if (amount < (double)requiredEU) {
                return 0.0;
            }
            return amount - (double)requiredEU;
        }
        double powerRemainder = this.injectAEPower(is, PowerUnits.EU.convertTo(PowerUnits.AE, amount));
        return PowerUnits.AE.convertTo(PowerUnits.EU, powerRemainder);
    }

    @Override
    public double injectAEPower(ItemStack is, double amt) {
        return this.getInternalBattery(is, batteryOperation.INJECT, amt);
    }

    @Override
    public double extractAEPower(ItemStack is, double amt) {
        return this.getInternalBattery(is, batteryOperation.EXTRACT, amt);
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.maxStoredPower;
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        return this.getInternalBattery(is, batteryOperation.STORAGE, 0.0);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    public int getDisplayDamage(ItemStack is) {
        return 32 - (int)(32.0 * (this.getAECurrentPower(is) / this.getAEMaxPower(is)));
    }

    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        super.func_150895_a(id, tab, list);
        ItemStack charged = new ItemStack((Item)this, 1);
        NBTTagCompound tag = Platform.openNbtData(charged);
        tag.func_74780_a("internalCurrentPower", this.getAEMaxPower(charged));
        tag.func_74780_a("internalMaxPower", this.getAEMaxPower(charged));
        list.add(charged);
    }

    private static enum batteryOperation {
        STORAGE,
        INJECT,
        EXTRACT;

    }
}

