/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.WorldSettings;
import appeng.hooks.TickHandler;
import appeng.me.GridCacheWrapper;
import appeng.me.GridNode;
import appeng.me.GridStorage;
import appeng.me.MachineSet;
import appeng.me.NetworkEventBus;
import appeng.me.NodeIteratable;
import appeng.util.ReadOnlyCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class Grid
implements IGrid {
    GridStorage myStorage;
    NetworkEventBus bus = new NetworkEventBus();
    HashMap<Class<? extends IGridHost>, Set> Machines = new HashMap();
    HashMap<Class<? extends IGridCache>, GridCacheWrapper> caches = new HashMap();
    GridNode pivot;
    int isImportant;

    public Grid(GridNode center) {
        this.pivot = center;
        HashMap<Class<? extends IGridCache>, IGridCache> myCaches = AEApi.instance().registries().gridCache().createCacheInstance(this);
        for (Class<? extends IGridCache> c : myCaches.keySet()) {
            this.bus.readClass(c, myCaches.get(c).getClass());
            this.caches.put(c, new GridCacheWrapper(myCaches.get(c)));
        }
        this.postEvent(new MENetworkPostCacheConstruction());
        TickHandler.instance.addNetwork(this);
        center.setGrid(this);
    }

    public Set<Class<? extends IGridHost>> getMachineClasses() {
        return this.Machines.keySet();
    }

    @Override
    public IGridNode getPivot() {
        return this.pivot;
    }

    public int size() {
        int out = 0;
        for (Collection collection : this.Machines.values()) {
            out += collection.size();
        }
        return out;
    }

    public void remove(GridNode gridNode) {
        for (IGridCache iGridCache : this.caches.values()) {
            iGridCache.removeNode(gridNode, gridNode.getMachine());
        }
        Collection nodes = this.Machines.get(gridNode.getMachineClass());
        if (nodes != null) {
            nodes.remove(gridNode);
        }
        gridNode.setGridStorage(null);
        if (this.pivot == gridNode) {
            Iterator iterator = this.getNodes().iterator();
            if (iterator.hasNext()) {
                this.pivot = (GridNode)iterator.next();
            } else {
                this.pivot = null;
                TickHandler.instance.removeNetwork(this);
                this.myStorage.remove();
            }
        }
    }

    public void add(GridNode gridNode) {
        Class<? extends IGridHost> mClass = gridNode.getMachineClass();
        Set nodes = this.Machines.get(mClass);
        if (nodes == null) {
            nodes = new MachineSet(mClass);
            this.Machines.put(mClass, nodes);
            this.bus.readClass(mClass, mClass);
        }
        if (gridNode.getGridStorage() != null) {
            GridStorage gs = gridNode.getGridStorage();
            if (gs.getGrid() == null) {
                this.myStorage = gs;
                this.myStorage.setGrid(this);
                for (IGridCache iGridCache : this.caches.values()) {
                    iGridCache.onJoin(this.myStorage);
                }
            } else if (gs.getGrid() != this) {
                if (this.myStorage == null) {
                    this.myStorage = WorldSettings.getInstance().getNewGridStorage();
                    this.myStorage.setGrid(this);
                }
                GridStorage gridStorage = new GridStorage();
                if (!gs.hasDivided(this.myStorage)) {
                    gs.addDivided(this.myStorage);
                    for (IGridCache iGridCache : ((Grid)gs.getGrid()).caches.values()) {
                        iGridCache.onSplit(gridStorage);
                    }
                    for (IGridCache iGridCache : this.caches.values()) {
                        iGridCache.onJoin(gridStorage);
                    }
                }
            }
        } else if (this.myStorage == null) {
            this.myStorage = WorldSettings.getInstance().getNewGridStorage();
            this.myStorage.setGrid(this);
        }
        gridNode.setGridStorage(this.myStorage);
        nodes.add(gridNode);
        for (IGridCache iGridCache : this.caches.values()) {
            iGridCache.addNode(gridNode, gridNode.getMachine());
        }
        gridNode.gridProxy.gridChanged();
    }

    @Override
    public IReadOnlyCollection<IGridNode> getNodes() {
        return new NodeIteratable<IGridNode>(this.Machines);
    }

    @Override
    public IReadOnlyCollection<Class<? extends IGridHost>> getMachinesClasses() {
        return new ReadOnlyCollection<Class<? extends IGridHost>>(this.Machines.keySet());
    }

    @Override
    public IMachineSet getMachines(Class<? extends IGridHost> c) {
        MachineSet s = (MachineSet)this.Machines.get(c);
        if (s == null) {
            return new MachineSet(c);
        }
        return s;
    }

    @Override
    public <C extends IGridCache> C getCache(Class<? extends IGridCache> iface) {
        return (C)this.caches.get(iface).myCache;
    }

    @Override
    public MENetworkEvent postEventTo(IGridNode node, MENetworkEvent ev) {
        return this.bus.postEventTo(this, (GridNode)node, ev);
    }

    @Override
    public MENetworkEvent postEvent(MENetworkEvent ev) {
        return this.bus.postEvent(this, ev);
    }

    public void requestSave() {
        this.myStorage.markDirty();
        WorldSettings.getInstance().save();
    }

    public void update() {
        for (IGridCache iGridCache : this.caches.values()) {
            if (this.pivot == null) continue;
            iGridCache.onUpdateTick();
        }
    }

    public Iterable<GridCacheWrapper> getCacheWrappers() {
        return this.caches.values();
    }

    @Override
    public boolean isEmpty() {
        return this.pivot == null;
    }

    public void saveState() {
        for (IGridCache iGridCache : this.caches.values()) {
            iGridCache.populateGridStorage(this.myStorage);
        }
    }

    public void setImportantFlag(int i, boolean publicHasPower) {
        int flag = 1 << i;
        this.isImportant = this.isImportant & ~flag | (publicHasPower ? flag : 0);
    }
}

