/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.me.GridException;
import appeng.me.GridNode;
import appeng.me.GridPropagator;
import appeng.me.pathfinding.IPathItem;
import appeng.util.Platform;
import appeng.util.ReadOnlyCollection;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraftforge.common.util.ForgeDirection;

public class GridConnection
implements IGridConnection,
IPathItem {
    private static final MENetworkChannelsChanged event = new MENetworkChannelsChanged();
    private GridNode sideA;
    private ForgeDirection fromAtoB;
    private GridNode sideB;
    Object visitorIterationNumber = null;
    public int channelData = 0;

    public GridConnection(IGridNode aNode, IGridNode bNode, ForgeDirection fromAtoB) throws FailedConnection {
        GridPropagator gp;
        GridNode a = (GridNode)aNode;
        GridNode b = (GridNode)bNode;
        if (Platform.securityCheck(a, b)) {
            if (AEConfig.instance.isFeatureEnabled(AEFeature.LogSecurityAudits)) {
                AELog.info("Audit Failed 1: " + a.getGridBlock().getLocation(), new Object[0]);
                AELog.info("Audit Failed 2: " + b.getGridBlock().getLocation(), new Object[0]);
            }
            throw new FailedConnection();
        }
        if (a == null || b == null) {
            throw new GridException("Connection Forged Between null enties.");
        }
        if (a.hasConnection(b) || b.hasConnection(a)) {
            throw new GridException("Connection already exists.");
        }
        this.sideA = a;
        this.fromAtoB = fromAtoB;
        this.sideB = b;
        if (b.myGrid == null) {
            b.setGrid(a.getInternalGrid());
        } else if (a.myGrid == null) {
            gp = new GridPropagator(b.getInternalGrid());
            a.beginVisition(gp);
        } else if (b.myGrid == null) {
            gp = new GridPropagator(a.getInternalGrid());
            b.beginVisition(gp);
        } else if (this.isNetworkABetter(a, b)) {
            gp = new GridPropagator(a.getInternalGrid());
            b.beginVisition(gp);
        } else {
            gp = new GridPropagator(b.getInternalGrid());
            a.beginVisition(gp);
        }
        IPathingGrid p = (IPathingGrid)this.sideA.getInternalGrid().getCache(IPathingGrid.class);
        p.repath();
        this.sideA.addConnection(this);
        this.sideB.addConnection(this);
    }

    private boolean isNetworkABetter(GridNode a, GridNode b) {
        return a.myGrid.isImportant > b.myGrid.isImportant || a.myGrid.size() > b.myGrid.size();
    }

    @Override
    public void destroy() {
        IPathingGrid p = (IPathingGrid)this.sideA.getInternalGrid().getCache(IPathingGrid.class);
        p.repath();
        this.sideA.removeConnection(this);
        this.sideB.removeConnection(this);
        this.sideA.validateGrid();
        this.sideB.validateGrid();
    }

    @Override
    public IGridNode a() {
        return this.sideA;
    }

    @Override
    public ForgeDirection getDirection(IGridNode side) {
        if (this.fromAtoB == ForgeDirection.UNKNOWN) {
            return this.fromAtoB;
        }
        if (this.sideA == side) {
            return this.fromAtoB;
        }
        return this.fromAtoB.getOpposite();
    }

    @Override
    public IGridNode b() {
        return this.sideB;
    }

    @Override
    public IGridNode getOtherSide(IGridNode gridNode) {
        if (gridNode == this.sideA) {
            return this.sideB;
        }
        if (gridNode == this.sideB) {
            return this.sideA;
        }
        throw new GridException("Invalid Side of Connection");
    }

    @Override
    public boolean hasDirection() {
        return this.fromAtoB != ForgeDirection.UNKNOWN;
    }

    @Override
    public IReadOnlyCollection<IPathItem> getPossibleOptions() {
        return new ReadOnlyCollection<IPathItem>(Arrays.asList((IPathItem)((Object)this.a()), (IPathItem)((Object)this.b())));
    }

    @Override
    public void incrementChannelCount(int usedChannels) {
        this.channelData += usedChannels;
    }

    @Override
    public boolean canSupportMoreChannels() {
        return this.getLastUsedChannels() < 32;
    }

    @Override
    public int getUsedChannels() {
        return this.channelData >> 8 & 0xFF;
    }

    public int getLastUsedChannels() {
        return this.channelData & 0xFF;
    }

    @Override
    public IPathItem getControllerRoute() {
        if (this.sideA.getFlags().contains((Object)GridFlags.CANNOT_CARRY)) {
            return null;
        }
        return this.sideA;
    }

    @Override
    public void setControllerRoute(IPathItem fast, boolean zeroOut) {
        if (zeroOut) {
            this.channelData &= 0xFFFFFF00;
        }
        if (this.sideB == fast) {
            GridNode tmp = this.sideA;
            this.sideA = this.sideB;
            this.sideB = tmp;
            this.fromAtoB = this.fromAtoB.getOpposite();
        }
    }

    @Override
    public void finalizeChannels() {
        if (this.getUsedChannels() != this.getLastUsedChannels()) {
            this.channelData &= 0xFF;
            this.channelData |= this.channelData << 8;
            if (this.sideA.getInternalGrid() != null) {
                this.sideA.getInternalGrid().postEventTo(this.sideA, event);
            }
            if (this.sideB.getInternalGrid() != null) {
                this.sideB.getInternalGrid().postEventTo(this.sideB, event);
            }
        }
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }
}

