/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridConnecitonVisitor;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.WorldSettings;
import appeng.hooks.TickHandler;
import appeng.me.Grid;
import appeng.me.GridConnection;
import appeng.me.GridPropagator;
import appeng.me.GridSplitDetector;
import appeng.me.GridStorage;
import appeng.me.pathfinding.IPathItem;
import appeng.util.ReadOnlyCollection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GridNode
implements IGridNode,
IPathItem {
    private static final MENetworkChannelsChanged event = new MENetworkChannelsChanged();
    final List<IGridConnection> Connections = new LinkedList<IGridConnection>();
    GridStorage myStorage = null;
    IGridBlock gridProxy;
    Grid myGrid;
    Object visitorIterationNumber = null;
    AEColor myColor = AEColor.Transparent;
    EnumSet<ForgeDirection> validDirections = EnumSet.noneOf(ForgeDirection.class);
    public double previousDraw = 0.0;
    private int maxChannels = 8;
    private int channelData = 0;
    public long lastSecurityKey = -1L;
    public int playerID = -1;

    @Override
    public void setPlayerID(int playerID) {
        if (playerID >= 0) {
            this.playerID = playerID;
        }
    }

    public int usedChannels() {
        return this.channelData >> 8;
    }

    public AEColor getColor() {
        return this.myColor;
    }

    public GridNode(IGridBlock what) {
        this.gridProxy = what;
    }

    @Override
    public void loadFromNBT(String name, NBTTagCompound nodeData) {
        if (this.myGrid != null) {
            throw new RuntimeException("Loading data after part of a grid, this is invalid.");
        }
        NBTTagCompound node = nodeData.func_74775_l(name);
        this.playerID = node.func_74762_e("p");
        this.lastSecurityKey = node.func_74763_f("k");
        this.setGridStorage(WorldSettings.getInstance().getGridStorage(node.func_74763_f("g")));
    }

    @Override
    public void saveToNBT(String name, NBTTagCompound nodeData) {
        if (this.myStorage != null) {
            NBTTagCompound node = new NBTTagCompound();
            node.func_74768_a("p", this.playerID);
            node.func_74772_a("k", this.lastSecurityKey);
            node.func_74772_a("g", this.myStorage.getID());
            nodeData.func_74782_a(name, (NBTBase)node);
        } else {
            nodeData.func_82580_o(name);
        }
    }

    @Override
    public IGridBlock getGridBlock() {
        return this.gridProxy;
    }

    @Override
    public EnumSet<ForgeDirection> getConnectedSides() {
        EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
        for (IGridConnection gc : this.Connections) {
            set.add(gc.getDirection(this));
        }
        return set;
    }

    public Class<? extends IGridHost> getMachineClass() {
        return this.getMachine().getClass();
    }

    @Override
    public IGridHost getMachine() {
        return this.gridProxy.getMachine();
    }

    @Override
    public void updateState() {
        EnumSet<GridFlags> set = this.gridProxy.getFlags();
        this.maxChannels = set.contains((Object)GridFlags.CANNOT_CARRY) ? 0 : (set.contains((Object)GridFlags.DENSE_CAPACITY) ? 32 : 8);
        this.myColor = this.gridProxy.getGridColor();
        this.validDirections = this.gridProxy.getConnectableSides();
        this.FindConnections();
        this.getInternalGrid();
    }

    @Override
    public void beginVisition(IGridVisitor g) {
        Object tracker = new Object();
        LinkedList<GridNode> nextRun = new LinkedList<GridNode>();
        nextRun.add(this);
        this.visitorIterationNumber = tracker;
        if (g instanceof IGridConnecitonVisitor) {
            LinkedList<IGridConnection> nextConn = new LinkedList<IGridConnection>();
            IGridConnecitonVisitor gcv = (IGridConnecitonVisitor)g;
            while (!nextRun.isEmpty()) {
                while (!nextConn.isEmpty()) {
                    gcv.visitConnection((IGridConnection)nextConn.poll());
                }
                LinkedList<GridNode> thisRun = nextRun;
                nextRun = new LinkedList();
                for (GridNode n : thisRun) {
                    n.visitorConnection(tracker, g, nextRun, nextConn);
                }
            }
        } else {
            while (!nextRun.isEmpty()) {
                LinkedList<GridNode> thisRun = nextRun;
                nextRun = new LinkedList();
                for (GridNode n : thisRun) {
                    n.visitorNode(tracker, g, nextRun);
                }
            }
        }
    }

    private void visitorConnection(Object tracker, IGridVisitor g, LinkedList<GridNode> nextRun, LinkedList<IGridConnection> nextConnections) {
        if (g.visitNode(this)) {
            for (IGridConnection gc : this.getConnections()) {
                GridNode gn = (GridNode)gc.getOtherSide(this);
                GridConnection gcc = (GridConnection)gc;
                if (gcc.visitorIterationNumber != tracker) {
                    gcc.visitorIterationNumber = tracker;
                    nextConnections.add(gc);
                }
                if (tracker == gn.visitorIterationNumber) continue;
                gn.visitorIterationNumber = tracker;
                nextRun.add(gn);
            }
        }
    }

    private void visitorNode(Object tracker, IGridVisitor g, LinkedList<GridNode> nextRun) {
        if (g.visitNode(this)) {
            for (IGridConnection gc : this.getConnections()) {
                GridNode gn = (GridNode)gc.getOtherSide(this);
                if (tracker == gn.visitorIterationNumber) continue;
                gn.visitorIterationNumber = tracker;
                nextRun.add(gn);
            }
        }
    }

    public void FindConnections() {
        if (!this.gridProxy.isWorldAccessable()) {
            return;
        }
        EnumSet<ForgeDirection> newSecurityConnections = EnumSet.noneOf(ForgeDirection.class);
        DimensionalCoord dc = this.gridProxy.getLocation();
        for (ForgeDirection f : ForgeDirection.VALID_DIRECTIONS) {
            GridNode node;
            IGridHost te = this.findGridHost(dc.getWorld(), dc.x + f.offsetX, dc.y + f.offsetY, dc.z + f.offsetZ);
            if (te == null || (node = (GridNode)te.getGridNode(f.getOpposite())) == null) continue;
            boolean isValidConnection = this.canConnect(node, f) && node.canConnect(this, f.getOpposite());
            IGridConnection con = null;
            for (IGridConnection c : this.getConnections()) {
                if (c.getDirection(this) != f) continue;
                con = c;
                break;
            }
            if (con != null) {
                IGridNode os = con.getOtherSide(this);
                if (os == node) {
                    if (isValidConnection) continue;
                    con.destroy();
                    continue;
                }
                con.destroy();
                continue;
            }
            if (!isValidConnection) continue;
            if (node.lastSecurityKey != -1L) {
                newSecurityConnections.add(f);
                continue;
            }
            try {
                new GridConnection(node, this, f.getOpposite());
            }
            catch (FailedConnection e) {
                TickHandler.instance.addCallable(node.getWorld(), new Callable(){

                    public Object call() throws Exception {
                        GridNode.this.getMachine().securityBreak();
                        return null;
                    }
                });
                return;
            }
        }
        for (ForgeDirection f : newSecurityConnections) {
            GridNode node;
            IGridHost te = this.findGridHost(dc.getWorld(), dc.x + f.offsetX, dc.y + f.offsetY, dc.z + f.offsetZ);
            if (te == null || (node = (GridNode)te.getGridNode(f.getOpposite())) == null) continue;
            try {
                new GridConnection(node, this, f.getOpposite());
            }
            catch (FailedConnection e) {
                TickHandler.instance.addCallable(node.getWorld(), new Callable(){

                    public Object call() throws Exception {
                        GridNode.this.getMachine().securityBreak();
                        return null;
                    }
                });
                return;
            }
        }
    }

    private IGridHost findGridHost(World world, int x, int y, int z) {
        TileEntity te;
        if (world.func_72899_e(x, y, z) && (te = world.func_147438_o(x, y, z)) instanceof IGridHost) {
            return (IGridHost)te;
        }
        return null;
    }

    public void addConnection(IGridConnection gridConnection) {
        this.Connections.add(gridConnection);
        if (gridConnection.hasDirection()) {
            this.gridProxy.onGridNotification(GridNotification.ConnectionsChanged);
        }
        final GridNode gn = this;
        Collections.sort(this.Connections, new Comparator<IGridConnection>(){

            @Override
            public int compare(IGridConnection o1, IGridConnection o2) {
                boolean preferedB;
                boolean preferedA = o1.getOtherSide(gn).hasFlag(GridFlags.PREFERED);
                return preferedA == (preferedB = o2.getOtherSide(gn).hasFlag(GridFlags.PREFERED)) ? 0 : (preferedA ? -1 : 1);
            }
        });
    }

    public void removeConnection(IGridConnection gridConnection) {
        this.Connections.remove(gridConnection);
        if (gridConnection.hasDirection()) {
            this.gridProxy.onGridNotification(GridNotification.ConnectionsChanged);
        }
    }

    @Override
    public IReadOnlyCollection<IGridConnection> getConnections() {
        return new ReadOnlyCollection<IGridConnection>(this.Connections);
    }

    public boolean hasConnection(IGridNode otherside) {
        for (IGridConnection gc : this.Connections) {
            if (gc.a() != otherside && gc.b() != otherside) continue;
            return true;
        }
        return false;
    }

    public boolean canConnect(GridNode from, ForgeDirection dir) {
        if (!this.validDirections.contains(dir)) {
            return false;
        }
        return from.getColor().matches(this.getColor());
    }

    @Override
    public IGrid getGrid() {
        return this.myGrid;
    }

    public Grid getInternalGrid() {
        if (this.myGrid == null) {
            this.myGrid = new Grid(this);
        }
        return this.myGrid;
    }

    public void setGrid(Grid grid) {
        if (this.myGrid == grid) {
            return;
        }
        if (this.myGrid != null) {
            this.myGrid.remove(this);
            if (this.myGrid.isEmpty()) {
                this.myGrid.saveState();
                for (IGridCache iGridCache : grid.caches.values()) {
                    iGridCache.onJoin(this.myGrid.myStorage);
                }
            }
        }
        this.myGrid = grid;
        this.myGrid.add(this);
    }

    public void validateGrid() {
        GridSplitDetector gsd = new GridSplitDetector(this.getInternalGrid().getPivot());
        this.beginVisition(gsd);
        if (!gsd.pivotFound) {
            GridPropagator gp = new GridPropagator(new Grid(this));
            this.beginVisition(gp);
        }
    }

    @Override
    public void destroy() {
        while (!this.Connections.isEmpty()) {
            GridNode otherSide;
            if (this.Connections.size() == 1) {
                this.setGridStorage(null);
            }
            IGridConnection c = this.Connections.listIterator().next();
            otherSide.getInternalGrid().pivot = otherSide = (GridNode)c.getOtherSide(this);
            c.destroy();
        }
        if (this.myGrid != null) {
            this.myGrid.remove(this);
        }
    }

    @Override
    public World getWorld() {
        return this.gridProxy.getLocation().getWorld();
    }

    @Override
    public boolean meetsChannelRequirements() {
        return !this.getGridBlock().getFlags().contains((Object)GridFlags.REQUIRE_CHANNEL) || this.getUsedChannels() > 0;
    }

    @Override
    public boolean isActive() {
        IGrid g = this.getGrid();
        if (g != null) {
            IPathingGrid pg = (IPathingGrid)g.getCache(IPathingGrid.class);
            IEnergyGrid eg = (IEnergyGrid)g.getCache(IEnergyGrid.class);
            return this.meetsChannelRequirements() && eg.isNetworkPowered() && !pg.isNetworkBooting();
        }
        return false;
    }

    @Override
    public boolean canSupportMoreChannels() {
        return this.getUsedChannels() < this.maxChannels;
    }

    @Override
    public IReadOnlyCollection<IPathItem> getPossibleOptions() {
        return (ReadOnlyCollection)this.getConnections();
    }

    public int getLastUsedChannels() {
        return this.channelData >> 8 & 0xFF;
    }

    public int getUsedChannels() {
        return this.channelData & 0xFF;
    }

    @Override
    public void incrementChannelCount(int usedChannels) {
        this.channelData += usedChannels;
    }

    public void setGridStorage(GridStorage s) {
        this.myStorage = s;
        this.channelData = 0;
    }

    public GridStorage getGridStorage() {
        return this.myStorage;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return this.getGridBlock().getFlags();
    }

    @Override
    public void finalizeChannels() {
        if (this.getFlags().contains((Object)GridFlags.CANNOT_CARRY)) {
            return;
        }
        if (this.getLastUsedChannels() != this.getUsedChannels()) {
            this.channelData &= 0xFF;
            this.channelData |= this.channelData << 8;
            if (this.getInternalGrid() != null) {
                this.getInternalGrid().postEventTo(this, event);
            }
        }
    }

    @Override
    public IPathItem getControllerRoute() {
        if (this.Connections.isEmpty() || this.getFlags().contains((Object)GridFlags.CANNOT_CARRY)) {
            return null;
        }
        return (IPathItem)((Object)this.Connections.get(0));
    }

    @Override
    public void setControllerRoute(IPathItem fast, boolean zeroOut) {
        int idx;
        if (zeroOut) {
            this.channelData &= 0xFFFFFF00;
        }
        if ((idx = this.Connections.indexOf(fast)) > 0) {
            this.Connections.remove(fast);
            this.Connections.add(0, (IGridConnection)((Object)fast));
        }
    }

    @Override
    public boolean hasFlag(GridFlags flag) {
        return this.getGridBlock().getFlags().contains((Object)flag);
    }

    @Override
    public int getPlayerID() {
        return this.playerID;
    }
}

