/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridStorage;
import appeng.core.AELog;
import appeng.core.WorldSettings;
import appeng.me.Grid;
import appeng.me.GridStorageSearch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class GridStorage
implements IGridStorage {
    IGrid myGrid = null;
    final long myID;
    final NBTTagCompound data;
    public boolean isDirty = false;
    private Set<GridStorage> divlist = new HashSet<GridStorage>();
    final GridStorageSearch mySearchEntry;

    public GridStorage(long id, GridStorageSearch gss) {
        this.myID = id;
        this.mySearchEntry = gss;
        this.data = new NBTTagCompound();
    }

    public GridStorage(String input, long id, GridStorageSearch gss) {
        this.myID = id;
        this.mySearchEntry = gss;
        NBTTagCompound myTag = null;
        try {
            byte[] dbata = DatatypeConverter.parseBase64Binary((String)input);
            myTag = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(dbata));
        }
        catch (Throwable t) {
            myTag = new NBTTagCompound();
        }
        this.data = myTag;
    }

    public GridStorage() {
        this.myID = 0L;
        this.mySearchEntry = null;
        this.data = new NBTTagCompound();
    }

    public String getValue() {
        this.isDirty = false;
        if (this.myGrid != null) {
            ((Grid)this.myGrid).saveState();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)out);
            return DatatypeConverter.printBase64Binary((byte[])out.toByteArray());
        }
        catch (IOException e) {
            AELog.error(e);
            return "";
        }
    }

    @Override
    public NBTTagCompound dataObject() {
        return this.data;
    }

    @Override
    public long getID() {
        return this.myID;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public IGrid getGrid() {
        return this.myGrid;
    }

    public void setGrid(Grid grid) {
        this.myGrid = grid;
    }

    public void addDivided(GridStorage gs) {
        this.divlist.add(gs);
    }

    public boolean hasDivided(GridStorage myStorage) {
        return this.divlist.contains(myStorage);
    }

    public void remove() {
        WorldSettings.getInstance().destroyGridStorage(this.getID());
    }
}

