/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.core.AELog;
import appeng.me.Grid;
import appeng.me.GridCacheWrapper;
import appeng.me.GridNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class NetworkEventBus {
    private static Set<Class> readClasses = new HashSet<Class>();
    private static Hashtable<Class<? extends MENetworkEvent>, Hashtable<Class, MENetworkEventInfo>> events = new Hashtable();

    public void readClass(Class listAs, Class c) {
        if (readClasses.contains(c)) {
            return;
        }
        readClasses.add(c);
        try {
            for (Method m : c.getMethods()) {
                MENetworkEventSubscribe s = m.getAnnotation(MENetworkEventSubscribe.class);
                if (s == null) continue;
                Class<?>[] types = m.getParameterTypes();
                if (types.length == 1) {
                    if (MENetworkEvent.class.isAssignableFrom(types[0])) {
                        MENetworkEventInfo thisEvent;
                        Hashtable<Class<Object>, MENetworkEventInfo> classEvents = events.get(types[0]);
                        if (classEvents == null) {
                            classEvents = new Hashtable();
                            events.put(types[0], classEvents);
                        }
                        if ((thisEvent = classEvents.get(listAs)) == null) {
                            thisEvent = new MENetworkEventInfo();
                        }
                        thisEvent.Add(types[0], c, m);
                        classEvents.put(listAs, thisEvent);
                        continue;
                    }
                    throw new RuntimeException("Invalid ME Network Event Subscriber, " + m.getName() + "s Parameter must extend MENetworkEvent.");
                }
                throw new RuntimeException("Invalid ME Network Event Subscriber, " + m.getName() + " must have exactly 1 parameter.");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error while adding " + c.getName() + " to event bus", t);
        }
    }

    public MENetworkEvent postEvent(Grid g, MENetworkEvent e) {
        Hashtable<Class, MENetworkEventInfo> subscribers = events.get(e.getClass());
        int x = 0;
        try {
            if (subscribers != null) {
                for (Class o : subscribers.keySet()) {
                    MENetworkEventInfo target = subscribers.get(o);
                    GridCacheWrapper cache = g.caches.get(o);
                    if (cache != null) {
                        ++x;
                        target.invoke(cache.myCache, e);
                    }
                    for (IGridNode obj : g.getMachines(o)) {
                        ++x;
                        target.invoke(obj.getMachine(), e);
                    }
                }
            }
        }
        catch (NetworkEventDone done) {
            // empty catch block
        }
        e.setVisitedObjects(x);
        return e;
    }

    public MENetworkEvent postEventTo(Grid grid, GridNode node, MENetworkEvent e) {
        Hashtable<Class, MENetworkEventInfo> subscribers = events.get(e.getClass());
        int x = 0;
        try {
            MENetworkEventInfo target;
            if (subscribers != null && (target = subscribers.get(node.getMachineClass())) != null) {
                ++x;
                target.invoke(node.getMachine(), e);
            }
        }
        catch (NetworkEventDone done) {
            // empty catch block
        }
        e.setVisitedObjects(x);
        return e;
    }

    class MENetworkEventInfo {
        private ArrayList<EventMethod> methods = new ArrayList();

        MENetworkEventInfo() {
        }

        public void Add(Class Event2, Class ObjClass, Method ObjMethod) {
            this.methods.add(new EventMethod(Event2, ObjClass, ObjMethod));
        }

        public void invoke(Object obj, MENetworkEvent e) throws NetworkEventDone {
            for (EventMethod em : this.methods) {
                em.invoke(obj, e);
            }
        }
    }

    class EventMethod {
        public final Class objClass;
        public final Method objMethod;
        public final Class objEvent;

        public EventMethod(Class Event2, Class ObjClass, Method ObjMethod) {
            this.objClass = ObjClass;
            this.objMethod = ObjMethod;
            this.objEvent = Event2;
        }

        public void invoke(Object obj, MENetworkEvent e) throws NetworkEventDone {
            try {
                this.objMethod.invoke(obj, e);
            }
            catch (Throwable e1) {
                AELog.severe("[AppEng] Network Event caused exception:", new Object[0]);
                AELog.severe("Offending Class: " + obj.getClass().getName(), new Object[0]);
                AELog.severe("Offending Object: " + obj.toString(), new Object[0]);
                AELog.error(e1);
                throw new RuntimeException(e1);
            }
            if (e.isCanceled()) {
                throw new NetworkEventDone();
            }
        }
    }

    class NetworkEventDone
    extends Throwable {
        private static final long serialVersionUID = -3079021487019171205L;

        NetworkEventDone() {
        }
    }
}

