/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.CraftingJob;
import appeng.crafting.CraftingLink;
import appeng.crafting.CraftingLinkNexus;
import appeng.crafting.CraftingWatcher;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.GenericInterestManager;
import appeng.me.storage.ItemWatcher;
import appeng.tile.crafting.TileCraftingStorageTile;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.ItemSorters;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.minecraft.world.World;

public class CraftingGridCache
implements ICraftingGrid,
ICraftingProviderHelper,
ICellProvider,
IMEInventoryHandler {
    HashSet<CraftingCPUCluster> cpuClusters = new HashSet();
    HashSet<ICraftingProvider> providers = new HashSet();
    private HashMap<IGridNode, ICraftingWatcher> watchers = new HashMap();
    IGrid grid;
    IStorageGrid sg;
    IEnergyGrid eg;
    HashMap<ICraftingPatternDetails, List<ICraftingMedium>> craftingMethods = new HashMap();
    HashMap<IAEItemStack, ImmutableList<ICraftingPatternDetails>> craftableItems = new HashMap();
    HashSet<IAEItemStack> emitableItems = new HashSet();
    HashMap<String, CraftingLinkNexus> links = new HashMap();
    boolean updateList = false;
    private final SetMultimap<IAEStack, ItemWatcher> interests = HashMultimap.create();
    public final GenericInterestManager interestManager = new GenericInterestManager<ItemWatcher>(this.interests);
    public static final ExecutorService craftingPool;

    @Override
    public ImmutableSet<ICraftingCPU> getCpus() {
        return ImmutableSet.copyOf((Iterator)new ActiveCpuIterator(this.cpuClusters));
    }

    public CraftingGridCache(IGrid g) {
        this.grid = g;
    }

    @MENetworkEventSubscribe
    public void afterCacheConstruction(MENetworkPostCacheConstruction cc) {
        this.sg = (IStorageGrid)this.grid.getCache(IStorageGrid.class);
        this.eg = (IEnergyGrid)this.grid.getCache(IEnergyGrid.class);
        this.sg.registerCellProvider(this);
    }

    public void addLink(CraftingLink l) {
        if (l.isStandalone()) {
            return;
        }
        CraftingLinkNexus n = this.links.get(l.getCraftingID());
        if (n == null) {
            n = new CraftingLinkNexus(l.getCraftingID());
            this.links.put(l.getCraftingID(), n);
        }
        l.setNextus(n);
    }

    @Override
    public void onUpdateTick() {
        if (this.updateList) {
            this.updateList = false;
            this.updateCPUClusters();
        }
        Iterator<CraftingLinkNexus> i = this.links.values().iterator();
        while (i.hasNext()) {
            if (!i.next().isDead(this.grid, this)) continue;
            i.remove();
        }
        for (CraftingCPUCluster cpu : this.cpuClusters) {
            cpu.updateCraftingLogic(this.grid, this.eg, this);
        }
    }

    @MENetworkEventSubscribe
    public void updateCPUClusters(MENetworkCraftingCpuChange c) {
        this.updateList = true;
    }

    @MENetworkEventSubscribe
    public void updateCPUClusters(MENetworkCraftingPatternChange c) {
        this.updatePatterns();
    }

    @Override
    public void removeNode(IGridNode gridNode, IGridHost machine) {
        ICraftingWatcher myWatcher;
        if (machine instanceof ICraftingWatcherHost && (myWatcher = this.watchers.get(machine)) != null) {
            myWatcher.clear();
            this.watchers.remove(machine);
        }
        if (machine instanceof ICraftingRequester) {
            for (CraftingLinkNexus n : this.links.values()) {
                if (!n.isMachine(machine)) continue;
                n.removeNode();
            }
        }
        if (machine instanceof TileCraftingTile) {
            this.updateList = true;
        }
        if (machine instanceof ICraftingProvider) {
            this.providers.remove(machine);
            this.updatePatterns();
        }
    }

    @Override
    public void addNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof ICraftingWatcherHost) {
            ICraftingWatcherHost swh = (ICraftingWatcherHost)((Object)machine);
            CraftingWatcher iw = new CraftingWatcher(this, swh);
            this.watchers.put(gridNode, iw);
            swh.updateWatcher(iw);
        }
        if (machine instanceof ICraftingRequester) {
            for (ICraftingLink l : ((ICraftingRequester)machine).getRequestedJobs()) {
                if (!(l instanceof CraftingLink)) continue;
                this.addLink((CraftingLink)l);
            }
        }
        if (machine instanceof TileCraftingTile) {
            this.updateList = true;
        }
        if (machine instanceof ICraftingProvider) {
            this.providers.add((ICraftingProvider)((Object)machine));
            this.updatePatterns();
        }
    }

    private void updateCPUClusters() {
        this.cpuClusters.clear();
        for (IGridNode cst : this.grid.getMachines(TileCraftingStorageTile.class)) {
            TileCraftingStorageTile tile = (TileCraftingStorageTile)cst.getMachine();
            CraftingCPUCluster clust = (CraftingCPUCluster)tile.getCluster();
            if (clust == null) continue;
            this.cpuClusters.add(clust);
            if (clust.myLastLink == null) continue;
            this.addLink((CraftingLink)clust.myLastLink);
        }
    }

    @Override
    public void addCraftingOption(ICraftingMedium medium, ICraftingPatternDetails api) {
        List<ICraftingMedium> details = this.craftingMethods.get(api);
        if (details == null) {
            details = new ArrayList<ICraftingMedium>();
            details.add(medium);
            this.craftingMethods.put(api, details);
        } else {
            details.add(medium);
        }
    }

    private void updatePatterns() {
        HashMap<IAEItemStack, ImmutableList<ICraftingPatternDetails>> oldItems = this.craftableItems;
        this.craftingMethods.clear();
        this.craftableItems = new HashMap();
        this.emitableItems.clear();
        this.sg.postAlterationOfStoredItems(StorageChannel.ITEMS, oldItems.keySet(), new BaseActionSource());
        for (ICraftingProvider cp : this.providers) {
            cp.provideCrafting(this);
        }
        HashMap<IAEItemStack, HashSet<ICraftingPatternDetails>> tmpCraft = new HashMap<IAEItemStack, HashSet<ICraftingPatternDetails>>();
        for (ICraftingPatternDetails iCraftingPatternDetails : this.craftingMethods.keySet()) {
            for (IAEItemStack out : iCraftingPatternDetails.getOutputs()) {
                out = out.copy();
                out.reset();
                out.setCraftable(true);
                HashSet<ICraftingPatternDetails> methods = (HashSet<ICraftingPatternDetails>)tmpCraft.get(out);
                if (methods == null) {
                    methods = new HashSet<ICraftingPatternDetails>();
                    tmpCraft.put(out, methods);
                }
                methods.add(iCraftingPatternDetails);
            }
        }
        for (Map.Entry entry : tmpCraft.entrySet()) {
            this.craftableItems.put((IAEItemStack)entry.getKey(), (ImmutableList<ICraftingPatternDetails>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
        this.sg.postAlterationOfStoredItems(StorageChannel.ITEMS, this.craftableItems.keySet(), new BaseActionSource());
    }

    @Override
    public void onSplit(IGridStorage destinationStorage) {
    }

    @Override
    public void onJoin(IGridStorage sourceStorage) {
    }

    @Override
    public void populateGridStorage(IGridStorage destinationStorage) {
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>(1);
        if (channel == StorageChannel.ITEMS) {
            list.add(this);
        }
        return list;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public IAEStack extractItems(IAEStack request, Actionable mode, BaseActionSource src) {
        return null;
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        for (IAEItemStack st : this.craftableItems.keySet()) {
            out.addCrafting(st);
        }
        for (IAEItemStack st : this.emitableItems) {
            out.addCrafting(st);
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.WRITE;
    }

    public boolean isPrioritized(IAEStack input) {
        return true;
    }

    @Override
    public IAEStack injectItems(IAEStack input, Actionable type, BaseActionSource src) {
        for (CraftingCPUCluster cpu : this.cpuClusters) {
            input = cpu.injectItems(input, type, src);
        }
        return input;
    }

    public boolean canAccept(IAEStack input) {
        for (CraftingCPUCluster cpu : this.cpuClusters) {
            if (!cpu.canAccept((IAEItemStack)input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICraftingLink submitJob(ICraftingJob job, ICraftingRequester requestingMachine, ICraftingCPU target, final boolean prioritizePower, BaseActionSource src) {
        if (job.isSimulation()) {
            return null;
        }
        CraftingCPUCluster cpuClust = null;
        if (target instanceof CraftingCPUCluster) {
            cpuClust = (CraftingCPUCluster)target;
        }
        if (target == null) {
            ArrayList<CraftingCPUCluster> validCpusClusters = new ArrayList<CraftingCPUCluster>();
            for (CraftingCPUCluster cpu : this.cpuClusters) {
                if (!cpu.isActive() || cpu.isBusy() || cpu.getAvailableStorage() < job.getByteTotal()) continue;
                validCpusClusters.add(cpu);
            }
            Collections.sort(validCpusClusters, new Comparator<CraftingCPUCluster>(){

                @Override
                public int compare(CraftingCPUCluster o1, CraftingCPUCluster o2) {
                    if (prioritizePower) {
                        int a = ItemSorters.compareLong(o2.getCoProcessors(), o1.getCoProcessors());
                        if (a != 0) {
                            return a;
                        }
                        return ItemSorters.compareLong(o2.getAvailableStorage(), o1.getAvailableStorage());
                    }
                    int a = ItemSorters.compareLong(o1.getCoProcessors(), o2.getCoProcessors());
                    if (a != 0) {
                        return a;
                    }
                    return ItemSorters.compareLong(o1.getAvailableStorage(), o2.getAvailableStorage());
                }
            });
            if (!validCpusClusters.isEmpty()) {
                cpuClust = (CraftingCPUCluster)validCpusClusters.get(0);
            }
        }
        if (cpuClust != null) {
            return cpuClust.submitJob(this.grid, job, src, requestingMachine);
        }
        return null;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public ImmutableCollection<ICraftingPatternDetails> getCraftingFor(IAEItemStack whatToCraft, ICraftingPatternDetails details, int slotIndex, World world) {
        ImmutableList<ICraftingPatternDetails> res = this.craftableItems.get(whatToCraft);
        if (res == null) {
            if (details != null && details.isCraftable()) {
                for (IAEItemStack ais : this.craftableItems.keySet()) {
                    if (ais.getItem() != whatToCraft.getItem() || ais.getItem().func_77614_k() && ais.getItemDamage() != whatToCraft.getItemDamage() || !details.isValidItemForSlot(slotIndex, ais.getItemStack(), world)) continue;
                    return (ImmutableCollection)this.craftableItems.get(ais);
                }
            }
            return ImmutableSet.of();
        }
        return res;
    }

    public List<ICraftingMedium> getMediums(ICraftingPatternDetails key) {
        ImmutableList o = this.craftingMethods.get(key);
        if (o == null) {
            o = ImmutableList.of();
        }
        return o;
    }

    @Override
    public boolean validForPass(int i) {
        return i == 1;
    }

    @Override
    public Future<ICraftingJob> beginCraftingJob(World world, IGrid grid, BaseActionSource actionSrc, IAEItemStack slotItem, ICraftingCallback cb) {
        if (world == null || grid == null || actionSrc == null || slotItem == null) {
            throw new RuntimeException("Invalid Craftinb Job Request");
        }
        CraftingJob cj = new CraftingJob(world, grid, actionSrc, slotItem, cb);
        return craftingPool.submit(cj, cj);
    }

    public boolean hasCpu(ICraftingCPU cpu) {
        return this.cpuClusters.contains(cpu);
    }

    @Override
    public boolean isRequesting(IAEItemStack what) {
        for (CraftingCPUCluster c : this.cpuClusters) {
            if (!c.isMaking(what)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canEmitFor(IAEItemStack what) {
        return this.emitableItems.contains(what);
    }

    @Override
    public void setEmitable(IAEItemStack what) {
        this.emitableItems.add(what.copy());
    }

    static {
        ThreadFactory factory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable ar) {
                return new Thread(ar, "AE Crafting Calculator");
            }
        };
        craftingPool = Executors.newCachedThreadPool(factory);
    }

    class ActiveCpuIterator
    implements Iterator<ICraftingCPU> {
        final Iterator<CraftingCPUCluster> i;
        CraftingCPUCluster c = null;

        public ActiveCpuIterator(Collection<CraftingCPUCluster> o) {
            this.i = o.iterator();
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.c != null;
        }

        private void findNext() {
            while (this.i.hasNext() && this.c == null) {
                this.c = this.i.next();
                if (this.c.isActive() && !this.c.isDestroyed) continue;
                this.c = null;
            }
        }

        @Override
        public ICraftingCPU next() {
            CraftingCPUCluster o = this.c;
            this.c = null;
            return o;
        }

        @Override
        public void remove() {
        }
    }
}

