/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelChanged;
import appeng.api.networking.events.MENetworkControllerChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import appeng.me.pathfinding.AdHocChannelUpdater;
import appeng.me.pathfinding.ControllerChannelUpdater;
import appeng.me.pathfinding.ControllerValidator;
import appeng.me.pathfinding.IPathItem;
import appeng.me.pathfinding.PathSegment;
import appeng.tile.networking.TileController;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraftforge.common.util.ForgeDirection;

public class PathGridCache
implements IPathingGrid {
    boolean recalculateControllerNextTick = true;
    boolean updateNetwork = true;
    boolean booting = false;
    final LinkedList<PathSegment> active = new LinkedList();
    ControllerState controllerState = ControllerState.NO_CONTROLLER;
    int instance = Integer.MIN_VALUE;
    int ticksUntilReady = 20;
    final Set<TileController> controllers = new HashSet<TileController>();
    final Set<IGridNode> requireChannels = new HashSet<IGridNode>();
    final Set<IGridNode> blockDense = new HashSet<IGridNode>();
    final IGrid myGrid;
    private HashSet<IPathItem> semiOpen = new HashSet();
    private HashSet<IPathItem> closedList = new HashSet();
    public int channelsByBlocks = 0;
    public double channelPowerUsage = 0.0;

    public PathGridCache(IGrid g) {
        this.myGrid = g;
    }

    @Override
    public void onUpdateTick() {
        if (this.recalculateControllerNextTick) {
            this.recalcController();
        }
        if (this.updateNetwork) {
            if (!this.booting) {
                this.myGrid.postEvent(new MENetworkBootingStatusChange());
            }
            this.booting = true;
            this.updateNetwork = false;
            ++this.instance;
            if (this.controllerState == ControllerState.NO_CONTROLLER) {
                int requiredChannels;
                int used = requiredChannels = this.calculateRequiredChanels();
                if (requiredChannels > 8) {
                    used = 0;
                }
                int nodes = this.myGrid.getNodes().size();
                this.ticksUntilReady = 20 + Math.max(0, nodes / 100 - 20);
                this.channelsByBlocks = nodes * used;
                this.channelPowerUsage = (double)this.channelsByBlocks / 128.0;
                this.myGrid.getPivot().beginVisition(new AdHocChannelUpdater(used));
            } else if (this.controllerState == ControllerState.CONTROLLER_CONFLICT) {
                this.ticksUntilReady = 20;
                this.myGrid.getPivot().beginVisition(new AdHocChannelUpdater(0));
            } else {
                int nodes = this.myGrid.getNodes().size();
                this.ticksUntilReady = 20 + Math.max(0, nodes / 100 - 20);
                this.closedList = new HashSet();
                this.semiOpen = new HashSet();
                for (IGridNode node : this.myGrid.getMachines(TileController.class)) {
                    this.closedList.add((IPathItem)((Object)node));
                    for (IGridConnection gcc : node.getConnections()) {
                        GridConnection gc = (GridConnection)gcc;
                        if (gc.getOtherSide(node).getMachine() instanceof TileController) continue;
                        LinkedList<GridConnection> open = new LinkedList<GridConnection>();
                        this.closedList.add(gc);
                        open.add(gc);
                        gc.setControllerRoute((GridNode)node, true);
                        this.active.add(new PathSegment(this, open, this.semiOpen, this.closedList));
                    }
                }
            }
        }
        if (!this.active.isEmpty() || this.ticksUntilReady > 0) {
            Iterator i = this.active.iterator();
            while (i.hasNext()) {
                PathSegment pat = (PathSegment)i.next();
                if (!pat.step()) continue;
                pat.isDead = true;
                i.remove();
            }
            --this.ticksUntilReady;
            if (this.active.isEmpty() && this.ticksUntilReady <= 0) {
                Iterator<TileController> i$;
                if (this.controllerState == ControllerState.CONTROLLER_ONLINE && (i$ = this.controllers.iterator()).hasNext()) {
                    TileController tc = i$.next();
                    tc.getGridNode(ForgeDirection.UNKNOWN).beginVisition(new ControllerChannelUpdater());
                }
                this.booting = false;
                this.channelPowerUsage = (double)this.channelsByBlocks / 128.0;
                this.myGrid.postEvent(new MENetworkBootingStatusChange());
            }
        }
    }

    private int calculateRequiredChanels() {
        int depth = 0;
        this.semiOpen.clear();
        for (IGridNode nodes : this.requireChannels) {
            if (this.semiOpen.contains(nodes)) continue;
            IGridBlock gb = nodes.getGridBlock();
            EnumSet<GridFlags> flags = gb.getFlags();
            if (flags.contains((Object)GridFlags.COMPRESSED_CHANNEL) && !this.blockDense.isEmpty()) {
                return 9;
            }
            ++depth;
            if (!flags.contains((Object)GridFlags.MULTIBLOCK)) continue;
            IGridMultiblock gmb = (IGridMultiblock)gb;
            Iterator<IGridNode> i = gmb.getMultiblockNodes();
            while (i.hasNext()) {
                this.semiOpen.add((IPathItem)((Object)i.next()));
            }
        }
        return depth;
    }

    @Override
    public void repath() {
        this.active.clear();
        this.channelsByBlocks = 0;
        this.updateNetwork = true;
    }

    @Override
    public void removeNode(IGridNode gridNode, IGridHost machine) {
        EnumSet<GridFlags> flags;
        if (machine instanceof TileController) {
            this.controllers.remove(machine);
            this.recalculateControllerNextTick = true;
        }
        if ((flags = gridNode.getGridBlock().getFlags()).contains((Object)GridFlags.REQUIRE_CHANNEL)) {
            this.requireChannels.remove(gridNode);
        }
        if (flags.contains((Object)GridFlags.CANNOT_CARRY_COMPRESSED)) {
            this.blockDense.remove(gridNode);
        }
        this.repath();
    }

    @Override
    public void addNode(IGridNode gridNode, IGridHost machine) {
        EnumSet<GridFlags> flags;
        if (machine instanceof TileController) {
            this.controllers.add((TileController)machine);
            this.recalculateControllerNextTick = true;
        }
        if ((flags = gridNode.getGridBlock().getFlags()).contains((Object)GridFlags.REQUIRE_CHANNEL)) {
            this.requireChannels.add(gridNode);
        }
        if (flags.contains((Object)GridFlags.CANNOT_CARRY_COMPRESSED)) {
            this.blockDense.add(gridNode);
        }
        this.repath();
    }

    @MENetworkEventSubscribe
    void updateNodReq(MENetworkChannelChanged ev) {
        IGridNode gridNode = ev.node;
        if (gridNode.getGridBlock().getFlags().contains((Object)GridFlags.REQUIRE_CHANNEL)) {
            this.requireChannels.add(gridNode);
        } else {
            this.requireChannels.remove(gridNode);
        }
        this.repath();
    }

    private void recalcController() {
        this.recalculateControllerNextTick = false;
        ControllerState old = this.controllerState;
        if (this.controllers.isEmpty()) {
            this.controllerState = ControllerState.NO_CONTROLLER;
        } else {
            IGridNode startingNode = this.controllers.iterator().next().getGridNode(ForgeDirection.UNKNOWN);
            if (startingNode == null) {
                this.controllerState = ControllerState.CONTROLLER_CONFLICT;
                return;
            }
            DimensionalCoord dc = startingNode.getGridBlock().getLocation();
            ControllerValidator cv = new ControllerValidator(dc.x, dc.y, dc.z);
            startingNode.beginVisition(cv);
            this.controllerState = cv.isValid && cv.found == this.controllers.size() ? ControllerState.CONTROLLER_ONLINE : ControllerState.CONTROLLER_CONFLICT;
        }
        if (old != this.controllerState) {
            this.myGrid.postEvent(new MENetworkControllerChange());
        }
    }

    @Override
    public ControllerState getControllerState() {
        return this.controllerState;
    }

    @Override
    public boolean isNetworkBooting() {
        return !this.active.isEmpty() && !this.booting;
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }
}

