/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster;

import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.util.Platform;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MBCalculator {
    private final IAEMultiBlock target;

    public MBCalculator(IAEMultiBlock t) {
        this.target = t;
    }

    public abstract boolean isValidTile(TileEntity var1);

    public abstract IAECluster createCluster(World var1, WorldCoord var2, WorldCoord var3);

    public abstract void updateTiles(IAECluster var1, World var2, WorldCoord var3, WorldCoord var4);

    public abstract void disconnect();

    public abstract boolean checkMultiblockScale(WorldCoord var1, WorldCoord var2);

    public boolean isValidTileAt(World w, int x, int y, int z) {
        return this.isValidTile(w.func_147438_o(x, y, z));
    }

    public void calculateMultiblock(World worldObj, WorldCoord loc) {
        block14: {
            if (Platform.isClient()) {
                return;
            }
            try {
                WorldCoord min = loc.copy();
                WorldCoord max = loc.copy();
                World w = worldObj;
                while (this.isValidTileAt(w, min.x - 1, min.y, min.z)) {
                    --min.x;
                }
                while (this.isValidTileAt(w, min.x, min.y - 1, min.z)) {
                    --min.y;
                }
                while (this.isValidTileAt(w, min.x, min.y, min.z - 1)) {
                    --min.z;
                }
                while (this.isValidTileAt(w, max.x + 1, max.y, max.z)) {
                    ++max.x;
                }
                while (this.isValidTileAt(w, max.x, max.y + 1, max.z)) {
                    ++max.y;
                }
                while (this.isValidTileAt(w, max.x, max.y, max.z + 1)) {
                    ++max.z;
                }
                if (!this.checkMultiblockScale(min, max) || !this.verifyUnownedRegion(w, min, max)) break block14;
                IAECluster c = this.createCluster(w, min, max);
                try {
                    if (!this.verifyInternalStructure(worldObj, min, max)) {
                        this.disconnect();
                        return;
                    }
                }
                catch (Exception err) {
                    this.disconnect();
                    return;
                }
                boolean updateGrid = false;
                IAECluster clust = this.target.getCluster();
                if (clust == null) {
                    this.updateTiles(c, w, min, max);
                    updateGrid = true;
                } else {
                    c = clust;
                }
                c.updateStatus(updateGrid);
                return;
            }
            catch (Throwable err) {
                AELog.error(err);
            }
        }
        this.disconnect();
    }

    public abstract boolean verifyInternalStructure(World var1, WorldCoord var2, WorldCoord var3);

    public boolean verifyUnownedRegionInner(World w, int minx, int miny, int minz, int maxx, int maxy, int maxz, ForgeDirection side) {
        switch (side) {
            case WEST: {
                maxx = --minx;
                break;
            }
            case EAST: {
                minx = ++maxx;
                break;
            }
            case DOWN: {
                maxy = --miny;
                break;
            }
            case NORTH: {
                minz = ++maxz;
                break;
            }
            case SOUTH: {
                maxz = --minz;
                break;
            }
            case UP: {
                miny = ++maxy;
                break;
            }
            case UNKNOWN: {
                return false;
            }
        }
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                for (int z = minz; z <= maxz; ++z) {
                    TileEntity te = w.func_147438_o(x, y, z);
                    if (!this.isValidTile(te)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean verifyUnownedRegion(World w, WorldCoord min, WorldCoord max) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.verifyUnownedRegionInner(w, min.x, min.y, min.z, max.x, max.y, max.z, side)) continue;
            return false;
        }
        return true;
    }
}

